/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.configfile;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.parser.ConfigParser;
import com.excentis.security.utils.CertUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class CommandLine {
    public static void main(String[] args) {
        try {
            String outputfile;
            String method;
            ConfigFile cfg = new ConfigFile();
            if (args.length < 2 || args.length > 6) {
                System.err.println("Invalid number of arguments");
                CommandLine.printUsageAndExit();
            }
            ArrayList<String> argslist = new ArrayList<String>();
            for (String arg : args) {
                if (arg.startsWith("-")) {
                    if (!arg.equals("-cheat")) {
                        System.err.println("unknown option " + arg + ", only -cheat supported");
                        CommandLine.printUsageAndExit();
                        continue;
                    }
                    cfg.cheat();
                    continue;
                }
                argslist.add(arg);
            }
            Iterator argsit = argslist.iterator();
            if (argslist.size() < 2 || argslist.size() > 5) {
                System.err.println("Invalid number of arguments");
                CommandLine.printUsageAndExit();
            }
            if ((method = (String)argsit.next()).equals("text2bin")) {
                String inputfile = (String)argsit.next();
                if (!argsit.hasNext()) {
                    System.err.println("text2bin requires at least input and output filename");
                    CommandLine.printUsageAndExit();
                }
                outputfile = (String)argsit.next();
                cfg = new ConfigFile(ConfigParser.parseFromString(new String(CertUtils.readFile(new File(inputfile)))).getEncoded());
                if (argsit.hasNext()) {
                    String sharedsecret = (String)argsit.next();
                    if (argsit.hasNext()) {
                        cfg.saveTLV(outputfile, sharedsecret, (String)argsit.next());
                    } else {
                        cfg.saveTLV(outputfile, sharedsecret);
                    }
                } else {
                    cfg.saveTLV(outputfile, "Euro");
                }
            } else if (method.equals("bin2text")) {
                String inputfile = (String)argsit.next();
                if (!argsit.hasNext()) {
                    System.err.println("bin2text requires at least input and output filename");
                    CommandLine.printUsageAndExit();
                }
                outputfile = (String)argsit.next();
                cfg.readBinaryFile(inputfile);
                cfg.saveTXT(outputfile, ".");
            } else if (method.equals("showfile")) {
                String inputfile = (String)argsit.next();
                cfg.readBinaryFile(inputfile);
                System.out.println(cfg.writeToString("."));
            } else {
                System.err.println("unknown method " + args[0] + ", only text2bin, bin2text and showfile are implemented.");
                CommandLine.printUsageAndExit();
            }
        }
        catch (Exception e) {
            System.err.println("exception: " + e);
        }
    }

    public static void printUsageAndExit() {
        System.out.println("usage: java -classpath coupe.jar com.excentis.configfile.CommandLine text2bin/bin2text/showfile [-cheat] inputfilename [outputfilename] [sharedsecret] [extendedsharedsecret]");
        System.out.println("e.g. 1: java -classpath coupe.jar com.excentis.configfile.CommandLine text2bin basic.txt basic.cfg Euro ExtendedEuro");
        System.out.println("e.g. 2: java -classpath coupe.jar com.excentis.configfile.CommandLine showfile basic.cfg");
        System.out.println("e.g. 3: java -classpath coupe.jar com.excentis.configfile.CommandLine text2bin -cheat cfg_with_generics.txt generic.cfg Euro ExtendedEuro");
        System.exit(0);
    }
}

