/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.filedialog;

import com.excentis.filedialog.FileSelector;
import com.excentis.filedialog.JFileSelector;
import com.excentis.filedialog.NativeFileSelector;
import java.awt.Frame;
import java.io.File;

public class FileSelectorFactory {
    private static FileSelectorFactory instance = null;

    protected FileSelectorFactory() {
    }

    public FileSelector create(Frame comp, String path) {
        if (FileSelectorFactory.isMac()) {
            return new NativeFileSelector(new File(path), comp);
        }
        return new JFileSelector(new File(path), comp);
    }

    public static FileSelectorFactory getInstance() {
        if (instance == null) {
            instance = new FileSelectorFactory();
        }
        return instance;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    }
}

