/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.filedialog;

import com.excentis.filedialog.FileSelector;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;

public class NativeFileSelector
implements FileSelector {
    private FileDialog dialog;
    private File path;

    public NativeFileSelector(File inpath, Frame inParent) {
        this.dialog = new FileDialog(inParent);
        this.dialog.setVisible(false);
        this.path = inpath;
    }

    @Override
    public int showOpenDialog() {
        this.dialog.setMode(0);
        this.dialog.setTitle("Open");
        this.dialog.setDirectory(this.path.getAbsolutePath());
        this.dialog.setVisible(true);
        this.dialog.setAlwaysOnTop(true);
        if (this.dialog.getFile() == null) {
            return 1;
        }
        return 0;
    }

    @Override
    public int showSaveDialog() {
        this.dialog.setMode(1);
        this.dialog.setDirectory(this.path.getAbsolutePath());
        this.dialog.setTitle("Save");
        this.dialog.setVisible(true);
        String result = this.dialog.getFile();
        if (result == null) {
            return 1;
        }
        return 0;
    }

    @Override
    public File getSelectedFile() {
        if (this.dialog.getFile() != null) {
            return new File(new File(this.dialog.getDirectory()), this.dialog.getFile());
        }
        return null;
    }

    @Override
    public File getSelectedDirectory() {
        return new File(this.dialog.getDirectory());
    }

    @Override
    public void setSelectedFile(String filename) {
        this.dialog.setFile(filename);
    }
}

