/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.codefile;

import com.excentis.security.tools.Binary2Plaintext;
import java.io.ByteArrayOutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.UTCTime;
import org.mozilla.jss.pkcs7.Attribute;
import org.mozilla.jss.pkcs7.ContentInfo;

public class AuthAttrib {
    private static final OBJECT_IDENTIFIER CONTENT_TYPE = OBJECT_IDENTIFIER.PKCS.subBranch(9L).subBranch(3L);
    private static final OBJECT_IDENTIFIER MESSAGE_DIGEST = OBJECT_IDENTIFIER.PKCS.subBranch(9L).subBranch(4L);
    private static final OBJECT_IDENTIFIER SIGNING_TIME = OBJECT_IDENTIFIER.PKCS.subBranch(9L).subBranch(5L);
    private Date signingDate = null;
    private byte[] itsDigest = null;

    public AuthAttrib(Date signDate, byte[] dig) {
        this.signingDate = signDate;
        this.itsDigest = dig;
    }

    public byte[] getEncoded() {
        byte[] almost = this.getInputForDigesting();
        almost[0] = -96;
        return almost;
    }

    public byte[] getInputForDigesting() {
        SET authenticatedAttributes = new SET();
        UTCTime tijd = new UTCTime(this.signingDate);
        Attribute stime = new Attribute(SIGNING_TIME, tijd);
        authenticatedAttributes.addElement(stime);
        Attribute attrib = new Attribute(CONTENT_TYPE, ContentInfo.DATA);
        authenticatedAttributes.addElement(attrib);
        attrib = new Attribute(MESSAGE_DIGEST, new OCTET_STRING(this.itsDigest));
        authenticatedAttributes.addElement(attrib);
        return ASN1Util.encode(authenticatedAttributes);
    }

    private static GregorianCalendar getSigningTime(String date) {
        GregorianCalendar gc;
        if (date == null) {
            gc = new GregorianCalendar();
        } else {
            gc = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            int year = new Integer(date.substring(0, 4));
            int month = new Integer(date.substring(4, 6));
            int day = new Integer(date.substring(6, 8));
            int hour = new Integer(date.substring(8, 10));
            int minute = new Integer(date.substring(10, 12));
            int second = new Integer(date.substring(12, 14));
            gc.set(year, month - 1, day, hour, minute, second);
        }
        return gc;
    }

    public static void main(String[] args) {
        GregorianCalendar gc = AuthAttrib.getSigningTime("20151222145312");
        Date d = gc.getTime();
        System.out.println("using date: " + d);
        UTCTime tijd = new UTCTime(d);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            tijd.encode(bos);
        }
        catch (Exception e) {
            System.out.println("error encoding:" + e.getMessage());
        }
        System.out.println("which is utc: " + new Binary2Plaintext(bos.toByteArray()).getHexRepresentation());
        System.out.println("in writing: " + new String(bos.toByteArray()));
    }
}

