/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.codefile;

import com.excentis.security.codefile.CodeFileParsingException;
import com.excentis.security.codefile.CodeFileSigningException;
import com.excentis.security.codefile.SigInfo;
import com.excentis.security.utils.CertUtils;
import com.excentis.security.utils.DocsisMode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkcs7.ContentInfo;
import org.mozilla.jss.pkcs7.SignedData;
import org.mozilla.jss.pkcs7.SignerInfo;
import org.mozilla.jss.pkix.cert.Certificate;

public class CodeFile {
    public static final int SEQUENCE = 48;
    public static final int SET = 49;
    public static final int INTEGER = 2;
    public static final int OCTET_STRING = 4;
    public static final int HEADER = 160;
    public static final int EXPLICIT_SET = 161;
    private byte[] itsSerial = new byte[]{2, 1, 1};
    private byte[] itsDigestAlg_sha1 = new byte[]{48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0};
    private byte[] itsDigestAlg_sha256 = new byte[]{48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0};
    private byte[] itsSDataType = new byte[]{6, 9, 42, -122, 72, -122, -9, 13, 1, 7, 2};
    private byte[] itsDataType = new byte[]{6, 9, 42, -122, 72, -122, -9, 13, 1, 7, 1};
    private byte[] itsSignedData = null;
    private byte[] itsImage = null;
    private byte[] itsManufacturerCVC = null;
    private byte[] itsCosignerCVC = null;
    private byte[] itsManufacturerCVCChain = null;
    private byte[] itsCosignerCVCChain = null;
    private SigInfo itsManufSigInfo = null;
    private SigInfo itsCoSigInfo = null;
    private int itsDocsisMode;

    public static CodeFile createFromImage(byte[] codefile, int docsismode) throws CodeFileParsingException {
        try {
            return new CodeFile(codefile, true, docsismode);
        }
        catch (CodeFileParsingException e) {
            return new CodeFile(codefile, false, docsismode);
        }
    }

    public static CodeFile createDegenerateStructure() {
        CodeFile cod = new CodeFile(DocsisMode.DOCSIS_31);
        return cod;
    }

    private CodeFile(int docsismode) {
        this.itsDocsisMode = docsismode;
    }

    public CodeFile(byte[] codefile, boolean signedDataPresent, int docsismode) throws CodeFileParsingException {
        this.itsDocsisMode = docsismode;
        if (signedDataPresent) {
            int totallength = codefile.length;
            int current = 0;
            if (codefile[current++] != 48) {
                throw new CodeFileParsingException("Error parsing code file, doesn't start with ContentInfo!  Unsigned image?");
            }
            String temp = Integer.toHexString(codefile[current++]);
            String code = "";
            code = temp.length() == 1 ? code.concat("0" + temp) : (temp.length() == 8 ? code.concat(temp.substring(6, 8)) : code.concat(temp));
            int actuallen = 0;
            int headerlength = 0;
            if (code.equals("81")) {
                if ((actuallen = codefile[current++]) < 0) {
                    actuallen += 256;
                }
                headerlength = 3;
            } else if (code.equals("82")) {
                int declen;
                if ((actuallen = codefile[current++]) < 0) {
                    actuallen += 256;
                }
                actuallen *= 256;
                if ((declen = codefile[current++]) < 0) {
                    declen += 256;
                }
                actuallen += declen;
                headerlength = 4;
            } else {
                actuallen = codefile[current - 1];
                if (actuallen < 0) {
                    actuallen += 256;
                }
                headerlength = 2;
            }
            byte[] manufSignedData = new byte[actuallen + headerlength];
            for (int i = 0; i < actuallen + headerlength; ++i) {
                manufSignedData[i] = codefile[i];
            }
            ContentInfo cinfo = null;
            try {
                cinfo = (ContentInfo)ContentInfo.getTemplate().decode(new ByteArrayInputStream(manufSignedData));
            }
            catch (Exception e) {
                throw new CodeFileParsingException("Error parsing signed image, got following error while decoding content info: " + e.getMessage());
            }
            if (cinfo == null) {
                throw new CodeFileParsingException("Error parsing signed image, couldn't create content info (got null value)");
            }
            SignedData sdata = null;
            try {
                sdata = (SignedData)cinfo.getInterpretedContent();
            }
            catch (InvalidBERException ibe) {
                throw new CodeFileParsingException("Error parsing signed image, got following error while decoding signed data: " + ibe.getMessage());
            }
            if (sdata == null) {
                throw new CodeFileParsingException("Error parsing signed image, couldn't create signed data (got null value)");
            }
            if (sdata.getCertificates() == null || sdata.getCertificates().size() == 0) {
                throw new CodeFileParsingException("Error parsing signed image, no certificates found!");
            }
            Certificate manufcert = (Certificate)sdata.getCertificates().elementAt(0);
            if (manufcert == null) {
                throw new CodeFileParsingException("Error parsing signed image, couldn't extract manufacturer cert (got null value)");
            }
            try {
                if (this.itsDocsisMode == DocsisMode.DOCSIS_31) {
                    if (sdata.getCertificates().size() < 2) {
                        throw new CodeFileParsingException("Error parsing signed image, no Mfg CA cert found in 3.1 signing mode!");
                    }
                    Certificate manufcacert = (Certificate)sdata.getCertificates().elementAt(1);
                    this.itsManufacturerCVCChain = CertUtils.appendAt(manufcert.getEncoded(), manufcacert.getEncoded());
                } else {
                    this.itsManufacturerCVC = manufcert.getEncoded();
                }
            }
            catch (IOException ioe) {
                throw new CodeFileParsingException("Error parsing signed image, re-encode manufacturer cert, got error: " + ioe.getMessage());
            }
            if (sdata.getSignerInfos() == null || sdata.getSignerInfos().size() == 0) {
                throw new CodeFileParsingException("Error parsing signed image, no SignerInfos found!");
            }
            SignerInfo siginfo = (SignerInfo)sdata.getSignerInfos().elementAt(0);
            try {
                this.itsManufSigInfo = new SigInfo(siginfo.getIssuerAndSerialNumber().getIssuer(), siginfo.getIssuerAndSerialNumber().getSerialNumber(), siginfo.getEncryptedDigest(), siginfo.getAuthenticatedAttributes().getBERencoded(new Tag(0L)), this.itsDocsisMode);
            }
            catch (Exception e) {
                throw new CodeFileParsingException("Error parsing manufacturer Signer Info, got error: " + e.getMessage());
            }
            if (this.itsManufSigInfo == null) {
                throw new CodeFileParsingException("Error parsing manufacturer Signer Info (got null value)");
            }
            int remaining = totallength - actuallen - headerlength;
            this.itsImage = new byte[remaining];
            for (int i = 0; i < remaining; ++i) {
                this.itsImage[i] = codefile[actuallen + headerlength + i];
            }
        } else if (codefile[0] == 28) {
            this.itsImage = codefile;
        } else {
            this.itsImage = new byte[codefile.length + 3];
            this.itsImage[0] = 28;
            this.itsImage[1] = 0;
            this.itsImage[2] = 0;
            System.arraycopy(codefile, 0, this.itsImage, 3, codefile.length);
        }
    }

    public byte[] getImage() {
        return this.itsImage;
    }

    public byte[] getDigest() throws NoSuchAlgorithmException {
        MessageDigest sha = MessageDigest.getInstance(this.itsDocsisMode == DocsisMode.DOCSIS_31 ? "SHA-256" : "sha-1");
        sha.update(this.itsImage);
        return sha.digest();
    }

    public void addCosCertorChain(byte[] cosCert) {
        if (this.itsDocsisMode == DocsisMode.DOCSIS_31) {
            this.itsCosignerCVCChain = cosCert;
        } else {
            this.itsCosignerCVC = cosCert;
        }
    }

    public int getDocsisMode() {
        return this.itsDocsisMode;
    }

    public void addManufCertorChain(byte[] manCert) {
        if (this.itsDocsisMode == DocsisMode.DOCSIS_31) {
            this.itsManufacturerCVCChain = manCert;
        } else {
            this.itsManufacturerCVC = manCert;
        }
    }

    public void addCoSigInfo(SigInfo cos) {
        this.itsCoSigInfo = cos;
    }

    public void addManufSigInfo(SigInfo man) {
        this.itsManufSigInfo = man;
    }

    public void calculateSignedData(boolean invalidSignature, boolean invalidCosSignature) throws IOException, CodeFileSigningException {
        if (this.itsManufSigInfo == null || this.itsManufacturerCVC == null && this.itsManufacturerCVCChain == null) {
            System.out.println("no manuf present, cosigner only mode!!!");
            if (this.itsCoSigInfo == null || this.itsCosignerCVC == null && this.itsCosignerCVCChain == null) {
                System.out.println("no signerinfo present, cannot created signeddata!");
                return;
            }
            byte[] complete = this.itsSerial;
            complete = CertUtils.appendAt(complete, CertUtils.encode(this.itsDocsisMode == DocsisMode.DOCSIS_31 ? this.itsDigestAlg_sha256 : this.itsDigestAlg_sha1, 49));
            complete = CertUtils.appendAt(complete, CertUtils.encode(this.itsDataType, 48));
            byte[] certificates = this.itsCosignerCVC;
            certificates = CertUtils.encode(certificates, 160);
            complete = CertUtils.appendAt(complete, certificates);
            byte[] signerinfos = null;
            try {
                signerinfos = this.itsCoSigInfo.getEncoded();
            }
            catch (Exception e) {
                throw new CodeFileSigningException("Error encoded manufacturer siginfo: " + e.getMessage());
            }
            if (invalidCosSignature) {
                if (signerinfos[signerinfos.length - 1] == 0) {
                    signerinfos[signerinfos.length - 1] = 1;
                } else {
                    int n = signerinfos.length - 1;
                    signerinfos[n] = (byte)(signerinfos[n] - 1);
                }
            }
            signerinfos = CertUtils.encode(signerinfos, 49);
            complete = CertUtils.appendAt(complete, signerinfos);
            complete = CertUtils.encode(complete, 48);
            complete = CertUtils.encode(complete, 160);
            this.itsSignedData = complete;
            return;
        }
        byte[] complete = this.itsSerial;
        complete = CertUtils.appendAt(complete, CertUtils.encode(this.itsDocsisMode == DocsisMode.DOCSIS_31 ? this.itsDigestAlg_sha256 : this.itsDigestAlg_sha1, 49));
        complete = CertUtils.appendAt(complete, CertUtils.encode(this.itsDataType, 48));
        byte[] certificates = CertUtils.appendAt(this.itsDocsisMode == DocsisMode.DOCSIS_31 ? this.itsManufacturerCVCChain : this.itsManufacturerCVC, this.itsDocsisMode == DocsisMode.DOCSIS_31 ? this.itsCosignerCVCChain : this.itsCosignerCVC);
        certificates = CertUtils.encode(certificates, 160);
        complete = CertUtils.appendAt(complete, certificates);
        byte[] signerinfos = null;
        if (this.itsCoSigInfo == null) {
            try {
                signerinfos = this.itsManufSigInfo.getEncoded();
            }
            catch (Exception e) {
                throw new CodeFileSigningException("Error encoded manufacturer siginfo: " + e.getMessage());
            }
            if (invalidSignature) {
                if (signerinfos[signerinfos.length - 1] == 0) {
                    signerinfos[signerinfos.length - 1] = 1;
                } else {
                    int n = signerinfos.length - 1;
                    signerinfos[n] = (byte)(signerinfos[n] - 1);
                }
            }
        } else {
            byte[] manuf = null;
            byte[] cosig = null;
            try {
                manuf = this.itsManufSigInfo.getEncoded();
                cosig = this.itsCoSigInfo.getEncoded();
            }
            catch (Exception e) {
                throw new CodeFileSigningException("Error creating signerinfos: " + e.getMessage());
            }
            if (invalidSignature) {
                if (manuf[manuf.length - 1] == 0) {
                    manuf[manuf.length - 1] = 1;
                } else {
                    int n = manuf.length - 1;
                    manuf[n] = (byte)(manuf[n] - 1);
                }
            }
            if (invalidCosSignature) {
                if (cosig[cosig.length - 1] == 0) {
                    cosig[cosig.length - 1] = 1;
                } else {
                    int n = cosig.length - 1;
                    cosig[n] = (byte)(cosig[n] - 1);
                }
            }
            signerinfos = CertUtils.appendAt(manuf, cosig);
        }
        signerinfos = CertUtils.encode(signerinfos, 49);
        complete = CertUtils.appendAt(complete, signerinfos);
        complete = CertUtils.encode(complete, 48);
        complete = CertUtils.encode(complete, 160);
        this.itsSignedData = complete;
    }

    public byte[] getNewCompleteImage() throws CodeFileSigningException, IOException {
        return this.getNewCompleteImage(false, false);
    }

    public byte[] getNewCompleteImage(boolean manufinvalid) throws Exception {
        return this.getNewCompleteImage(manufinvalid, false);
    }

    public byte[] getNewCompleteImage(boolean invalidSignature, boolean invalidCosSignature) throws CodeFileSigningException, IOException {
        if (this.itsSignedData == null) {
            this.calculateSignedData(invalidSignature, invalidCosSignature);
        }
        byte[] finalb = this.itsSDataType;
        finalb = CertUtils.appendAt(finalb, this.itsSignedData);
        return CertUtils.appendAt(CertUtils.encode(finalb, 48), this.itsImage);
    }

    public byte[] calculateDegenateStructure() throws IOException, CodeFileSigningException {
        byte[] finalb = this.itsSDataType;
        byte[] complete = this.itsSerial;
        complete = CertUtils.appendAt(complete, CertUtils.encode(null, 49));
        complete = CertUtils.appendAt(complete, CertUtils.encode(this.itsDataType, 48));
        byte[] certificates = this.itsManufacturerCVCChain;
        certificates = CertUtils.encode(certificates, 160);
        complete = CertUtils.appendAt(complete, certificates);
        byte[] signerinfos = null;
        signerinfos = CertUtils.encode(signerinfos, 49);
        byte[] something_explicit = CertUtils.encode(null, 161);
        complete = CertUtils.appendAt(complete, something_explicit);
        complete = CertUtils.appendAt(complete, signerinfos);
        complete = CertUtils.encode(complete, 48);
        complete = CertUtils.encode(complete, 160);
        this.itsSignedData = complete;
        finalb = CertUtils.appendAt(finalb, complete);
        return CertUtils.encode(finalb, 48);
    }

    public byte[] calculateContentInfo() throws CodeFileSigningException, IOException {
        if (this.itsSignedData == null) {
            this.calculateSignedData(false, false);
        }
        byte[] finalb = this.itsSDataType;
        finalb = CertUtils.appendAt(finalb, this.itsSignedData);
        return CertUtils.encode(finalb, 48);
    }

    public byte[] getSignedData() {
        return this.itsSignedData;
    }

    public SigInfo getItsCoSigInfo() {
        return this.itsCoSigInfo;
    }

    public SigInfo getItsManufSigInfo() {
        return this.itsManufSigInfo;
    }
}

