/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.codefile;

import com.excentis.security.codefile.CodeFile;
import com.excentis.security.codefile.CodeFileParsingException;
import com.excentis.security.codefile.CodeFileSigningException;
import com.excentis.security.utils.CertUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.pkcs7.ContentInfo;
import org.mozilla.jss.pkcs7.SignedData;
import org.mozilla.jss.pkix.cert.Certificate;

public class DegeneratePkcs7 {
    public static byte[] encodeCertChain(byte[] cvcchain) throws IOException, CodeFileSigningException {
        CodeFile cod = CodeFile.createDegenerateStructure();
        cod.addManufCertorChain(cvcchain);
        return cod.calculateDegenateStructure();
    }

    public static byte[] getCertChainFromDegeneratePkcs7(byte[] degenpkcs7) throws CodeFileParsingException, IOException {
        int current = 0;
        if (degenpkcs7[current++] != 48) {
            throw new CodeFileParsingException("Error parsing code file, doesn't start with ContentInfo! ");
        }
        String temp = Integer.toHexString(degenpkcs7[current++]);
        String code = "";
        code = temp.length() == 1 ? code.concat("0" + temp) : (temp.length() == 8 ? code.concat(temp.substring(6, 8)) : code.concat(temp));
        int actuallen = 0;
        int headerlength = 0;
        if (code.equals("81")) {
            if ((actuallen = degenpkcs7[current++]) < 0) {
                actuallen += 256;
            }
            headerlength = 3;
        } else if (code.equals("82")) {
            int declen;
            if ((actuallen = degenpkcs7[current++]) < 0) {
                actuallen += 256;
            }
            actuallen *= 256;
            if ((declen = degenpkcs7[current++]) < 0) {
                declen += 256;
            }
            actuallen += declen;
            headerlength = 4;
        } else {
            actuallen = degenpkcs7[current - 1];
            if (actuallen < 0) {
                actuallen += 256;
            }
            headerlength = 2;
        }
        byte[] manufSignedData = new byte[actuallen + headerlength];
        for (int i = 0; i < actuallen + headerlength; ++i) {
            manufSignedData[i] = degenpkcs7[i];
        }
        ContentInfo cinfo = null;
        try {
            cinfo = (ContentInfo)ContentInfo.getTemplate().decode(new ByteArrayInputStream(manufSignedData));
        }
        catch (Exception e) {
            throw new CodeFileParsingException("Error parsing signed image, got following error while decoding content info: " + e.getMessage());
        }
        if (cinfo == null) {
            throw new CodeFileParsingException("Error parsing signed image, couldn't create content info (got null value)");
        }
        SignedData sdata = null;
        try {
            sdata = (SignedData)cinfo.getInterpretedContent();
        }
        catch (InvalidBERException ibe) {
            throw new CodeFileParsingException("Error parsing signed image, got following error while decoding signed data: " + ibe.getMessage());
        }
        if (sdata == null) {
            throw new CodeFileParsingException("Error parsing signed image, couldn't create signed data (got null value)");
        }
        if (sdata.getCertificates() == null || sdata.getCertificates().size() == 0) {
            throw new CodeFileParsingException("Error parsing signed image, no certificates found!");
        }
        byte[] certs = null;
        for (int i = 0; i < sdata.getCertificates().size(); ++i) {
            certs = CertUtils.appendAt(certs, ((Certificate)sdata.getCertificates().elementAt(i)).getEncoded());
        }
        return certs;
    }
}

