/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.codefile;

import com.excentis.security.codefile.AuthAttrib;
import com.excentis.security.utils.CertUtils;
import com.excentis.security.utils.DocsisMode;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import org.mozilla.jss.pkix.primitive.Name;

public class SigInfo {
    public static final int SEQUENCE = 48;
    public static final int SET = 49;
    public static final int INTEGER = 2;
    public static final int OCTET_STRING = 4;
    private byte[] itsVersion = new byte[]{2, 1, 1};
    private Name itsIssuerName = null;
    private BigInteger itsSerial = null;
    private byte[] itsDigestAlg_sha1 = new byte[]{48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0};
    private byte[] itsDigestAlg_sha256 = new byte[]{48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0};
    private AuthAttrib itsAuthAttrib = null;
    private byte[] itsDigestEncrAlg_rsa = new byte[]{48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0};
    private byte[] itsEncrDigest = null;
    private PrivateKey itsPrivateKey = null;
    private byte[] itsFixedAuthAttribs = null;
    private byte[] itsDigest = null;
    private int itsDocsisMode = DocsisMode.NOT_DEFINED;

    public SigInfo(Name issuer, BigInteger serial, Date signingDate, byte[] digest, PrivateKey privKey, int docsismode) {
        this(issuer, serial, signingDate, digest, privKey, true, docsismode);
    }

    public SigInfo(Name issuer, BigInteger serial, Date signingDate, byte[] digest, PrivateKey privKey, boolean auth, int docsismode) {
        this.itsIssuerName = issuer;
        this.itsSerial = serial;
        if (signingDate != null) {
            this.itsAuthAttrib = new AuthAttrib(signingDate, digest);
        } else {
            if (auth) {
                System.out.println("ERROR!  no signingDate and auth present.");
            }
            this.itsDigest = digest;
        }
        this.itsPrivateKey = privKey;
        this.itsDocsisMode = docsismode;
    }

    private int getDocsisMode() {
        return this.itsDocsisMode;
    }

    public SigInfo(Name issuer, BigInteger serial, byte[] encryptedDigest, byte[] authattribs, int docsismode) {
        this.itsIssuerName = issuer;
        this.itsSerial = serial;
        this.itsEncrDigest = encryptedDigest;
        this.itsFixedAuthAttribs = authattribs;
        this.itsDocsisMode = docsismode;
    }

    private void calcEncrDigest() throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        byte[] input = null;
        input = this.itsAuthAttrib != null ? this.itsAuthAttrib.getInputForDigesting() : this.itsDigest;
        Signature s = Signature.getInstance(this.getDocsisMode() == DocsisMode.DOCSIS_31 ? "SHA256withRSA" : "SHA1withRSA");
        s.initSign(this.itsPrivateKey);
        s.update(input);
        this.itsEncrDigest = s.sign();
    }

    public byte[] getEncrDigest() throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (this.itsEncrDigest == null) {
            this.calcEncrDigest();
        }
        return this.itsEncrDigest;
    }

    public byte[] getEncoded() throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        byte[] result = this.itsVersion;
        byte[] isandser = this.itsIssuerName.getEncoded();
        isandser = CertUtils.appendAt(isandser, CertUtils.encode(this.itsSerial.toByteArray(), 2));
        result = CertUtils.appendAt(result, CertUtils.encode(isandser, 48));
        result = CertUtils.appendAt(result, this.getDocsisMode() == DocsisMode.DOCSIS_31 ? this.itsDigestAlg_sha256 : this.itsDigestAlg_sha1);
        if (this.itsFixedAuthAttribs == null) {
            if (this.itsAuthAttrib != null) {
                result = CertUtils.appendAt(result, this.itsAuthAttrib.getEncoded());
            }
        } else {
            result = CertUtils.appendAt(result, this.itsFixedAuthAttribs);
        }
        result = CertUtils.appendAt(result, this.itsDigestEncrAlg_rsa);
        result = CertUtils.appendAt(result, CertUtils.encode(this.getEncrDigest(), 4));
        return CertUtils.encode(result, 48);
    }

    public AuthAttrib getItsAuthAttrib() {
        return this.itsAuthAttrib;
    }

    public byte[] getItsFixedAuthAttribs() {
        return this.itsFixedAuthAttribs;
    }
}

