/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile;

import com.excentis.security.codefile.DegeneratePkcs7;
import com.excentis.security.configfile.ConfigFileGUI;
import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.ITLV;
import com.excentis.security.configfile.Messages;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.TLVNotPresentException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.parser.ConfigParser;
import com.excentis.security.configfile.tlvs.TLV_20Enable;
import com.excentis.security.configfile.tlvs.TLV_AdvancedBandPlanSupport;
import com.excentis.security.configfile.tlvs.TLV_AdvancedDiplexerBandEdge;
import com.excentis.security.configfile.tlvs.TLV_BaselinePrivacy;
import com.excentis.security.configfile.tlvs.TLV_CMSSHServerConfigurationSettings;
import com.excentis.security.configfile.tlvs.TLV_CM_Upstream_AQM_Disable;
import com.excentis.security.configfile.tlvs.TLV_COCVC;
import com.excentis.security.configfile.tlvs.TLV_COCVCChain;
import com.excentis.security.configfile.tlvs.TLV_CPEEthernetMac;
import com.excentis.security.configfile.tlvs.TLV_CVC;
import com.excentis.security.configfile.tlvs.TLV_CVCChain;
import com.excentis.security.configfile.tlvs.TLV_CmMic;
import com.excentis.security.configfile.tlvs.TLV_CmtsMic;
import com.excentis.security.configfile.tlvs.TLV_DOCSISSyncConfigurations;
import com.excentis.security.configfile.tlvs.TLV_DOCSIS_1_0_COS;
import com.excentis.security.configfile.tlvs.TLV_DTPMode;
import com.excentis.security.configfile.tlvs.TLV_DUTFiltering;
import com.excentis.security.configfile.tlvs.TLV_DefaultUpstreamTargetBufferConfiguration;
import com.excentis.security.configfile.tlvs.TLV_DiplexerBandEdge;
import com.excentis.security.configfile.tlvs.TLV_DistributedHQoSEnable;
import com.excentis.security.configfile.tlvs.TLV_DocsisV3NotificationReceiver;
import com.excentis.security.configfile.tlvs.TLV_DownstreamAggregateServiceFlow;
import com.excentis.security.configfile.tlvs.TLV_DownstreamChannelList;
import com.excentis.security.configfile.tlvs.TLV_DownstreamFrequencyConfiguration;
import com.excentis.security.configfile.tlvs.TLV_DownstreamPacketClassifier;
import com.excentis.security.configfile.tlvs.TLV_DownstreamServiceFlow;
import com.excentis.security.configfile.tlvs.TLV_Downstream_EHQoS_ASF;
import com.excentis.security.configfile.tlvs.TLV_ERouter;
import com.excentis.security.configfile.tlvs.TLV_ESTB;
import com.excentis.security.configfile.tlvs.TLV_EnergyManagement;
import com.excentis.security.configfile.tlvs.TLV_ExtensionField;
import com.excentis.security.configfile.tlvs.TLV_Generic;
import com.excentis.security.configfile.tlvs.TLV_LLDDisable;
import com.excentis.security.configfile.tlvs.TLV_MESP;
import com.excentis.security.configfile.tlvs.TLV_MacAddressLearningControlEncoding;
import com.excentis.security.configfile.tlvs.TLV_MacAging;
import com.excentis.security.configfile.tlvs.TLV_ManagementEventControl;
import com.excentis.security.configfile.tlvs.TLV_MaxCPE;
import com.excentis.security.configfile.tlvs.TLV_MaxClassifier;
import com.excentis.security.configfile.tlvs.TLV_Mib;
import com.excentis.security.configfile.tlvs.TLV_MulticastMacAddress;
import com.excentis.security.configfile.tlvs.TLV_NetworkAccessControl;
import com.excentis.security.configfile.tlvs.TLV_NetworkTimingProfile;
import com.excentis.security.configfile.tlvs.TLV_PHS;
import com.excentis.security.configfile.tlvs.TLV_PTPAddressConfigurations;
import com.excentis.security.configfile.tlvs.TLV_PacketClassifier;
import com.excentis.security.configfile.tlvs.TLV_PrivacyEnable;
import com.excentis.security.configfile.tlvs.TLV_SNMPWriteAccessControl;
import com.excentis.security.configfile.tlvs.TLV_SecurityConfigurationSettings;
import com.excentis.security.configfile.tlvs.TLV_ServiceFlow;
import com.excentis.security.configfile.tlvs.TLV_SnmpV3KickStart;
import com.excentis.security.configfile.tlvs.TLV_SoftwareUpgradeFilename;
import com.excentis.security.configfile.tlvs.TLV_SoftwareUpgradeServer;
import com.excentis.security.configfile.tlvs.TLV_SubCPEIPv6List;
import com.excentis.security.configfile.tlvs.TLV_SubControl;
import com.excentis.security.configfile.tlvs.TLV_SubGroups;
import com.excentis.security.configfile.tlvs.TLV_SubTable;
import com.excentis.security.configfile.tlvs.TLV_TFTPProvisionedModem;
import com.excentis.security.configfile.tlvs.TLV_TFTPTimestamp;
import com.excentis.security.configfile.tlvs.TLV_TelephoneSettings;
import com.excentis.security.configfile.tlvs.TLV_TestEnable;
import com.excentis.security.configfile.tlvs.TLV_UNI_Encodings;
import com.excentis.security.configfile.tlvs.TLV_UpstreamAggregateServiceFlow;
import com.excentis.security.configfile.tlvs.TLV_UpstreamChannelID;
import com.excentis.security.configfile.tlvs.TLV_UpstreamPacketClassifier;
import com.excentis.security.configfile.tlvs.TLV_UpstreamServiceFlow;
import com.excentis.security.configfile.tlvs.TLV_Upstream_EHQoS_ASF;
import com.excentis.security.configfile.tlvs.TLV_VendorSpecific;
import com.excentis.security.configfile.tlvs.docsis30.TLV_ChannelAssignmentConfigurationSettings;
import com.excentis.security.configfile.tlvs.docsis30.TLV_SnmpCpeAccessControl;
import com.excentis.security.configfile.tlvs.docsis30.TLV_Snmpv1v2cCoexistence;
import com.excentis.security.configfile.tlvs.docsis30.TLV_Snmpv3AccessView;
import com.excentis.security.configfile.tlvs.docsis30.TLV_SoftwareUpgradeIPv6TftpServer;
import com.excentis.security.configfile.tlvs.docsis30.TLV_StaticMulticastSessionEncoding;
import com.excentis.security.configfile.tlvs.docsis30.TLV_SubscriberMgmtControlMaxCpeIpv6Addresses;
import com.excentis.security.configfile.tlvs.docsis30.TLV_SubscriberMgmtCpeIpv6PrefixList;
import com.excentis.security.configfile.tlvs.docsis30.TLV_TftpProvisionedModemIpv6Address;
import com.excentis.security.configfile.tlvs.docsis30.TLV_UpstreamDropClassifier;
import com.excentis.security.configfile.tlvs.docsis30.TLV_UpstreamDropClassifierGroupId;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_ClassifierReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_IPPacketClassification;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_ServiceFlowReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.ExtensionField_ExtendedCmtsMic;
import com.excentis.security.configfile.tlvs.tlvsub1types.PHS_ClassifierReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.PHS_Field;
import com.excentis.security.configfile.tlvs.tlvsub1types.PHS_Mask;
import com.excentis.security.configfile.tlvs.tlvsub1types.PHS_ServiceFlowReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.PHS_Size;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_AggregateSFReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_MESPReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_Reference;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_SchedulingType;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.MESP_Reference;
import com.excentis.security.configfile.tlvs.tlvsub2types.EXTMIC_Bitmap;
import com.excentis.security.configfile.tlvs.tlvsub2types.EXTMIC_Digest;
import com.excentis.security.configfile.tlvs.tlvsub2types.EXTMIC_HmacType;
import com.excentis.security.tcl.F;
import com.excentis.security.tcl.MMH;
import com.excentis.security.tools.Binary2Plaintext;
import com.excentis.security.tools.Plaintext2Binary;
import com.excentis.security.utils.CertUtils;
import com.excentis.security.utils.DafKey;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.crypto.Mac;
import org.mozilla.jss.asn1.BIT_STRING;

public class ConfigFile {
    private ArrayList<ITLV> itsTLVs = new ArrayList();
    private TLV itsCM_Mic = null;
    private TLV itsCMTS_Mic = null;
    private String itsName = "configfile";
    private static boolean cheatMode = false;
    private int[] usedRefs = null;
    private int[] used_COS_IDs = null;
    private int[] usedClassifierRefs = null;
    public int V3COUNT = 0;
    private Hashtable<Integer, boolean[]> usedRefsTable = new Hashtable();
    public static final int[] CMTS_MIC_LIST = new int[]{1, 2, 3, 4, 17, 43, 6, 18, 19, 20, 22, 23, 24, 25, 28, 29, 26, 35, 36, 37, 40};
    private boolean hexMode = false;
    public static final String[] phsErrorCodes = new String[]{"no error", "Classifier Reference not present", "Service Flow Reference not present", "PHS Field not present", "PHS Size not present", "Wrong PHS Size", "Unused Classifier Reference", "Unused Service Flow Reference", "Wrong PHS Mask length", "Reference to Invalid Classifier", "Invalid Service Flow - Classifier reference combination"};
    public static final String[] classErrorCodes = new String[]{"no error", "Classifier Reference not present", "Service Flow Reference not present", "No valid classifier found (IPv4, IPv6, Ethernet, IEEE 802 P/Q, STAG/CTAG, AH, ICMP, MPLS or VendorSpecific)", "Invalid Service Flow reference", "Upstream Classifier referenced to Downstream Service flow", "Downstream Classifier referenced to Upstream Service flow", "Invalid combination of IPv4 and IPv6 Encodings, only TCP/UDP can be shared"};
    public static final String[] serviceErrorCodes = new String[]{"no error", "Service Flow Reference not present", "QoS parameter set not present", "Request/Transmission Policy not defined for non-Best-Effort Service Flow"};
    public static final String[] cosErrorCodes = new String[]{"no error", "Class ID not present", "Class-of-Service Privacy Enable not present"};

    public ConfigFile() {
    }

    public ConfigFile(byte[] encodedConfigFile) throws Exception {
        this.readBinary(encodedConfigFile);
    }

    public void clearStatics() {
        this.clearUsedRefs();
        this.clearUsedCosIds();
        this.clearUsedClassifierRefs();
        this.V3COUNT = 0;
    }

    private void addTLV(int type, byte[] value) throws Exception {
        if (type == 3) {
            this.itsTLVs.add(new TLV_NetworkAccessControl(this.getBooleanFromBytes(value)));
        } else if (type == 1) {
            this.itsTLVs.add(new TLV_DownstreamFrequencyConfiguration(this.getIntFromBytes(value)));
        } else if (type == 2) {
            this.itsTLVs.add(new TLV_UpstreamChannelID(this.getIntFromBytes(value)));
        } else if (type == 4) {
            this.itsTLVs.add(new TLV_DOCSIS_1_0_COS(value, this));
        } else if (type == 18) {
            this.itsTLVs.add(new TLV_MaxCPE(this.getIntFromBytes(value)));
        } else if (type == 19) {
            this.itsTLVs.add(new TLV_TFTPTimestamp(value));
        } else if (type == 20) {
            int[] ip = this.getIPFromBytes(value);
            this.itsTLVs.add(new TLV_TFTPProvisionedModem(InetAddress.getByName("" + ip[0] + "." + ip[1] + "." + ip[2] + "." + ip[3])));
        } else if (type == 22) {
            this.itsTLVs.add(new TLV_UpstreamPacketClassifier(value, this));
        } else if (type == 60) {
            this.itsTLVs.add(new TLV_UpstreamDropClassifier(value, this));
        } else if (type == 23) {
            this.itsTLVs.add(new TLV_DownstreamPacketClassifier(value, this));
        } else if (type == 25) {
            this.itsTLVs.add(new TLV_DownstreamServiceFlow(value, this));
        } else if (type == 71) {
            this.itsTLVs.add(new TLV_DownstreamAggregateServiceFlow(value, this));
        } else if (type == 24) {
            this.itsTLVs.add(new TLV_UpstreamServiceFlow(value, this));
        } else if (type == 70) {
            this.itsTLVs.add(new TLV_UpstreamAggregateServiceFlow(value, this));
        } else if (type == 26) {
            this.itsTLVs.add(new TLV_PHS(value, this));
        } else if (type == 28) {
            this.itsTLVs.add(new TLV_MaxClassifier(this.getIntFromBytes(value)));
        } else if (type == 29) {
            this.itsTLVs.add(new TLV_PrivacyEnable(this.getBooleanFromBytes(value)));
        } else if (type == 43) {
            byte[] vendor = new byte[3];
            System.arraycopy(value, 2, vendor, 0, 3);
            if (vendor[0] == -1 && vendor[1] == -1 && vendor[2] == -1) {
                this.itsTLVs.add(new TLV_ExtensionField(value));
            } else {
                this.itsTLVs.add(new TLV_VendorSpecific(value));
            }
        } else if (type == 35) {
            this.itsTLVs.add(new TLV_SubControl(value));
        } else if (type == 36) {
            this.itsTLVs.add(new TLV_SubTable(value));
        } else if (type == 37) {
            this.itsTLVs.add(new TLV_SubGroups(value));
        } else if (type == 9) {
            this.itsTLVs.add(new TLV_SoftwareUpgradeFilename(new String(value)));
        } else if (type == 10) {
            this.itsTLVs.add(new TLV_SNMPWriteAccessControl(value));
        } else if (type == 11) {
            this.itsTLVs.add(new TLV_Mib(value));
        } else if (type == 14) {
            this.itsTLVs.add(new TLV_CPEEthernetMac(new Binary2Plaintext(value).getHexRepresentation()));
        } else if (type == 21) {
            int[] ip = this.getIPFromBytes(value);
            this.itsTLVs.add(new TLV_SoftwareUpgradeServer(InetAddress.getByName("" + ip[0] + "." + ip[1] + "." + ip[2] + "." + ip[3])));
        } else if (type == 34) {
            this.itsTLVs.add(new TLV_SnmpV3KickStart(value));
        } else if (type == 32) {
            this.itsTLVs.add(new TLV_CVC(this, value));
        } else if (type == 33) {
            this.itsTLVs.add(new TLV_COCVC(this, value));
        } else if (type == 15) {
            this.itsTLVs.add(new TLV_TelephoneSettings(value));
        } else if (type == 17) {
            this.itsTLVs.add(new TLV_BaselinePrivacy(value));
        } else if (type == 38) {
            this.itsTLVs.add(new TLV_DocsisV3NotificationReceiver(value, this));
        } else if (type == 39) {
            this.itsTLVs.add(new TLV_20Enable(this.getBooleanFromBytes(value)));
        } else if (type == 40) {
            this.itsTLVs.add(new TLV_TestEnable(this.getBooleanFromBytes(value)));
        } else if (type == 41) {
            this.itsTLVs.add(new TLV_DownstreamChannelList(41, value, this));
        } else if (type == 42) {
            this.itsTLVs.add(new TLV_MulticastMacAddress(new Binary2Plaintext(value).getHexRepresentation()));
        } else if (type == 55) {
            this.itsTLVs.add(new TLV_SnmpCpeAccessControl(this.getBooleanFromBytes(value)));
        } else if (type == 56) {
            this.itsTLVs.add(new TLV_ChannelAssignmentConfigurationSettings(value));
        } else if (type == 53) {
            this.itsTLVs.add(new TLV_Snmpv1v2cCoexistence(value));
        } else if (type == 54) {
            this.itsTLVs.add(new TLV_Snmpv3AccessView(value));
        } else if (type == 58) {
            this.itsTLVs.add(new TLV_SoftwareUpgradeIPv6TftpServer(this.getIPv6FromBytes(value)));
        } else if (type == 59) {
            this.itsTLVs.add(new TLV_TftpProvisionedModemIpv6Address(this.getIPv6FromBytes(value)));
        } else if (type == 61) {
            this.itsTLVs.add(new TLV_SubscriberMgmtCpeIpv6PrefixList(value));
        } else if (type == 62) {
            this.itsTLVs.add(new TLV_UpstreamDropClassifierGroupId(value));
        } else if (type == 63) {
            this.itsTLVs.add(new TLV_SubscriberMgmtControlMaxCpeIpv6Addresses(value));
        } else if (type == 64) {
            this.itsTLVs.add(new TLV_StaticMulticastSessionEncoding(value));
        } else if (type == 45) {
            this.itsTLVs.add(new TLV_DUTFiltering(value));
        } else if (type == 202) {
            this.itsTLVs.add(new TLV_ERouter(value));
        } else if (type == 217) {
            this.itsTLVs.add(new TLV_ESTB(value));
        } else if (type == 65) {
            this.itsTLVs.add(new TLV_MacAging(value));
        } else if (type == 66) {
            this.itsTLVs.add(new TLV_ManagementEventControl(value));
        } else if (type == 67) {
            this.itsTLVs.add(new TLV_SubCPEIPv6List(value));
        } else if (type == 68) {
            this.itsTLVs.add(new TLV_DefaultUpstreamTargetBufferConfiguration(value));
        } else if (type == 69) {
            this.itsTLVs.add(new TLV_MacAddressLearningControlEncoding(value));
        } else if (type == 72) {
            this.itsTLVs.add(new TLV_MESP(value, this));
        } else if (type == 73) {
            this.itsTLVs.add(new TLV_NetworkTimingProfile(value));
        } else if (type == 74) {
            this.itsTLVs.add(new TLV_EnergyManagement(value));
        } else if (type == 76) {
            this.itsTLVs.add(new TLV_CM_Upstream_AQM_Disable(this.getBooleanFromBytes(value)));
        } else if (type == 79) {
            this.itsTLVs.add(new TLV_UNI_Encodings(value));
        } else if (type == 81) {
            this.itsTLVs.add(new TLV_CVCChain(this, value));
        } else if (type == 82) {
            this.itsTLVs.add(new TLV_COCVCChain(this, value));
        } else if (type == 83) {
            this.itsTLVs.add(new TLV_DTPMode(this.getBooleanFromBytes(value)));
        } else if (type == 84) {
            this.itsTLVs.add(new TLV_DiplexerBandEdge(value));
        } else if (type == 91) {
            this.itsTLVs.add(new TLV_LLDDisable(this.getBooleanFromBytes(value)));
        } else if (type == 92) {
            this.itsTLVs.add(new TLV_DistributedHQoSEnable(this.getBooleanFromBytes(value)));
        } else if (type == 93) {
            this.itsTLVs.add(new TLV_Upstream_EHQoS_ASF(value, this));
        } else if (type == 94) {
            this.itsTLVs.add(new TLV_Downstream_EHQoS_ASF(value, this));
        } else if (type == 97) {
            this.itsTLVs.add(new TLV_AdvancedBandPlanSupport(this.getBooleanFromBytes(value)));
        } else if (type == 96) {
            this.itsTLVs.add(new TLV_AdvancedDiplexerBandEdge(value));
        } else if (type == 101) {
            this.itsTLVs.add(new TLV_DOCSISSyncConfigurations(value));
        } else if (type == 102) {
            this.itsTLVs.add(new TLV_PTPAddressConfigurations(value));
        } else if (type == 103) {
            this.itsTLVs.add(new TLV_CMSSHServerConfigurationSettings(value));
        } else if (type == 104) {
            this.itsTLVs.add(new TLV_SecurityConfigurationSettings(value));
        } else if (TLV.isESafeType(type)) {
            this.itsTLVs.add(new TLV_Generic(type, value));
        } else if (cheatMode) {
            this.itsTLVs.add(new TLV_Generic(type, value));
        } else {
            throw new UnsupportedTypeException("Base TLV ", type);
        }
    }

    public void readBinary(byte[] encodedConfigFile) throws Exception {
        this.clearStatics();
        int num = 0;
        try {
            num = this.numTLVs(encodedConfigFile);
        }
        catch (Exception e) {
            throw new Exception(Messages.getString("ConfigFile.numTlv"));
        }
        this.itsTLVs.clear();
        int pointer = 0;
        for (int i = 0; i < num; ++i) {
            int type = encodedConfigFile[pointer++] & 0xFF;
            try {
                boolean twobytelength = TLV.isTwoByteLength("" + type);
                int length = twobytelength ? TLV.getLengthFromBytes(new byte[]{encodedConfigFile[pointer++], encodedConfigFile[pointer++]}) : encodedConfigFile[pointer++] & 0xFF;
                byte[] value = new byte[length];
                if (encodedConfigFile.length < pointer + length) {
                    throw new InvalidLengthException("Base TLV " + type + "");
                }
                for (int j = 0; j < length; ++j) {
                    value[j] = encodedConfigFile[pointer + j];
                }
                pointer += length;
                if (type != 6 && type != 7) {
                    this.addTLV(type, value);
                    continue;
                }
                --i;
                continue;
            }
            catch (Exception e) {
                throw new Exception("Failed to parse configfile, error at base TLV number " + (i + 1) + " (type " + type + "), exception caught was " + e.getClass() + ": " + e.getMessage());
            }
        }
    }

    public void readBinaryFile(String filename) throws Exception {
        byte[] encodedConfigFile = CertUtils.readFile(new File(filename));
        this.readBinary(encodedConfigFile);
    }

    public void setHex(String hexrepr) throws Exception {
        byte[] encoded = new Plaintext2Binary(hexrepr + "ff").getBytes();
        this.readBinary(encoded);
    }

    public void deleteCVCs(int type) {
        ArrayList<ITLV> cvcs = this.getTLV(type);
        Iterator<ITLV> it = cvcs.iterator();
        while (it.hasNext()) {
            this.itsTLVs.remove((TLV)it.next());
        }
    }

    public byte[] getFullCVC(int type) {
        byte[] cvc = null;
        ArrayList<ITLV> cvcs = this.getTLV(type);
        Iterator<ITLV> it = cvcs.iterator();
        while (it.hasNext()) {
            cvc = CertUtils.appendAt(cvc, ((TLV)it.next()).getValue());
        }
        return cvc;
    }

    public ArrayList cutCVCIntoTLVPieces(byte[] encodedCVC, int type) throws Exception {
        byte[] currentcvc = this.getFullCVC(type);
        if (currentcvc != null && (type == 81 || type == 82)) {
            currentcvc = DegeneratePkcs7.getCertChainFromDegeneratePkcs7(currentcvc);
        }
        byte[] encodedCVCNoChain = null;
        try {
            encodedCVCNoChain = DegeneratePkcs7.getCertChainFromDegeneratePkcs7(encodedCVC);
        }
        catch (Exception e) {
            encodedCVCNoChain = encodedCVC;
        }
        byte[] allcvcs = CertUtils.appendAt(currentcvc, encodedCVCNoChain);
        if (type == 81 || type == 82) {
            allcvcs = DegeneratePkcs7.encodeCertChain(allcvcs);
        }
        int numPieces = allcvcs.length / 254;
        if (allcvcs.length % 254 != 0) {
            ++numPieces;
        }
        int remainingLength = allcvcs.length;
        int pointer = 0;
        this.deleteCVCs(type);
        ArrayList<TLV> result = new ArrayList<TLV>();
        for (int i = 0; i < numPieces; ++i) {
            int j;
            byte[] data;
            if (remainingLength >= 254) {
                data = new byte[254];
                for (j = 0; j < 254; ++j) {
                    data[j] = allcvcs[pointer++];
                }
                if (type == 32) {
                    result.add(new TLV_CVC(this, data));
                } else if (type == 81) {
                    result.add(new TLV_CVCChain(this, data));
                } else if (type == 33) {
                    result.add(new TLV_COCVC(this, data));
                } else {
                    result.add(new TLV_COCVCChain(this, data));
                }
                remainingLength -= 254;
                continue;
            }
            data = new byte[remainingLength];
            for (j = 0; j < remainingLength; ++j) {
                data[j] = allcvcs[pointer++];
            }
            if (type == 32) {
                result.add(new TLV_CVC(this, data));
            } else if (type == 81) {
                result.add(new TLV_CVCChain(this, data));
            } else if (type == 33) {
                result.add(new TLV_COCVC(this, data));
            } else {
                result.add(new TLV_COCVCChain(this, data));
            }
            remainingLength = 0;
        }
        return result;
    }

    private int getIntFromBytes(byte[] value) {
        byte[] val = new byte[value.length + 1];
        val[0] = 0;
        for (int i = 0; i < value.length; ++i) {
            val[i + 1] = value[i];
        }
        BigInteger big = new BigInteger(val);
        return big.intValue();
    }

    private int[] getIPFromBytes(byte[] value) {
        int[] result = new int[]{this.getIntFromBytes(new byte[]{value[0]}), this.getIntFromBytes(new byte[]{value[1]}), this.getIntFromBytes(new byte[]{value[2]}), this.getIntFromBytes(new byte[]{value[3]})};
        return result;
    }

    private Inet6Address getIPv6FromBytes(byte[] value) throws UnknownHostException {
        return (Inet6Address)InetAddress.getByAddress(value);
    }

    private boolean getBooleanFromBytes(byte[] value) {
        return value[0] == 1;
    }

    private int numTLVs(byte[] encoded) {
        int num = 0;
        int pointer = 0;
        while (pointer < encoded.length && encoded[pointer++] != -1) {
            boolean twobytelength = TLV.isTwoByteLength("" + (encoded[pointer - 1] & 0xFF));
            int size = twobytelength ? TLV.getLengthFromBytes(new byte[]{encoded[pointer++], encoded[pointer++]}) : encoded[pointer++] & 0xFF;
            if (encoded[pointer - 2] != 6 && encoded[pointer - 2] != 7) {
                ++num;
            }
            if (!ConfigFile.getCheatMode() || (pointer += size) + 1 < encoded.length) continue;
            return num;
        }
        return num;
    }

    public void setName(String s) {
        this.itsName = s;
    }

    public String toString() {
        return this.itsName;
    }

    public TLV getCM_Mic() {
        return this.itsCM_Mic;
    }

    public TLV getCMTS_Mic() {
        return this.itsCMTS_Mic;
    }

    public void appendTLV(ArrayList tlvs) {
        Iterator it = tlvs.iterator();
        while (it.hasNext()) {
            this.itsTLVs.add((TLV)it.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTXT(String filename, String path) throws Exception {
        File f = new File(filename);
        FileOutputStream fos = new FileOutputStream(f);
        try {
            fos.write(this.writeToString(path).getBytes());
        }
        finally {
            fos.close();
        }
    }

    public void saveTLV(String filename, String sharedSecret) throws Exception {
        this.saveTLV(filename, sharedSecret, "ExtendedEuro");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTLV(String filename, String sharedSecret, String extendedSharedSecret) throws Exception {
        File f = new File(filename);
        FileOutputStream fos = new FileOutputStream(f);
        try {
            fos.write(this.getEncoded(sharedSecret, extendedSharedSecret));
        }
        finally {
            fos.close();
        }
    }

    public String getHexEncoding(String sep) throws Exception {
        byte[] encode = new byte[this.getTotalTlvLength()];
        int pointer = 0;
        Iterator<ITLV> it = this.itsTLVs.iterator();
        while (it.hasNext()) {
            byte[] tlv = ((TLV)it.next()).getEncoded();
            for (int j = 0; j < tlv.length; ++j) {
                encode[pointer++] = tlv[j];
            }
        }
        Binary2Plaintext b2p = null;
        b2p = sep.equals("") ? new Binary2Plaintext(encode) : new Binary2Plaintext(encode, sep.charAt(0));
        return b2p.getHexRepresentation();
    }

    public String getFullHexEncoding(String sep, String sharedsecret, String extendedSharedSecret) throws Exception {
        byte[] encode = this.getEncoded(sharedsecret, extendedSharedSecret);
        Binary2Plaintext b2p = null;
        b2p = sep.equals("") ? new Binary2Plaintext(encode) : new Binary2Plaintext(encode, sep.charAt(0));
        return b2p.getHexRepresentation();
    }

    public void showMe() throws Exception {
        ConfigFileGUI gui = new ConfigFileGUI();
        gui.setConfigFile(this);
        gui.validate();
        gui.setVisible(true);
        gui.disableSave();
        gui.disableOpen();
        gui.disableOpenTXT();
        gui.disableNew();
    }

    public static void testExtendedMicMMH() {
        try {
            String extss = "Shared secret #1 94476839";
            System.out.println("TEST VECTOR #1\n\n");
            System.out.println("shared secret in ASCII:\n" + new Binary2Plaintext(extss.getBytes()).getHexRepresentation());
            byte[] digest = new byte[]{};
            String s1 = new String();
            String s2 = new String();
            for (int i = 0; i < extss.length(); ++i) {
                if (i % 2 == 0) {
                    s1 = s1.concat(new String(new char[]{extss.charAt(i)}));
                    continue;
                }
                s2 = s2.concat(new String(new char[]{extss.charAt(i)}));
            }
            System.out.println("S1 in hex: " + new Binary2Plaintext(s1.getBytes()).getHexRepresentation());
            System.out.println("S2 in hex: " + new Binary2Plaintext(s2.getBytes()).getHexRepresentation());
            String message = "DOCSIS 3.0, fulfilling the need for speed";
            byte[] input = message.getBytes();
            if (input.length % 2 != 0) {
                input = CertUtils.appendAt(input, new byte[1]);
            }
            System.out.println("Message in hex: \n" + new Binary2Plaintext(input).getHexRepresentation());
            int keybytelength = input.length + 6;
            String keybytes = F.generateKeyingMaterialwithAES(new Binary2Plaintext(s1.getBytes()).getHexRepresentation(), new Binary2Plaintext("CMTS-EMIC".getBytes()).getHexRepresentation(), keybytelength);
            System.out.println("key in hex: \n" + keybytes);
            String value_A = MMH.MMH_sigma_n(new Binary2Plaintext(input).getHexRepresentation(), keybytes, 4);
            System.out.println("value A (MMH) in hex:\n" + value_A);
            String A_S2 = value_A.concat(new Binary2Plaintext(s2.getBytes()).getHexRepresentation());
            String padding = F.generateKeyingMaterialwithAES(A_S2, new Binary2Plaintext("CMTS-EMIC-PAD".getBytes()).getHexRepresentation(), 8);
            if (padding.length() > 16) {
                padding = padding.substring(0, 16);
            }
            System.out.println("padding in hex:\n" + padding);
            digest = MMH.add(new Plaintext2Binary(value_A).getBytes(), new Plaintext2Binary(padding).getBytes(), 64);
            System.out.println("digest output in hex:\n" + new Binary2Plaintext(digest).getHexRepresentation());
            System.out.println("TEST VECTOR #2\n\n");
            extss = "Shared secret #2 07782313";
            System.out.println("shared secret in ASCII:\n" + new Binary2Plaintext(extss.getBytes()).getHexRepresentation());
            digest = new byte[]{};
            s1 = new String();
            s2 = new String();
            for (int i = 0; i < extss.length(); ++i) {
                if (i % 2 == 0) {
                    s1 = s1.concat(new String(new char[]{extss.charAt(i)}));
                    continue;
                }
                s2 = s2.concat(new String(new char[]{extss.charAt(i)}));
            }
            System.out.println("S1 in hex: " + new Binary2Plaintext(s1.getBytes()).getHexRepresentation());
            System.out.println("S2 in hex: " + new Binary2Plaintext(s2.getBytes()).getHexRepresentation());
            message = "The Magic Words are Squeamish Ossifrages";
            input = message.getBytes();
            if (input.length % 2 != 0) {
                input = CertUtils.appendAt(input, new byte[1]);
            }
            System.out.println("Message in hex: \n" + new Binary2Plaintext(input).getHexRepresentation());
            keybytelength = input.length + 6;
            keybytes = F.generateKeyingMaterialwithAES(new Binary2Plaintext(s1.getBytes()).getHexRepresentation(), new Binary2Plaintext("CMTS-EMIC".getBytes()).getHexRepresentation(), keybytelength);
            System.out.println("key in hex: \n" + keybytes);
            value_A = MMH.MMH_sigma_n(new Binary2Plaintext(input).getHexRepresentation(), keybytes, 4);
            System.out.println("value A (MMH) in hex:\n" + value_A);
            A_S2 = value_A.concat(new Binary2Plaintext(s2.getBytes()).getHexRepresentation());
            padding = F.generateKeyingMaterialwithAES(A_S2, new Binary2Plaintext("CMTS-EMIC-PAD".getBytes()).getHexRepresentation(), 8);
            if (padding.length() > 16) {
                padding = padding.substring(0, 16);
            }
            System.out.println("padding in hex:\n" + padding);
            digest = MMH.add(new Plaintext2Binary(value_A).getBytes(), new Plaintext2Binary(padding).getBytes(), 64);
            System.out.println("digest output in hex:\n" + new Binary2Plaintext(digest).getHexRepresentation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void testExtendedMicMMH_basic() {
        try {
            String extss = "ExtendedEuro";
            byte[] digest = new byte[]{};
            String s1 = new String();
            String s2 = new String();
            for (int i = 0; i < extss.length(); ++i) {
                if (i % 2 == 0) {
                    s1 = s1.concat(new String(new char[]{extss.charAt(i)}));
                    continue;
                }
                s2 = s2.concat(new String(new char[]{extss.charAt(i)}));
            }
            System.out.println("S1 in hex: " + new Binary2Plaintext(s1.getBytes()).getHexRepresentation());
            System.out.println("S2 in hex: " + new Binary2Plaintext(s2.getBytes()).getHexRepresentation());
            byte[] input = new Plaintext2Binary("030101").getBytes();
            if (input.length % 2 != 0) {
                input = CertUtils.appendAt(input, new byte[1]);
            }
            System.out.println("Message in hex: \n" + new Binary2Plaintext(input).getHexRepresentation());
            int keybytelength = input.length + 6;
            String keybytes = F.generateKeyingMaterialwithAES(new Binary2Plaintext(s1.getBytes()).getHexRepresentation(), new Binary2Plaintext("CMTS-EMIC".getBytes()).getHexRepresentation(), keybytelength);
            System.out.println("key in hex: \n" + keybytes);
            String value_A = MMH.MMH_sigma_n(new Binary2Plaintext(input).getHexRepresentation(), keybytes, 4);
            System.out.println("value A (MMH) in hex:\n" + value_A);
            String A_S2 = value_A.concat(new Binary2Plaintext(s2.getBytes()).getHexRepresentation());
            String padding = F.generateKeyingMaterialwithAES(A_S2, new Binary2Plaintext("CMTS-EMIC-PAD".getBytes()).getHexRepresentation(), 8);
            if (padding.length() > 16) {
                padding = padding.substring(0, 16);
            }
            System.out.println("padding in hex:\n" + padding);
            digest = MMH.add(new Plaintext2Binary(value_A).getBytes(), new Plaintext2Binary(padding).getBytes(), 64);
            System.out.println("digest output in hex:\n" + new Binary2Plaintext(digest).getHexRepresentation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String writeToString(String path) {
        try {
            TLV_Mib.initializeKnownOIDs(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.writeToString();
    }

    private String writeToString() {
        return this.writeToString(false, false);
    }

    public String writeToString(boolean inhex, boolean verbose) {
        return TLV.writeToString(this.getAllTLVs(), inhex, verbose);
    }

    public void appendTLV(TLV tlv) {
        this.itsTLVs.add(tlv);
    }

    public void appendTLV(TLV tlv, int location) {
        if (location < 0) {
            this.itsTLVs.add(tlv);
        } else {
            this.itsTLVs.add(location, tlv);
        }
    }

    public void removeTLVNumber(int tlvnumber) throws TLVNotPresentException {
        Iterator<ITLV> it = this.itsTLVs.iterator();
        ArrayList<ITLV> toremovetlvs = new ArrayList<ITLV>();
        while (it.hasNext()) {
            ITLV tlv = it.next();
            if (tlv.getType() != tlvnumber) continue;
            toremovetlvs.add(tlv);
        }
        Iterator rit = toremovetlvs.iterator();
        while (rit.hasNext()) {
            this.removeTLV((TLV)rit.next());
        }
    }

    public void removeTLV(TLV tlv) throws TLVNotPresentException {
        if (!this.itsTLVs.contains(tlv)) {
            throw new TLVNotPresentException(tlv.getTypeInfo());
        }
        this.itsTLVs.remove(tlv);
    }

    public byte[] calculateCM_Mic() throws Exception {
        byte[] dig = new byte[]{};
        byte[] conf = this.convertTLVsToBytes();
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(conf);
        dig = md5.digest();
        this.itsCM_Mic = new TLV_CmMic(6, dig);
        return dig;
    }

    public ArrayList<ITLV> getAllTLVs() {
        return this.itsTLVs;
    }

    public byte[] calculateCMTS_Mic() throws Exception {
        return this.calculateCMTS_Mic("Euro");
    }

    public byte[] calculateCMTS_Mic(String sharedSecret) throws Exception {
        byte[] dig = new byte[]{};
        byte[] conf = this.getBytesForCMTS_Mic();
        Mac mac = null;
        try {
            mac = Mac.getInstance("HMAC-MD5");
        }
        catch (Exception e) {
            mac = Mac.getInstance("HmacMD5");
        }
        mac.init(new DafKey(sharedSecret.getBytes()));
        mac.update(conf);
        dig = mac.doFinal();
        this.itsCMTS_Mic = new TLV_CmtsMic(7, dig);
        return dig;
    }

    public byte[] calculateExtendedCMTS_Mic(String extendedSharedSecret, byte[] input, int alg) throws Exception {
        Mac mac = null;
        byte[] digest = new byte[]{};
        if (alg == 2) {
            String s1 = new String();
            String s2 = new String();
            for (int i = 0; i < extendedSharedSecret.length(); ++i) {
                if (i % 2 == 0) {
                    s1 = s1.concat(new String(new char[]{extendedSharedSecret.charAt(i)}));
                    continue;
                }
                s2 = s2.concat(new String(new char[]{extendedSharedSecret.charAt(i)}));
            }
            if (input.length % 2 != 0) {
                input = CertUtils.appendAt(input, new byte[1]);
            }
            int keybytelength = input.length + 6;
            String keybytes = F.generateKeyingMaterialwithAES(new Binary2Plaintext(s1.getBytes()).getHexRepresentation(), new Binary2Plaintext("CMTS-EMIC".getBytes()).getHexRepresentation(), keybytelength);
            String value_A = MMH.MMH_sigma_n(new Binary2Plaintext(input).getHexRepresentation(), keybytes, 4);
            String A_S2 = value_A.concat(new Binary2Plaintext(s2.getBytes()).getHexRepresentation());
            String padding = F.generateKeyingMaterialwithAES(A_S2, new Binary2Plaintext("CMTS-EMIC-PAD".getBytes()).getHexRepresentation(), 8);
            if (padding.length() > 16) {
                padding = padding.substring(0, 16);
            }
            digest = MMH.add(new Plaintext2Binary(value_A).getBytes(), new Plaintext2Binary(padding).getBytes(), 64);
        } else {
            try {
                mac = Mac.getInstance("HMAC-MD5");
            }
            catch (Exception e) {
                mac = Mac.getInstance("HmacMD5");
            }
            mac.init(new DafKey(extendedSharedSecret.getBytes()));
            mac.update(input);
            digest = mac.doFinal();
        }
        return digest;
    }

    public ArrayList<ITLV> getTLV(int type) {
        ArrayList<ITLV> result = new ArrayList<ITLV>();
        for (TLV tLV : this.itsTLVs) {
            if (tLV.getType() != type) continue;
            result.add(tLV);
        }
        return result;
    }

    public ArrayList<ITLV> getTLVs(int[] types) {
        ArrayList<ITLV> result = new ArrayList<ITLV>();
        for (int i = 0; i < types.length; ++i) {
            result.addAll(this.getTLV(types[i]));
        }
        return result;
    }

    public ArrayList<ITLV> getUnknownTLVs() {
        ArrayList<ITLV> result = new ArrayList<ITLV>();
        for (TLV tLV : this.itsTLVs) {
            if (tLV.isBaseType(tLV.getType())) continue;
            result.add(tLV);
        }
        return result;
    }

    public boolean typePresent(int type) {
        Iterator<ITLV> it = this.itsTLVs.iterator();
        while (it.hasNext()) {
            if (((TLV)it.next()).getType() != type) continue;
            return true;
        }
        return false;
    }

    private byte[] convertTLVsToBytes() throws Exception {
        byte[] temp = new byte[]{};
        byte[] result = new byte[]{};
        for (TLV tLV : this.itsTLVs) {
            int j;
            temp = tLV.getEncoded();
            if (temp == null) continue;
            byte[] temp2 = new byte[result.length + temp.length];
            for (j = 0; j < result.length; ++j) {
                temp2[j] = result[j];
            }
            for (j = 0; j < temp.length; ++j) {
                temp2[result.length + j] = temp[j];
            }
            result = temp2;
        }
        return result;
    }

    private byte[] getBytesForCMTS_Mic() throws Exception {
        byte[] result = new byte[]{};
        for (int i = 0; i < CMTS_MIC_LIST.length; ++i) {
            if (CMTS_MIC_LIST[i] == 6) {
                int j;
                this.calculateCM_Mic();
                byte[] cmmic = this.getCM_Mic().getEncoded();
                byte[] temp = new byte[result.length + cmmic.length];
                for (j = 0; j < result.length; ++j) {
                    temp[j] = result[j];
                }
                for (j = 0; j < cmmic.length; ++j) {
                    temp[j + result.length] = cmmic[j];
                }
                result = temp;
                continue;
            }
            if (!this.typePresent(CMTS_MIC_LIST[i])) continue;
            ArrayList<ITLV> list = this.getTLV(CMTS_MIC_LIST[i]);
            Iterator<ITLV> it = list.iterator();
            while (it.hasNext()) {
                int j;
                byte[] tlv = ((TLV)it.next()).getEncoded();
                byte[] temp = new byte[result.length + tlv.length];
                for (j = 0; j < result.length; ++j) {
                    temp[j] = result[j];
                }
                for (j = 0; j < tlv.length; ++j) {
                    temp[j + result.length] = tlv[j];
                }
                result = temp;
            }
        }
        return result;
    }

    private byte[] getBytesForExtendedCMTS_Mic(BitSet bs, int alg) throws Exception {
        byte[] result = new byte[]{};
        for (TLV tLV : this.getAllTLVs()) {
            int j;
            EXTMIC_Digest dg;
            int tlvtype = tLV.getType();
            if (tlvtype == 6 || tlvtype == 7 || !bs.get(tlvtype)) continue;
            if (tlvtype == 43 && (dg = this.getExtMicDigest()) != null) {
                if (alg == 2) {
                    dg.setMask(new byte[8]);
                } else {
                    dg.setMask(new byte[16]);
                }
            }
            byte[] tlvbytes = tLV.getEncoded();
            byte[] temp = new byte[result.length + tlvbytes.length];
            for (j = 0; j < result.length; ++j) {
                temp[j] = result[j];
            }
            for (j = 0; j < tlvbytes.length; ++j) {
                temp[j + result.length] = tlvbytes[j];
            }
            result = temp;
        }
        return result;
    }

    private int getTotalLength() {
        int total = 0;
        Iterator<ITLV> it = this.itsTLVs.iterator();
        while (it.hasNext()) {
            total += ((TLV)it.next()).getTotalLength();
        }
        total += this.itsCM_Mic.getTotalLength();
        total += this.itsCMTS_Mic.getTotalLength();
        return ++total;
    }

    private int getTotalTlvLength() {
        int total = 0;
        Iterator<ITLV> it = this.itsTLVs.iterator();
        while (it.hasNext()) {
            total += ((TLV)it.next()).getTotalLength();
        }
        return total;
    }

    public byte[] getEncoded() throws Exception {
        return this.getEncoded("Euro");
    }

    public byte[] getEncoded(String sharedSecret) throws Exception {
        return this.getEncoded(sharedSecret, "ExtendedEuro");
    }

    public byte[] getExtMicBitMap() {
        TLV_ExtensionField extfield = this.getExtensionWithExtendedMic();
        if (extfield == null) {
            return null;
        }
        ExtensionField_ExtendedCmtsMic ef_mic = (ExtensionField_ExtendedCmtsMic)extfield.getSubTypeTLVs(6).iterator().next();
        if (!ef_mic.subTypePresent(2)) {
            return null;
        }
        return ((EXTMIC_Bitmap)ef_mic.getSubTypeTLVs(2).iterator().next()).getValue();
    }

    public EXTMIC_Digest getExtMicDigest() {
        TLV_ExtensionField extfield = this.getExtensionWithExtendedMic();
        if (extfield == null) {
            return null;
        }
        ExtensionField_ExtendedCmtsMic ef_mic = (ExtensionField_ExtendedCmtsMic)extfield.getSubTypeTLVs(6).iterator().next();
        if (!ef_mic.subTypePresent(3)) {
            return null;
        }
        return (EXTMIC_Digest)ef_mic.getSubTypeTLVs(3).iterator().next();
    }

    public TLV_ExtensionField getExtensionWithExtendedMic() {
        ArrayList<ITLV> l = this.getTLV(43);
        for (ITLV vs : l) {
            if (!(vs instanceof TLV_ExtensionField) || !((TLV_ExtensionField)vs).subTypePresent(6)) continue;
            return (TLV_ExtensionField)vs;
        }
        return null;
    }

    public int getExtMicAlg() {
        TLV_ExtensionField extfield = this.getExtensionWithExtendedMic();
        if (extfield == null) {
            return 0;
        }
        ExtensionField_ExtendedCmtsMic ef_mic = (ExtensionField_ExtendedCmtsMic)extfield.getSubTypeTLVs(6).iterator().next();
        if (!ef_mic.subTypePresent(1)) {
            return 0;
        }
        return ((EXTMIC_HmacType)ef_mic.getSubTypeTLVs(1).iterator().next()).getHmacType();
    }

    public byte[] getEncoded(String sharedSecret, String extendedSharedSecret) throws Exception {
        byte[] bitmap = this.getExtMicBitMap();
        boolean extended_digest_in_cmts_mic = false;
        if (bitmap != null) {
            BIT_STRING bs = new BIT_STRING(bitmap, 0);
            byte[] inputforestmic = this.getBytesForExtendedCMTS_Mic(bs.toBitSet(), this.getExtMicAlg());
            byte[] digest = this.calculateExtendedCMTS_Mic(extendedSharedSecret, inputforestmic, this.getExtMicAlg());
            if (this.getExtMicDigest() != null) {
                this.getExtMicDigest().setMask(digest);
            } else {
                this.itsCMTS_Mic = new TLV_CmtsMic(7, digest);
                extended_digest_in_cmts_mic = true;
            }
            TLV_ExtensionField vs = this.getExtensionWithExtendedMic();
            if (vs != null) {
                this.removeTLV(vs);
                this.appendTLV(vs);
            }
        }
        if (!extended_digest_in_cmts_mic) {
            this.calculateCMTS_Mic(sharedSecret);
        } else {
            this.calculateCM_Mic();
        }
        byte[] encode = new byte[this.getTotalLength()];
        int pointer = 0;
        Iterator<ITLV> it = this.itsTLVs.iterator();
        while (it.hasNext()) {
            byte[] tlv = it.next().getEncoded();
            if (tlv == null) continue;
            for (int j = 0; j < tlv.length; ++j) {
                encode[pointer++] = tlv[j];
            }
        }
        byte[] cm = this.itsCM_Mic.getEncoded();
        for (int i = 0; i < cm.length; ++i) {
            encode[pointer++] = cm[i];
        }
        byte[] cmts = this.itsCMTS_Mic.getEncoded();
        for (int i = 0; i < cmts.length; ++i) {
            encode[pointer++] = cmts[i];
        }
        encode[pointer++] = -1;
        return encode;
    }

    public boolean is10() {
        return this.typePresent(4);
    }

    public boolean is11() {
        return this.typePresent(25) || this.typePresent(24);
    }

    public boolean classifier_used(int newref) {
        int[] usedRefs = this.getUsedClassifierRefs();
        if (usedRefs == null) {
            return false;
        }
        for (int i = 0; i < usedRefs.length; ++i) {
            if (usedRefs[i] != newref) continue;
            return true;
        }
        return false;
    }

    public int checkPHS() {
        if (!this.typePresent(26)) {
            return 0;
        }
        ArrayList<ITLV> l = this.getTLV(26);
        for (TLV_PHS tLV_PHS : l) {
            PHS_Mask phsm;
            if (!tLV_PHS.subTypePresent(1)) {
                return 1;
            }
            if (!tLV_PHS.subTypePresent(3)) {
                return 2;
            }
            if (!tLV_PHS.subTypePresent(7)) {
                return 3;
            }
            if (!tLV_PHS.subTypePresent(10)) {
                return 4;
            }
            PHS_Size phss = (PHS_Size)tLV_PHS.getSubTypeTLVs(10).iterator().next();
            PHS_Field phsf = (PHS_Field)tLV_PHS.getSubTypeTLVs(7).iterator().next();
            if (phss.getNumber() != phsf.getValue().length) {
                return 5;
            }
            PHS_ClassifierReference phscl = (PHS_ClassifierReference)tLV_PHS.getSubTypeTLVs(1).iterator().next();
            if (!this.classifier_used(phscl.getReference())) {
                return 6;
            }
            PHS_ServiceFlowReference phssf = (PHS_ServiceFlowReference)tLV_PHS.getSubTypeTLVs(3).iterator().next();
            if (this.usedRefsTable.get(new Integer(phssf.getReference())) == null) {
                return 7;
            }
            if (tLV_PHS.subTypePresent(9) && (phsm = (PHS_Mask)tLV_PHS.getSubTypeTLVs(9).iterator().next()).getValue().length != (int)Math.ceil((double)phsf.getValue().length / 8.0)) {
                return 8;
            }
            TLV_PacketClassifier clas = this.getClassifier(phscl.getReference());
            if (clas == null) {
                return 6;
            }
            if (!clas.subTypePresent(3)) {
                return 9;
            }
            CLAS_ServiceFlowReference csf = (CLAS_ServiceFlowReference)clas.getSubTypeTLVs(3).iterator().next();
            if (csf.getReference() == phssf.getReference()) continue;
            return 10;
        }
        return 0;
    }

    public int checkClassifiers() {
        CLAS_IPPacketClassification ipclas;
        int ref;
        CLAS_ServiceFlowReference classer;
        if (!this.typePresent(22) && !this.typePresent(23)) {
            return 0;
        }
        ArrayList<ITLV> l = this.getTLV(22);
        for (TLV_PacketClassifier tLV_PacketClassifier : l) {
            if (!tLV_PacketClassifier.subTypePresent(1)) {
                return 1;
            }
            if (!tLV_PacketClassifier.subTypePresent(3)) {
                return 2;
            }
            if (!(tLV_PacketClassifier.subTypePresent(9) || tLV_PacketClassifier.subTypePresent(12) || tLV_PacketClassifier.subTypePresent(10) || tLV_PacketClassifier.subTypePresent(11) || tLV_PacketClassifier.subTypePresent(14) || tLV_PacketClassifier.subTypePresent(15) || tLV_PacketClassifier.subTypePresent(16) || tLV_PacketClassifier.subTypePresent(17) || tLV_PacketClassifier.subTypePresent(43))) {
                return 3;
            }
            classer = (CLAS_ServiceFlowReference)tLV_PacketClassifier.getSubTypeTLVs(3).iterator().next();
            ref = classer.getReference();
            if (this.getServiceFlow(ref) == null) {
                return 4;
            }
            if (!(this.getServiceFlow(ref) instanceof TLV_UpstreamServiceFlow) && !(this.getServiceFlow(ref) instanceof TLV_UpstreamAggregateServiceFlow)) {
                return 5;
            }
            if (!tLV_PacketClassifier.subTypePresent(9)) continue;
            ipclas = (CLAS_IPPacketClassification)tLV_PacketClassifier.getSubTypeTLVs(9).iterator().next();
            if (!tLV_PacketClassifier.subTypePresent(12) || !ipclas.subTypePresent(1) && !ipclas.subTypePresent(2) && !ipclas.subTypePresent(3) && !ipclas.subTypePresent(4) && !ipclas.subTypePresent(5) && !ipclas.subTypePresent(6)) continue;
            return 7;
        }
        l = this.getTLV(23);
        for (TLV_PacketClassifier tLV_PacketClassifier : l) {
            if (!tLV_PacketClassifier.subTypePresent(1)) {
                return 1;
            }
            if (!tLV_PacketClassifier.subTypePresent(3)) {
                return 2;
            }
            if (!(tLV_PacketClassifier.subTypePresent(9) || tLV_PacketClassifier.subTypePresent(12) || tLV_PacketClassifier.subTypePresent(10) || tLV_PacketClassifier.subTypePresent(11) || tLV_PacketClassifier.subTypePresent(14) || tLV_PacketClassifier.subTypePresent(15) || tLV_PacketClassifier.subTypePresent(16) || tLV_PacketClassifier.subTypePresent(17) || tLV_PacketClassifier.subTypePresent(43))) {
                return 3;
            }
            classer = (CLAS_ServiceFlowReference)tLV_PacketClassifier.getSubTypeTLVs(3).iterator().next();
            ref = classer.getReference();
            if (this.getServiceFlow(ref) == null) {
                return 4;
            }
            if (!(this.getServiceFlow(ref) instanceof TLV_DownstreamServiceFlow) && !(this.getServiceFlow(ref) instanceof TLV_DownstreamAggregateServiceFlow)) {
                return 6;
            }
            if (!tLV_PacketClassifier.subTypePresent(9)) continue;
            ipclas = (CLAS_IPPacketClassification)tLV_PacketClassifier.getSubTypeTLVs(9).iterator().next();
            if (!tLV_PacketClassifier.subTypePresent(12) || !ipclas.subTypePresent(1) && !ipclas.subTypePresent(2) && !ipclas.subTypePresent(3) && !ipclas.subTypePresent(4) && !ipclas.subTypePresent(5) && !ipclas.subTypePresent(6)) continue;
            return 7;
        }
        return 0;
    }

    public int checkServiceFlows() {
        if (!this.typePresent(24) && !this.typePresent(25)) {
            return 0;
        }
        ArrayList<ITLV> l = this.getTLV(24);
        for (TLV_UpstreamServiceFlow tLV_UpstreamServiceFlow : l) {
            SF_SchedulingType sched;
            if (!tLV_UpstreamServiceFlow.subTypePresent(1)) {
                return 1;
            }
            if (!tLV_UpstreamServiceFlow.subTypePresent(6)) {
                return 2;
            }
            if (!tLV_UpstreamServiceFlow.subTypePresent(15) || (sched = (SF_SchedulingType)tLV_UpstreamServiceFlow.getSubTypeTLVs(15).iterator().next()).getSchedulingType() == 2 || tLV_UpstreamServiceFlow.subTypePresent(16)) continue;
            return 3;
        }
        l = this.getTLV(25);
        for (TLV_DownstreamServiceFlow tLV_DownstreamServiceFlow : l) {
            if (!tLV_DownstreamServiceFlow.subTypePresent(1)) {
                return 1;
            }
            if (tLV_DownstreamServiceFlow.subTypePresent(6)) continue;
            return 2;
        }
        return 0;
    }

    public int checkCosFlows() {
        if (!this.typePresent(4)) {
            return 0;
        }
        ArrayList<ITLV> l = this.getTLV(4);
        for (TLV_DOCSIS_1_0_COS tLV_DOCSIS_1_0_COS : l) {
            if (!tLV_DOCSIS_1_0_COS.subTypePresent(1)) {
                return 1;
            }
            if (tLV_DOCSIS_1_0_COS.subTypePresent(7)) continue;
            return 2;
        }
        return 0;
    }

    public void checkASFs() throws Exception {
        ArrayList<ITLV> al = this.getTLV(70);
        Iterator<ITLV> ait = al.iterator();
        while (ait.hasNext()) {
            TLV_UpstreamAggregateServiceFlow clas = (TLV_UpstreamAggregateServiceFlow)ait.next();
            if (clas.subTypePresent(1)) continue;
            throw new Exception("Found Upstream Aggregate Service Flow without Service Flow Reference");
        }
        ArrayList<ITLV> l = this.getTLV(24);
        for (TLV_UpstreamServiceFlow tLV_UpstreamServiceFlow : l) {
            if (!tLV_UpstreamServiceFlow.subTypePresent(36)) continue;
            SF_AggregateSFReference asf_ref = (SF_AggregateSFReference)tLV_UpstreamServiceFlow.getSubTypeTLVs(36).iterator().next();
            ArrayList<ITLV> asf = this.getTLV(70);
            Iterator<ITLV> asfit = asf.iterator();
            boolean bl = false;
            while (asfit.hasNext()) {
                TLV_UpstreamAggregateServiceFlow uasf = (TLV_UpstreamAggregateServiceFlow)asfit.next();
                if (uasf.getReference() != asf_ref.getNumber()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new Exception("US SF with ref " + tLV_UpstreamServiceFlow.getReference() + " has ASF reference " + asf_ref.getNumber() + ", but no such US ASF exists.");
        }
        ArrayList<ITLV> arrayList = this.getTLV(71);
        Iterator<ITLV> dait = arrayList.iterator();
        while (ait.hasNext()) {
            TLV_DownstreamAggregateServiceFlow clas = (TLV_DownstreamAggregateServiceFlow)dait.next();
            if (clas.subTypePresent(1)) continue;
            throw new Exception("Found Downstream Aggregate Service Flow without Service Flow Reference");
        }
        ArrayList<ITLV> dl = this.getTLV(25);
        for (TLV_DownstreamServiceFlow tLV_DownstreamServiceFlow : dl) {
            if (!tLV_DownstreamServiceFlow.subTypePresent(36)) continue;
            SF_AggregateSFReference asf_ref = (SF_AggregateSFReference)tLV_DownstreamServiceFlow.getSubTypeTLVs(36).iterator().next();
            ArrayList<ITLV> asf = this.getTLV(71);
            Iterator<ITLV> asfit = asf.iterator();
            boolean present = false;
            while (asfit.hasNext()) {
                TLV_DownstreamAggregateServiceFlow uasf = (TLV_DownstreamAggregateServiceFlow)asfit.next();
                if (uasf.getReference() != asf_ref.getNumber()) continue;
                present = true;
                break;
            }
            if (present) continue;
            throw new Exception("DS SF with ref " + tLV_DownstreamServiceFlow.getReference() + " has ASF reference " + asf_ref.getNumber() + ", but no such DS ASF exists.");
        }
    }

    public void checkMESPs() throws Exception {
        ArrayList<ITLV> al = this.getTLV(72);
        for (TLV_MESP tLV_MESP : al) {
            if (!tLV_MESP.subTypePresent(1)) {
                throw new Exception("Found MESP without Reference");
            }
            int mesp_ref = ((MESP_Reference)tLV_MESP.getSubTypeTLVs(1).iterator().next()).getNumber();
            if (tLV_MESP.subTypePresent(2)) continue;
            throw new Exception("Found MESP with ref " + mesp_ref + " without Bandwidth Profile");
        }
        ArrayList<ITLV> arrayList = this.getTLV(24);
        arrayList.addAll(this.getTLV(25));
        for (TLV_ServiceFlow tLV_ServiceFlow : arrayList) {
            if (!tLV_ServiceFlow.subTypePresent(37)) continue;
            SF_MESPReference asf_ref = (SF_MESPReference)tLV_ServiceFlow.getSubTypeTLVs(37).iterator().next();
            ArrayList<ITLV> asf = this.getTLV(72);
            Iterator<ITLV> asfit = asf.iterator();
            boolean present = false;
            while (asfit.hasNext()) {
                TLV_MESP uasf = (TLV_MESP)asfit.next();
                if (uasf.getReference() != asf_ref.getNumber()) continue;
                present = true;
                break;
            }
            if (present) continue;
            throw new Exception("SF with ref " + tLV_ServiceFlow.getReference() + " has MESP reference " + asf_ref.getNumber() + ", but no such MESP exists.");
        }
    }

    private TLV_PacketClassifier getClassifier(int reference) {
        if (!this.classifier_used(reference)) {
            return null;
        }
        ArrayList<ITLV> l = this.getTLV(22);
        l.addAll(this.getTLV(23));
        for (TLV_PacketClassifier tLV_PacketClassifier : l) {
            CLAS_ClassifierReference cl;
            if (!tLV_PacketClassifier.subTypePresent(1) || (cl = (CLAS_ClassifierReference)tLV_PacketClassifier.getSubTypeTLVs(1).iterator().next()).getReference() != reference) continue;
            return tLV_PacketClassifier;
        }
        return null;
    }

    public TLV getServiceFlow(int reference) {
        if (this.usedRefsTable.get(new Integer(reference)) == null) {
            return null;
        }
        int[] sftypes = new int[]{24, 70, 25, 71};
        for (int i = 0; i < sftypes.length; ++i) {
            ArrayList<ITLV> l = this.getTLV(sftypes[i]);
            for (TLV_ServiceFlow tLV_ServiceFlow : l) {
                SF_Reference usfr;
                if (!tLV_ServiceFlow.subTypePresent(1) || (usfr = (SF_Reference)tLV_ServiceFlow.getSubTypeTLVs(1).iterator().next()).getReference() != reference) continue;
                return tLV_ServiceFlow;
            }
        }
        return null;
    }

    public ArrayList getUpstreamServiceFlows(int serviceFlowReference) throws Exception {
        ArrayList<TLV_UpstreamServiceFlow> returnList = new ArrayList<TLV_UpstreamServiceFlow>();
        ArrayList<ITLV> ups = this.getTLV(24);
        for (TLV_UpstreamServiceFlow tLV_UpstreamServiceFlow : ups) {
            ArrayList<ISubTLV> subs = tLV_UpstreamServiceFlow.getSubTypeTLVs(1);
            if (subs.size() == 0) continue;
            if (subs.size() > 1) {
                throw new Exception("Error: multiple SF references found on a single upstream service flow object!");
            }
            SF_Reference ref = (SF_Reference)subs.iterator().next();
            if (ref.getReference() != serviceFlowReference) continue;
            returnList.add(tLV_UpstreamServiceFlow);
        }
        return returnList;
    }

    public ArrayList getDownstreamServiceFlows(int serviceFlowReference) throws Exception {
        ArrayList<TLV_DownstreamServiceFlow> returnList = new ArrayList<TLV_DownstreamServiceFlow>();
        ArrayList<ITLV> ups = this.getTLV(25);
        for (TLV_DownstreamServiceFlow tLV_DownstreamServiceFlow : ups) {
            ArrayList<ISubTLV> subs = tLV_DownstreamServiceFlow.getSubTypeTLVs(1);
            if (subs.size() == 0) continue;
            if (subs.size() > 1) {
                throw new Exception("Error: multiple SF references found on a single downstream service flow object!");
            }
            SF_Reference ref = (SF_Reference)subs.iterator().next();
            if (ref.getReference() != serviceFlowReference) continue;
            returnList.add(tLV_DownstreamServiceFlow);
        }
        return returnList;
    }

    public ArrayList<ITLV> getClassifiers(int serviceFlowReference) {
        ArrayList<ITLV> returnList = new ArrayList<ITLV>();
        ArrayList<ITLV> classifiers = this.getTLV(22);
        classifiers.addAll(this.getTLV(23));
        for (TLV_PacketClassifier tLV_PacketClassifier : classifiers) {
            CLAS_ServiceFlowReference cserv;
            if (!tLV_PacketClassifier.subTypePresent(3) || (cserv = (CLAS_ServiceFlowReference)tLV_PacketClassifier.getSubTypeTLVs(3).iterator().next()).getReference() != serviceFlowReference) continue;
            returnList.add(tLV_PacketClassifier);
        }
        return returnList;
    }

    public void readFromString(String s, String path) throws Exception {
        ConfigFile cfg = ConfigParser.parseFromString(s, path);
        this.clearStatics();
        this.itsTLVs.clear();
        for (TLV tLV : cfg.getAllTLVs()) {
            if (tLV.getType() == 0) {
                this.itsTLVs.add(tLV);
                continue;
            }
            this.addTLV(tLV.getType(), tLV.getValue());
        }
    }

    public void cheat() {
        cheatMode = true;
        TLV.cheatMode = true;
    }

    public void dontCheat() {
        cheatMode = false;
        TLV.cheatMode = false;
    }

    public static void static_cheat() {
        cheatMode = true;
        TLV.cheatMode = true;
    }

    public static void static_dontCheat() {
        cheatMode = false;
        TLV.cheatMode = false;
    }

    public static boolean getCheatMode() {
        return cheatMode;
    }

    public int[] getUsedRefs() {
        return this.usedRefs;
    }

    public int[] getUsedCosIds() {
        return this.used_COS_IDs;
    }

    public void setUsedCosIds(int[] cosids) {
        this.used_COS_IDs = (int[])cosids.clone();
    }

    public int[] getUsedClassifierRefs() {
        return this.usedClassifierRefs;
    }

    public void setUsedClassifierRefs(int[] refs) {
        this.usedClassifierRefs = (int[])refs.clone();
    }

    public Hashtable<Integer, boolean[]> getUsedRefsTable() {
        return this.usedRefsTable;
    }

    public void setUsedRefs(int[] refs) {
        this.usedRefs = (int[])refs.clone();
    }

    public void setUsedRefsTable(Hashtable<Integer, boolean[]> refstable) {
        this.usedRefsTable = refstable;
    }

    public void clearUsedRefs() {
        this.usedRefs = null;
        this.usedRefsTable.clear();
    }

    public void clearUsedCosIds() {
        this.used_COS_IDs = null;
    }

    public void clearUsedClassifierRefs() {
        this.usedClassifierRefs = null;
    }

    public void updateUsedRef(int ref) throws Exception {
        if (ref == -1) {
            return;
        }
        ArrayList us = this.getUpstreamServiceFlows(ref);
        ArrayList ds = this.getDownstreamServiceFlows(ref);
        if (this.usedRefs == null) {
            this.usedRefs = new int[1];
            this.usedRefs[0] = ref;
        } else {
            boolean present = false;
            for (int i = 0; i < this.usedRefs.length; ++i) {
                if (this.usedRefs[i] != ref) continue;
                present = true;
                break;
            }
            if (!present) {
                int[] dummy = new int[this.usedRefs.length + 1];
                for (int i = 0; i < this.usedRefs.length; ++i) {
                    dummy[i] = this.usedRefs[i];
                }
                dummy[this.usedRefs.length] = ref;
                this.usedRefs = dummy;
            }
        }
        boolean[] qos = new boolean[3];
        if (us.size() > 0 && ds.size() > 0) {
            throw new Exception("Reference " + ref + " was found in both upstream and downstream service flows!");
        }
        if (us.size() > 0) {
            for (TLV_UpstreamServiceFlow usf : us) {
                boolean[] newqos = usf.getQosSettings();
                for (int i = 0; i < 3; ++i) {
                    int n = i;
                    qos[n] = qos[n] | newqos[i];
                }
            }
        } else {
            for (TLV_DownstreamServiceFlow dsf : ds) {
                boolean[] newqos = dsf.getQosSettings();
                for (int i = 0; i < 3; ++i) {
                    int n = i;
                    qos[n] = qos[n] | newqos[i];
                }
            }
        }
        this.usedRefsTable.remove(new Integer(ref));
        this.usedRefsTable.put(new Integer(ref), qos);
    }

    public void removeUsedRef(int ref) throws Exception {
        if (ref == -1) {
            return;
        }
        ArrayList us = this.getUpstreamServiceFlows(ref);
        ArrayList ds = this.getDownstreamServiceFlows(ref);
        if (us.size() == 0 && ds.size() == 0) {
            int[] dummy = new int[this.usedRefs.length - 1];
            int current = 0;
            for (int i = 0; i < this.usedRefs.length; ++i) {
                if (this.usedRefs[i] == ref) continue;
                dummy[current++] = this.usedRefs[i];
            }
            this.usedRefs = dummy;
        }
        boolean[] qos = new boolean[3];
        if (us.size() > 0 && ds.size() > 0) {
            throw new Exception("Reference " + ref + " was found in both upstream and downstream service flows!");
        }
        if (us.size() > 0) {
            for (TLV_UpstreamServiceFlow usf : us) {
                boolean[] newqos = usf.getQosSettings();
                for (int i = 0; i < 3; ++i) {
                    int n = i;
                    qos[n] = qos[n] | newqos[i];
                }
            }
        } else if (ds.size() > 0) {
            for (TLV_DownstreamServiceFlow usf : ds) {
                boolean[] newqos = usf.getQosSettings();
                for (int i = 0; i < 3; ++i) {
                    int n = i;
                    qos[n] = qos[n] | newqos[i];
                }
            }
        }
        this.usedRefsTable.remove(new Integer(ref));
        if (us.size() > 0 || ds.size() > 0) {
            this.usedRefsTable.put(new Integer(ref), qos);
        }
    }

    public boolean checkUsedRef(int ref, boolean[] newqos, boolean upstream) throws Exception {
        ArrayList us = this.getUpstreamServiceFlows(ref);
        if (us.size() > 0 && !upstream) {
            return false;
        }
        ArrayList ds = this.getDownstreamServiceFlows(ref);
        if (ds.size() > 0 && upstream) {
            return false;
        }
        boolean[] qos = this.usedRefsTable.get(new Integer(ref));
        if (qos == null) {
            return true;
        }
        for (int i = 0; i < 3; ++i) {
            if (!qos[i] || !newqos[i]) continue;
            return false;
        }
        return true;
    }

    public int getFirstFreeClassifierRef() {
        for (int i = 1; i < 255; ++i) {
            if (this.classifier_used(i)) continue;
            return i;
        }
        return -1;
    }

    public void removeUsedClassifierRef(int ref) {
        int[] usedRefs = this.getUsedClassifierRefs();
        if (usedRefs == null) {
            return;
        }
        if (this.classifier_used(ref)) {
            int[] dummy = new int[usedRefs.length - 1];
            int current = 0;
            for (int i = 0; i < usedRefs.length; ++i) {
                if (usedRefs[i] == ref) continue;
                dummy[current++] = usedRefs[i];
            }
            usedRefs = dummy;
            this.setUsedClassifierRefs(usedRefs);
            return;
        }
    }

    public int getFirstFreeRef() {
        for (int i = 1; i < 65535; ++i) {
            if (this.usedRefsTable.get(new Integer(i)) != null) continue;
            return i;
        }
        return -1;
    }

    public boolean isHexMode() {
        return this.hexMode;
    }

    public void setHexMode(boolean hexMode) {
        this.hexMode = hexMode;
    }
}

