/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile;

import com.excentis.filedialog.FileSelector;
import com.excentis.filedialog.FileSelectorFactory;
import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.ISubTypedTLV;
import com.excentis.security.configfile.Messages;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.TlvInfo;
import com.excentis.security.configfile.gui.ConfigSelectionListener;
import com.excentis.security.configfile.gui.ConfigTreeModel;
import com.excentis.security.configfile.gui.ConfigTreeRenderer;
import com.excentis.security.configfile.gui.HexTextArea;
import com.excentis.security.configfile.gui.InfoDialog;
import com.excentis.security.configfile.gui.TlvSelectionHandler;
import com.excentis.security.configfile.tlvs.TLV_COCVC;
import com.excentis.security.configfile.tlvs.TLV_COCVCChain;
import com.excentis.security.configfile.tlvs.TLV_CVC;
import com.excentis.security.configfile.tlvs.TLV_CVCChain;
import com.excentis.security.configfile.tlvs.TLV_DOCSIS_1_0_COS;
import com.excentis.security.configfile.tlvs.TLV_DocsisV3NotificationReceiver;
import com.excentis.security.configfile.tlvs.TLV_DownstreamServiceFlow;
import com.excentis.security.configfile.tlvs.TLV_Mib;
import com.excentis.security.configfile.tlvs.TLV_NetworkAccessControl;
import com.excentis.security.configfile.tlvs.TLV_PacketClassifier;
import com.excentis.security.configfile.tlvs.TLV_ServiceFlow;
import com.excentis.security.configfile.tlvs.TLV_SnmpV3KickStart;
import com.excentis.security.configfile.tlvs.TLV_UpstreamServiceFlow;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_ClassifierReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.DOCS10_ClassID;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_QoSSet;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_Reference;
import com.excentis.security.tools.Plaintext2Binary;
import com.excentis.security.utils.CertUtils;
import com.excentis.security.utils.FileViewer;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.SplashScreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class ConfigFileGUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    final Color EXCENTIS_BLUE = new Color(0, 173, 239);
    final Color EXCENTIS_ORANGE = new Color(247, 148, 29);
    private static ConfigFileGUI gui;
    private ConfigFile itsConfigFile = null;
    private String sharedSecret = Messages.getString("ConfigFileGUI.sharedSecret");
    private String extendedSharedSecret = Messages.getString("ConfigFileGUI.extendedSharedSecret");
    public static String programDir;
    private String workingDir = System.getProperty(Messages.getString("ConfigFileGUI.currentDir"));
    private String startupConfig = null;
    private boolean saveSuccess = true;
    private byte[] lastSaved = null;
    TlvSelectionHandler itsTlvHandler;
    private boolean textOpened = false;
    HexTextArea hta = new HexTextArea(null);
    SplashScreen splash;
    Graphics2D g;
    JMenuBar jMenuBar = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuFileOpen = new JMenuItem();
    JMenuItem jMenuFileExit = new JMenuItem();
    JSplitPane jSplitPane = new JSplitPane();
    BorderLayout borderLayout = new BorderLayout();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuAbout = new JMenuItem();
    JMenuItem jMenuLicense = new JMenuItem();
    JMenuItem jMenuManual = new JMenuItem();
    JScrollPane jScrollPane1 = new JScrollPane();
    JScrollPane jScrollPane2 = new JScrollPane();
    JTree jTree;
    ConfigTreeModel model;
    JPanel jPanelRight = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanelTop = new JPanel();
    JButton jButtonAdd = new JButton();
    JButton jButtonDelete = new JButton();
    JPanel centerPanel = new JPanel();
    static InfoDialog helpDialog;
    JMenuItem jMenuFileSaveAs = new JMenuItem();
    JMenuItem jMenuFileNew = new JMenuItem();
    JCheckBoxMenuItem jCheckBoxMenuItemInfo = new JCheckBoxMenuItem();
    JButton jButtonRefresh = new JButton();
    JMenuItem jMenuFileSave = new JMenuItem();
    JMenuItem jMenuToolsText = new JMenuItem();
    JButton jButtonCheck = new JButton();
    JButton jButtonApply = new JButton();
    JButton jButtonApplyHex = new JButton();
    JButton moveToText = new JButton();
    JMenu jMenuEdit = new JMenu();
    JMenuItem jMenuEditSharedSecret = new JMenuItem();
    JMenuItem jMenuEditExtendedSharedSecret = new JMenuItem();
    JMenuItem jMenuFileOpenTXT = new JMenuItem();
    JPanel allesPanel = new JPanel();
    JPanel imagepanel = new JPanel();
    public int currentPosition = -2;
    JMenu jMenuOptions = new JMenu();
    JCheckBoxMenuItem jCheckBoxMenuItemCheat = new JCheckBoxMenuItem();
    ButtonGroup toggleHexText = new ButtonGroup();
    JRadioButton hexButton = new JRadioButton("hex");
    JRadioButton textButton = new JRadioButton("text");
    JCheckBox verbose = new JCheckBox("verbose");
    private boolean changespopupshown = false;
    public boolean handlingFocus = false;
    private JLabel imagelabel;
    private ArrayList<String> bannerKeyList;
    private Map<String, String> bannerMap;
    private int bannerImageIndex = 0;

    void renderSplashFrame(Graphics2D g, String component) {
        if (g != null) {
            g.setComposite(AlphaComposite.Clear);
            g.fillRect(20, 140, 200, 40);
            g.setPaintMode();
            g.setColor(this.EXCENTIS_BLUE);
            g.drawString("Loading " + component + "...", 6, 155);
            this.splash.update();
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public HexTextArea getHta() {
        return this.hta;
    }

    public void setHta(HexTextArea hta) {
        this.hta = hta;
    }

    public boolean verboseDisplay() {
        return this.verbose.isSelected();
    }

    private void setConfigFileName(String filename) {
        this.itsConfigFile.setName(filename);
        this.setTitle(Messages.getString("ConfigFileGUI.Title") + " - " + filename);
    }

    void setConfigFile(ConfigFile configFile) {
        try {
            if (configFile == null) {
                this.itsConfigFile = new ConfigFile();
                this.setConfigFileName(Messages.getString("ConfigFileGUI.defaultConfigFileName"));
                this.itsConfigFile.appendTLV(new TLV_NetworkAccessControl(true));
                this.clearStatics();
            } else {
                this.itsConfigFile = configFile;
            }
            this.hta.setConfigFile(this.itsConfigFile);
            if (this.model == null) {
                this.model = new ConfigTreeModel(this.itsConfigFile);
                this.jTree = new JTree(this.model);
            } else {
                this.model.setConfigFile(this.itsConfigFile);
            }
            this.jTree.setFont(new Font("Monospaced", 0, 12));
            this.clearChanges();
            this.refresh();
            this.jTree.setSelectionPath(this.jTree.getPathForRow(0));
        }
        catch (Exception e) {
            StringWriter sr = new StringWriter();
            PrintWriter pw = new PrintWriter(sr);
            e.printStackTrace(pw);
            JOptionPane.showMessageDialog(this, Messages.getString("ConfigFileGUI.empty") + e + Messages.getString("ConfigFileGUI.slashN") + sr.getBuffer(), Messages.getString("ConfigFileGUI.error"), 0);
            e.printStackTrace();
        }
    }

    public JTree getJTree() {
        return this.jTree;
    }

    private void init() {
        this.splash = SplashScreen.getSplashScreen();
        if (this.splash != null) {
            this.g = this.splash.createGraphics();
            if (this.g != null) {
                Font font = new Font("Verdana", 1, 12);
                this.g.setColor(this.EXCENTIS_ORANGE);
                this.g.setFont(font);
                this.g.drawString("DOCSIS Config File Editor", 6, 60);
                this.g.drawString(Messages.getString("ConfigFileGUI.version"), 6, 80);
            }
            this.renderSplashFrame(this.g, "data");
        }
        try {
            try {
                File jarFile = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                programDir = jarFile.getParent();
                File path = jarFile.getParentFile();
                if (path.getName().equalsIgnoreCase("jar")) {
                    programDir = path.getParent();
                }
            }
            catch (URISyntaxException jarFile) {
                // empty catch block
            }
            String desktop = System.getProperty(Messages.getString("ConfigFileGUI.desktop"));
            String osname = System.getProperty(Messages.getString("ConfigFileGUI.osname"));
            if (desktop != null && desktop.equals(Messages.getString("ConfigFileGUI.windows"))) {
                UIManager.setLookAndFeel(Messages.getString("ConfigFileGUI.windowsLF"));
            } else if (osname.toLowerCase().startsWith("mac")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            if (this.splash != null) {
                this.renderSplashFrame(this.g, "user data");
            }
            this.addUserStuff(programDir);
            this.setSize(new Dimension(800, 600));
            this.setConfigFile(null);
            this.jbInit();
            ImageIcon im = null;
            try {
                im = new ImageIcon(this.getClass().getClassLoader().getResource(Messages.getString("ConfigFileGUI.logo")));
            }
            catch (Exception e) {
                im = new ImageIcon(Messages.getString("ConfigFileGUI.logo"));
            }
            this.setIconImage(im.getImage());
        }
        catch (Exception e) {
            StringWriter sr = new StringWriter();
            PrintWriter pw = new PrintWriter(sr);
            e.printStackTrace(pw);
            JOptionPane.showMessageDialog(this, Messages.getString("ConfigFileGUI.empty") + e + Messages.getString("ConfigFileGUI.slashN") + sr.getBuffer(), Messages.getString("ConfigFileGUI.error"), 0);
            e.printStackTrace();
        }
    }

    public ConfigFileGUI() {
        this.itsTlvHandler = new TlvSelectionHandler(this);
        this.init();
        this.setNewConfigFile();
        this.hta.setConfigFile(this.itsConfigFile);
    }

    public ConfigFile getConfigFile() {
        return this.itsConfigFile;
    }

    private void addUserStuff(String path) throws Exception {
        if (this.splash != null) {
            this.renderSplashFrame(this.g, "info screen");
        }
        helpDialog = new InfoDialog(this, Messages.getString("ConfigFileGUI.info"));
        helpDialog.dispose();
        this.setHelpText(Messages.getString("ConfigFileGUI.default_info_message"));
        this.processOptions(path);
        this.jCheckBoxMenuItemCheat.setSelected(ConfigFile.getCheatMode());
    }

    private void processOptions(String path) throws Exception {
        String filename = path == null ? Messages.getString("ConfigFileGUI.configfile_defaults") : path + File.separator + Messages.getString("ConfigFileGUI.configfile_defaults");
        File f = new File(filename);
        List<Object> l = new ArrayList();
        try {
            l = CertUtils.readIni(f);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, Messages.getString("ConfigFileGUI.empty") + e + Messages.getString("ConfigFileGUI.slashN"), Messages.getString("ConfigFileGUI.error"), 2);
        }
        Iterator<Object> it = l.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            if (s.equalsIgnoreCase(Messages.getString("ConfigFileGUI.shared_secret"))) {
                if (!it.hasNext()) {
                    throw new Exception(Messages.getString("ConfigFileGUI.noValueFor") + s + Messages.getString("ConfigFileGUI.inIniFile"));
                }
                this.sharedSecret = (String)it.next();
                continue;
            }
            if (s.equalsIgnoreCase(Messages.getString("ConfigFileGUI.extended_shared_secret"))) {
                if (!it.hasNext()) {
                    throw new Exception(Messages.getString("ConfigFileGUI.noValueFor") + s + Messages.getString("ConfigFileGUI.inIniFile"));
                }
                this.extendedSharedSecret = (String)it.next();
                continue;
            }
            if (s.equalsIgnoreCase(Messages.getString("ConfigFileGUI.workingdir"))) {
                if (!it.hasNext()) {
                    throw new Exception(Messages.getString("ConfigFileGUI.noValueFor") + s + Messages.getString("ConfigFileGUI.inIniFile"));
                }
                this.workingDir = (String)it.next();
                continue;
            }
            if (s.equalsIgnoreCase(Messages.getString("ConfigFileGUI.verboseMode"))) {
                if (!it.hasNext()) {
                    throw new Exception(Messages.getString("ConfigFileGUI.noValueFor") + s + Messages.getString("ConfigFileGUI.inIniFile"));
                }
                String vb = (String)it.next();
                if (!vb.equals("1") && !vb.equals("true") && !vb.equals("enabled") && !vb.equals("on")) continue;
                this.verbose.setSelected(true);
                continue;
            }
            if (s.equalsIgnoreCase(Messages.getString("ConfigFileGUI.startupConfig"))) {
                if (!it.hasNext()) {
                    throw new Exception(Messages.getString("ConfigFileGUI.noValueFor") + s + Messages.getString("ConfigFileGUI.inIniFile"));
                }
                this.startupConfig = (String)it.next();
                continue;
            }
            if (s.equalsIgnoreCase(Messages.getString("ConfigFileGUI.cheatMode"))) {
                if (!it.hasNext()) {
                    throw new Exception(Messages.getString("ConfigFileGUI.noValueFor") + s + Messages.getString("ConfigFileGUI.inIniFile"));
                }
                String cheatstring = (String)it.next();
                boolean cheat = cheatstring.equalsIgnoreCase("on") || cheatstring.equalsIgnoreCase("true") || cheatstring.equalsIgnoreCase("enabled") || cheatstring.equalsIgnoreCase("1");
                if (!cheat) continue;
                ConfigFile.static_cheat();
                continue;
            }
            throw new Exception(Messages.getString("ConfigFileGUI.unknownOption") + s + Messages.getString("ConfigFileGUI.inIniFile"));
        }
        try {
            TLV_Mib.initializeKnownOIDs(path);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, Messages.getString("ConfigFileGUI.empty") + e + Messages.getString("ConfigFileGUI.slashN"), Messages.getString("ConfigFileGUI.error"), 2);
        }
    }

    private ImageIcon getImageFromURL(String url) {
        ImageIcon im;
        try {
            URL webimage = new URL(Messages.getString("ConfigFileGUI.bannerfolderlocation") + url);
            Object content = webimage.getContent();
            im = new ImageIcon(webimage);
        }
        catch (IOException e) {
            System.out.println("" + e);
            try {
                im = new ImageIcon(this.getClass().getClassLoader().getResource(Messages.getString("ConfigFileGUI.excentislogo")));
            }
            catch (Exception imageException) {
                im = new ImageIcon(Messages.getString("ConfigFileGUI.excentislogo"));
            }
        }
        return im;
    }

    public void addBannerMouseListener(JLabel imagelabel, final String url) {
        imagelabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
                try {
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (IOException e) {
                    try {
                        Desktop.getDesktop().browse(new URI(Messages.getString("ConfigFileGUI.excentisurl")));
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.jMenuFileOpen.setText(Messages.getString("ConfigFileGUI.Open"));
        this.jMenuFileOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.jMenuFileOpen_actionPerformed(e);
            }
        });
        this.jMenuFile.setActionCommand(Messages.getString("ConfigFileGUI.File"));
        this.jMenuFile.setText(Messages.getString("ConfigFileGUI.File"));
        this.jMenuFileExit.setActionCommand(Messages.getString("ConfigFileGUI.Exit"));
        this.jMenuFileExit.setText(Messages.getString("ConfigFileGUI.Exit"));
        this.jSplitPane.setDividerSize(3);
        this.jSplitPane.setLastDividerLocation(355);
        this.jSplitPane.setTopComponent(null);
        this.getContentPane().setLayout(this.borderLayout);
        this.jMenuHelp.setText(Messages.getString("ConfigFileGUI.Help"));
        this.jMenuAbout.setText(Messages.getString("ConfigFileGUI.About"));
        this.jMenuAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.jMenuAbout_actionPerformed(e);
            }
        });
        this.jMenuLicense.setText(Messages.getString("ConfigFileGUI.License"));
        this.jMenuLicense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.jMenuLicense_actionPerformed(e);
            }
        });
        this.jMenuManual.setText(Messages.getString("ConfigFileGUI.Manual"));
        this.jMenuManual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.jMenuManual_actionPerformed(e);
            }
        });
        this.jPanelRight.setLayout(this.borderLayout2);
        this.jButtonAdd.setText(Messages.getString("ConfigFileGUI.Add"));
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.jButtonAdd_actionPerformed(e);
            }
        });
        this.jButtonDelete.setText(Messages.getString("ConfigFileGUI.Delete"));
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.jButtonDelete_actionPerformed(e);
            }
        });
        this.jPanelRight.setOpaque(false);
        this.jMenuFileSaveAs.setActionCommand(Messages.getString("ConfigFileGUI.SaveAs"));
        this.jMenuFileSaveAs.setText(Messages.getString("ConfigFileGUI.SaveAs"));
        this.jMenuFileSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.jMenuFileSaveAs_actionPerformed(e);
            }
        });
        this.jMenuFileNew.setText(Messages.getString("ConfigFileGUI.New"));
        this.jMenuFileNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.jMenuFileNew_actionPerformed(e);
            }
        });
        this.jCheckBoxMenuItemInfo.setText(Messages.getString("ConfigFileGUI.Info"));
        this.jCheckBoxMenuItemInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.jCheckBoxMenuItemInfo_actionPerformed(e);
            }
        });
        this.jButtonRefresh.setText(Messages.getString("ConfigFileGUI.Refresh"));
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.jButtonRefresh_actionPerformed(e);
            }
        });
        this.jMenuFileSave.setEnabled(false);
        this.jMenuFileSave.setActionCommand(Messages.getString("ConfigFileGUI.Save"));
        this.jMenuFileSave.setText(Messages.getString("ConfigFileGUI.Save"));
        this.jMenuFileSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.jMenuFileSave_actionPerformed(e);
            }
        });
        this.jMenuToolsText.setText(Messages.getString("ConfigFileGUI.TextOutput"));
        this.jMenuToolsText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.jMenuToolsText_actionPerformed(e);
            }
        });
        this.jButtonCheck.setText(Messages.getString("ConfigFileGUI.Check"));
        this.jButtonCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.jButtonCheck_actionPerformed(e);
            }
        });
        this.jButtonApply.setText(Messages.getString("ConfigFileGUI.Apply"));
        this.jButtonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.applyTextFromCenterPanel();
            }
        });
        this.jButtonApplyHex.setText(Messages.getString("ConfigFileGUI.ApplyHex"));
        this.jButtonApplyHex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.applyHexFromCenterPanel();
            }
        });
        this.moveToText.setText(Messages.getString("ConfigFileGUI.MoveToText"));
        this.moveToText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.setTopPanel(true);
                ConfigFileGUI.this.jTree.setSelectionPath(ConfigFileGUI.this.jTree.getPathForRow(0));
            }
        });
        this.jMenuEdit.setText(Messages.getString("ConfigFileGUI.Edit"));
        this.jMenuEditSharedSecret.setText(Messages.getString("ConfigFileGUI.textSharedSecret"));
        this.jMenuEditSharedSecret.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.jMenuEditSharedSecret_actionPerformed(e);
            }
        });
        this.jMenuEditExtendedSharedSecret.setText(Messages.getString("ConfigFileGUI.textExtendedSharedSecret"));
        this.jMenuEditExtendedSharedSecret.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.jMenuEditExtendedSharedSecret_actionPerformed(e);
            }
        });
        this.jMenuFileOpenTXT.setText(Messages.getString("ConfigFileGUI.OpenTXT"));
        this.jMenuFileOpenTXT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.jMenuFileOpenTXT_actionPerformed(e);
            }
        });
        this.jMenuOptions.setText(Messages.getString("ConfigFileGUI.Options"));
        this.jCheckBoxMenuItemCheat.setEnabled(true);
        this.jCheckBoxMenuItemCheat.setVerifyInputWhenFocusTarget(true);
        this.jCheckBoxMenuItemCheat.setText(Messages.getString("ConfigFileGUI.Cheat"));
        this.jCheckBoxMenuItemCheat.setState(false);
        this.jCheckBoxMenuItemCheat.setSelected(ConfigFile.getCheatMode());
        this.jCheckBoxMenuItemCheat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.jCheckBoxMenuItemCheat_actionPerformed(e);
            }
        });
        this.allesPanel.setLayout(new BorderLayout());
        this.allesPanel.add((Component)this.jSplitPane, "Center");
        this.getContentPane().add((Component)this.allesPanel, "Center");
        this.jSplitPane.add((Component)this.jScrollPane1, "left");
        this.jScrollPane1.getViewport().add((Component)this.jTree, null);
        this.jSplitPane.add((Component)this.jPanelRight, "right");
        this.jPanelRight.add((Component)this.jPanelTop, "North");
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuBar.add(this.jMenuEdit);
        this.jMenuBar.add(this.jMenuOptions);
        this.jMenuBar.add(this.jMenuHelp);
        this.jMenuFile.add(this.jMenuFileNew);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileOpen);
        this.jMenuFile.add(this.jMenuFileOpenTXT);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileSave);
        this.jMenuFile.add(this.jMenuFileSaveAs);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuToolsText);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuHelp.add(this.jCheckBoxMenuItemInfo);
        this.jMenuHelp.add(this.jMenuAbout);
        this.jMenuHelp.add(this.jMenuLicense);
        this.jMenuHelp.add(this.jMenuManual);
        this.textButton.setSelected(!this.itsConfigFile.isHexMode());
        this.textButton.setBackground(Color.WHITE);
        this.textButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.itsConfigFile.setHexMode(false);
                ConfigFileGUI.this.refresh();
            }
        });
        this.hexButton.setSelected(this.itsConfigFile.isHexMode());
        this.hexButton.setBackground(Color.WHITE);
        this.hexButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.itsConfigFile.setHexMode(true);
                ConfigFileGUI.this.refresh();
            }
        });
        this.toggleHexText.add(this.hexButton);
        this.toggleHexText.add(this.textButton);
        this.verbose.setBackground(Color.WHITE);
        this.verbose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.refresh();
            }
        });
        this.jPanelRight.add((Component)this.jScrollPane2, "Center");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        this.bannerMap = new LinkedHashMap<String, String>();
        this.bannerKeyList = new ArrayList();
        this.imagelabel = new JLabel();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            String folderLocation = Messages.getString("ConfigFileGUI.bannerfolderlocation");
            URL file = new URL(folderLocation + "banner.xml");
            HttpURLConnection fileConnection = (HttpURLConnection)file.openConnection();
            fileConnection.setRequestMethod("HEAD");
            if (fileConnection.getResponseCode() != 200) {
                throw new IOException();
            }
            Document document = db.parse(file.openStream());
            document.getDocumentElement().normalize();
            NodeList nodes = document.getElementsByTagName("banner");
            for (int temp = 0; temp < nodes.getLength(); ++temp) {
                Node node = nodes.item(temp);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String image = element.getElementsByTagName("image").item(0).getTextContent();
                String url = element.getElementsByTagName("url").item(0).getTextContent();
                URL bannerImageLocation = new URL(folderLocation + image);
                URL bannerURLLocation = new URL(url);
                HttpURLConnection imageConnection = (HttpURLConnection)bannerImageLocation.openConnection();
                HttpURLConnection urlConnection = (HttpURLConnection)bannerURLLocation.openConnection();
                imageConnection.setRequestMethod("HEAD");
                urlConnection.setRequestMethod("HEAD");
                if (imageConnection.getResponseCode() != 200) continue;
                this.bannerKeyList.add(image);
                if (urlConnection.getResponseCode() == 200) {
                    this.bannerMap.put(image, url);
                    continue;
                }
                this.bannerMap.put(image, Messages.getString("ConfigFileGUI.excentisurl"));
            }
        }
        catch (IOException ioe) {
            System.out.println("banner.xml not found: " + ioe);
            this.addFallbackBanner();
        }
        catch (SAXParseException ioe) {
            System.out.println("Incorrect formatting of banner.xml: " + ioe);
            this.addFallbackBanner();
        }
        if (!this.bannerKeyList.isEmpty() && !this.bannerMap.isEmpty()) {
            this.updateBanner();
        }
        this.imagepanel.setBackground(Color.white);
        this.imagepanel.add(this.imagelabel);
        this.getContentPane().add((Component)this.imagepanel, "South");
        this.imagepanel.setCursor(Cursor.getPredefinedCursor(12));
        if (this.bannerKeyList.size() > 1) {
            int delay = 5800;
            ActionListener taskPerformer = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ConfigFileGUI.this.updateBanner();
                }
            };
            new Timer(delay, taskPerformer).start();
        }
        this.jScrollPane2.getViewport().add((Component)this.centerPanel, null);
        this.jScrollPane2.getVerticalScrollBar().setUnitIncrement(16);
        this.setJMenuBar(this.jMenuBar);
        this.jMenuFileExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFileGUI.this.jMenuFileExit_actionPerformed(e);
            }
        });
        this.setTitle(Messages.getString("ConfigFileGUI.Title"));
        this.centerPanel.setBackground(Color.white);
        this.centerPanel.add(new JLabel(Messages.getString("ConfigFileGUI.textNothinSelected")));
        this.jMenuEdit.add(this.jMenuEditSharedSecret);
        this.jMenuEdit.add(this.jMenuEditExtendedSharedSecret);
        this.jMenuOptions.add(this.jCheckBoxMenuItemCheat);
        this.jTree.addTreeSelectionListener(new ConfigSelectionListener(this.jTree, this));
        this.jTree.setCellRenderer(new ConfigTreeRenderer());
        ToolTipManager.sharedInstance().registerComponent(this.jTree);
        this.jTree.setComponentPopupMenu(this.createPopup());
        this.jTree.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ConfigFileGUI.this.jTree.setSelectionPath(ConfigFileGUI.this.jTree.getPathForLocation(e.getX(), e.getY()));
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }
        });
        this.hta.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!ConfigFileGUI.this.handlingFocus) {
                    ConfigFileGUI.this.handlingFocus = true;
                    if (e.getOppositeComponent() == null || !e.getOppositeComponent().equals(ConfigFileGUI.this.jButtonApply) && !e.getOppositeComponent().equals(ConfigFileGUI.this.jButtonApplyHex)) {
                        ConfigFileGUI.this.checkChangesOnHexText(e);
                    }
                    ConfigFileGUI.this.handlingFocus = false;
                }
            }
        });
        this.expandAll();
        this.jSplitPane.setDividerLocation(340);
    }

    private void addFallbackBanner() {
        ImageIcon im;
        try {
            im = new ImageIcon(this.getClass().getClassLoader().getResource(Messages.getString("ConfigFileGUI.excentislogo")));
        }
        catch (Exception imageException) {
            im = new ImageIcon(Messages.getString("ConfigFileGUI.excentislogo"));
        }
        this.imagelabel.setIcon(im);
        this.addBannerMouseListener(this.imagelabel, Messages.getString("ConfigFileGUI.excentisurl"));
    }

    private void updateBanner() {
        try {
            String bannerImage = this.bannerKeyList.get(this.bannerImageIndex % this.bannerMap.size());
            String bannerURL = this.bannerMap.get(bannerImage);
            ImageIcon im = this.getImageFromURL(bannerImage);
            this.imagelabel.setIcon(im);
            this.addBannerMouseListener(this.imagelabel, bannerURL);
            if (this.imagelabel.getMouseListeners().length > 1) {
                this.imagelabel.removeMouseListener(this.imagelabel.getMouseListeners()[0]);
            }
            this.imagelabel.repaint();
            ++this.bannerImageIndex;
        }
        catch (Exception e) {
            System.out.println("exception while updating banner: " + e);
        }
    }

    private boolean checkChangesOnHexText(FocusEvent e) {
        boolean hexonfocuslost = this.hta.isHex();
        String text = this.hta.getText();
        if (text.equals(this.getConfigFile().writeToString(this.hta.isHex(), this.verbose.isSelected()))) {
            return false;
        }
        int selection = -2;
        if (!this.changespopupshown) {
            this.changespopupshown = true;
            selection = JOptionPane.showOptionDialog(this, Messages.getString("ConfigFileGUI.texthexchangesDetected"), Messages.getString("ConfigFileGUI.texthextitle"), 1, 2, null, null, null);
            this.changespopupshown = false;
        }
        if (selection == 2) {
            this.jTree.setSelectionPath(this.jTree.getPathForRow(0));
            this.setTopPanel(true);
            JPanel p = new JPanel();
            this.hta.setText(text);
            p.add(this.hta);
            this.setCenterPanel(p);
            if (e != null && e.getOppositeComponent() != null && e.getOppositeComponent().equals(this.textButton) && hexonfocuslost) {
                this.toggleHexText.setSelected(this.hexButton.getModel(), true);
                this.itsConfigFile.setHexMode(true);
            } else if (e != null && e.getOppositeComponent() != null && e.getOppositeComponent().equals(this.hexButton) && !hexonfocuslost) {
                this.toggleHexText.setSelected(this.textButton.getModel(), true);
                this.itsConfigFile.setHexMode(false);
            }
            return true;
        }
        if (selection == 0) {
            int row = this.jTree.getRowForPath(this.jTree.getSelectionPath());
            if (hexonfocuslost) {
                if (e != null && e.getOppositeComponent() != null && e.getOppositeComponent().equals(this.textButton)) {
                    this.applyHex(text, false);
                } else {
                    this.applyHex(text, true);
                }
            } else {
                this.applyText(text);
            }
            this.jTree.setSelectionPath(this.jTree.getPathForRow(row));
        } else if (selection == 1) {
            this.hta.setText(this.getConfigFile().writeToString(this.hta.isHex(), this.verbose.isSelected()));
        }
        return false;
    }

    private JPanel buildTopPanel(boolean textmode, boolean hex) {
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        if (textmode) {
            if (hex) {
                panel.add((Component)this.jButtonApplyHex, null);
            } else {
                panel.add((Component)this.jButtonApply, null);
            }
        } else {
            panel.add((Component)this.jButtonAdd, null);
            panel.add((Component)this.jButtonDelete, null);
        }
        panel.add((Component)this.jButtonRefresh, null);
        panel.add((Component)this.jButtonCheck, null);
        if (textmode) {
            panel.add((Component)this.verbose, null);
            panel.add((Component)this.textButton, null);
            panel.add((Component)this.hexButton, null);
        } else {
            panel.add((Component)this.moveToText, null);
        }
        return panel;
    }

    private JPopupMenu createPopup() {
        JPopupMenu popup = new JPopupMenu(Messages.getString("ConfigFileGUI.textTLVAction"));
        JMenuItem add = new JMenuItem(Messages.getString("ConfigFileGUI.add"));
        popup.add(add);
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ConfigFileGUI.this.jButtonAdd_actionPerformed(ae);
            }
        });
        popup.addSeparator();
        JMenuItem delete = new JMenuItem(Messages.getString("ConfigFileGUI.delete"));
        popup.add(delete);
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ConfigFileGUI.this.jButtonDelete_actionPerformed(ae);
            }
        });
        return popup;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.jMenuFileExit_actionPerformed(null);
        } else {
            super.processWindowEvent(e);
        }
    }

    public void jMenuFileExit_actionPerformed(ActionEvent e) {
        try {
            if (this.checkChangesOnHexText(null)) {
                return;
            }
            if (this.changesDetected()) {
                int selection = JOptionPane.showOptionDialog(this, Messages.getString("ConfigFileGUI.changesDetected"), Messages.getString("ConfigFileGUI.Quitting"), 1, 2, null, null, null);
                if (selection == 2) {
                    return;
                }
                if (selection == 0) {
                    this.jMenuFileSave_actionPerformed(null);
                    if (!this.saveSuccess) {
                        return;
                    }
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, Messages.getString("ConfigFileGUI.errorCalculationCurrent") + ex);
        }
        System.exit(0);
    }

    public void setHelpText(String s) {
        helpDialog.getTextArea().setText(s);
        helpDialog.getTextArea().setCaretPosition(0);
        helpDialog.redraw();
        helpDialog.toFront();
    }

    public JPanel getCenterPanel() {
        return this.centerPanel;
    }

    public void setCenterPanel(JPanel p) {
        this.jScrollPane2.getViewport().remove(this.centerPanel);
        this.centerPanel = p;
        this.centerPanel.validate();
        this.centerPanel.setBackground(Color.white);
        this.jScrollPane2.getViewport().add(this.centerPanel);
        this.validate();
    }

    private void clearChanges() throws Exception {
        this.lastSaved = this.itsConfigFile.getEncoded(this.sharedSecret, this.extendedSharedSecret);
    }

    private boolean changesDetected() throws Exception {
        if (!this.jMenuFileSave.isEnabled()) {
            return false;
        }
        byte[] currentConfig = this.itsConfigFile.getEncoded(this.sharedSecret, this.extendedSharedSecret);
        if (currentConfig == null || this.lastSaved == null) {
            return true;
        }
        if (currentConfig.length != this.lastSaved.length) {
            return true;
        }
        for (int i = 0; i < currentConfig.length; ++i) {
            if (currentConfig[i] == this.lastSaved[i]) continue;
            return true;
        }
        return false;
    }

    public void openInitialFile(final File file) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigFileGUI.this.validate();
                try {
                    ConfigFile cfg = new ConfigFile(CertUtils.readFile(file));
                    ConfigFileGUI.this.workingDir = file.getParent();
                    ConfigFileGUI.this.setConfigFile(cfg);
                    ConfigFileGUI.this.setConfigFileName(file.getName());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(gui, e, Messages.getString("ConfigFileGUI.errorStart"), 0);
                }
                ConfigFileGUI.this.setVisible(true);
                ConfigFileGUI.this.jMenuFileSave.setEnabled(true);
            }
        });
    }

    public static void main(final String[] args) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    gui = new ConfigFileGUI();
                    gui.validate();
                    gui.setVisible(true);
                    if (args.length == 1) {
                        gui.openInitialFile(new File(args[0]));
                    }
                }
            });
            if (System.getProperty("os.name").startsWith("Mac")) {
                try {
                    Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
                    Object application = applicationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Class<?> openFilesHandlerClass = Class.forName("com.apple.eawt.OpenFilesHandler");
                    Method setOpenFileHandler = applicationClass.getMethod("setOpenFileHandler", openFilesHandlerClass);
                    setOpenFileHandler.invoke(application, Proxy.newProxyInstance(openFilesHandlerClass.getClassLoader(), new Class[]{openFilesHandlerClass}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            if (method.getName().equals("openFiles")) {
                                List files = (List)args[0].getClass().getMethod("getFiles", new Class[0]).invoke(args[0], new Object[0]);
                                for (File file : files) {
                                    gui.openInitialFile(file);
                                }
                            }
                            return null;
                        }
                    }));
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(gui, e, Messages.getString("ConfigFileGUI.errorStart"), 0);
                }
            }
        }
        catch (Exception e) {
            System.out.println(Messages.getString("ConfigFileGUI.errorStart") + e);
            System.out.println(Messages.getString("ConfigFileGUI.usage"));
        }
    }

    private void openBinaryFile(byte[] bytes, boolean tohex) throws Exception {
        int[] oldlist = null;
        int[] doldlist = null;
        int[] coldlist = null;
        Hashtable<Integer, boolean[]> doldhashtable = null;
        if (this.itsConfigFile.typePresent(4)) {
            oldlist = this.itsConfigFile.getUsedCosIds();
        }
        if (this.itsConfigFile.typePresent(25) || this.itsConfigFile.typePresent(24)) {
            doldlist = this.itsConfigFile.getUsedRefs();
            doldhashtable = this.itsConfigFile.getUsedRefsTable();
        }
        if (this.itsConfigFile.typePresent(22) || this.itsConfigFile.typePresent(23)) {
            coldlist = this.itsConfigFile.getUsedClassifierRefs();
        }
        try {
            this.clearStatics();
            this.itsConfigFile = new ConfigFile((byte[])bytes.clone());
            this.itsConfigFile.setHexMode(tohex);
            this.hta.setConfigFile(this.itsConfigFile);
            if (!tohex) {
                this.clearChanges();
            }
            this.model.setConfigFile(this.itsConfigFile);
            this.refresh();
            this.jTree.setSelectionPath(this.jTree.getPathForRow(0));
            this.textOpened = false;
        }
        catch (Exception ex) {
            if (oldlist != null) {
                this.itsConfigFile.setUsedCosIds(oldlist);
            }
            if (doldlist != null) {
                this.itsConfigFile.setUsedRefs(doldlist);
            }
            if (doldhashtable != null) {
                this.itsConfigFile.setUsedRefsTable(doldhashtable);
            }
            if (coldlist != null) {
                this.itsConfigFile.setUsedClassifierRefs(coldlist);
            }
            throw new Exception("Error setting configfile bytes: " + ex.getMessage());
        }
    }

    void jMenuFileOpen_actionPerformed(ActionEvent e) {
        try {
            FileSelector jfc = FileSelectorFactory.getInstance().create(this, this.workingDir);
            int returnval = jfc.showOpenDialog();
            File f = jfc.getSelectedFile();
            if (f == null || returnval == 1) {
                return;
            }
            this.workingDir = f.isDirectory() ? f.getPath() : f.getParent();
            this.openBinaryFile(CertUtils.readFile(f), false);
            this.setConfigFileName(f.getName());
            this.refresh();
            this.jMenuFileSave.setEnabled(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Can't open file, got exception: " + ex + "\nAre you sure it's a Binary CM configfile?", Messages.getString("ConfigFileGUI.error"), 0);
        }
    }

    void jCheckBoxMenuItemInfo_actionPerformed(ActionEvent e) {
        try {
            if (this.jCheckBoxMenuItemInfo.isSelected()) {
                helpDialog = new InfoDialog(this, Messages.getString("ConfigFileGUI.Info"));
                helpDialog.setLocation(800, 0);
                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.jTree.getLastSelectedPathComponent();
                if (dmtn == null || dmtn.isRoot() || !(dmtn.getUserObject() instanceof TLV)) {
                    this.setHelpText(Messages.getString("ConfigFileGUI.default_info_message"));
                } else {
                    TLV tlv = (TLV)dmtn.getUserObject();
                    this.setHelpText(tlv.getTypeInfo() + " (" + tlv.getFullType() + "):\n" + TlvInfo.getString(tlv.getTypeInfo()));
                }
                helpDialog.validate();
            } else {
                helpDialog.dispose();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex, Messages.getString("ConfigFileGUI.error"), 0);
        }
    }

    public void uncheckInfo() {
        this.jCheckBoxMenuItemInfo.setSelected(false);
    }

    public void refresh() {
        this.model.reload();
        this.expandAll();
        this.jTree.setSelectionRow(0);
    }

    private void expandAll() {
        this.jTree.setVisibleRowCount(3);
        for (int i = 0; i < this.jTree.getRowCount(); ++i) {
            this.jTree.expandRow(i);
        }
        this.validate();
    }

    public void disableSave() {
        this.jMenuFileSave.setEnabled(false);
    }

    public void disableOpen() {
        this.jMenuFileOpen.setEnabled(false);
    }

    public void disableOpenTXT() {
        this.jMenuFileOpenTXT.setEnabled(false);
    }

    public void disableNew() {
        this.jMenuFileNew.setEnabled(false);
    }

    private void setNewConfigFile() {
        block14: {
            int[] oldlist = null;
            if (this.itsConfigFile != null && this.itsConfigFile.typePresent(4)) {
                oldlist = this.itsConfigFile.getUsedCosIds();
            }
            int[] doldlist = null;
            Hashtable<Integer, boolean[]> doldhashtable = null;
            if (this.itsConfigFile != null && (this.itsConfigFile.typePresent(25) || this.itsConfigFile.typePresent(24))) {
                doldlist = this.itsConfigFile.getUsedRefs();
                doldhashtable = this.itsConfigFile.getUsedRefsTable();
            }
            int[] coldlist = null;
            if (this.itsConfigFile != null && (this.itsConfigFile.typePresent(22) || this.itsConfigFile.typePresent(23))) {
                coldlist = this.itsConfigFile.getUsedClassifierRefs();
            }
            try {
                this.clearStatics();
                boolean createdFromINI = false;
                if (this.startupConfig != null) {
                    try {
                        this.itsConfigFile = new ConfigFile(CertUtils.readFile(new File(this.startupConfig)));
                        createdFromINI = true;
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(this, "Error loading startup config " + this.startupConfig + " as defined in INI; will load default", Messages.getString("ConfigFileGUI.error"), 0);
                        this.itsConfigFile = new ConfigFile();
                    }
                } else {
                    this.itsConfigFile = new ConfigFile();
                }
                this.setConfigFileName(Messages.getString("ConfigFileGUI.defaultConfigFileName"));
                if (!createdFromINI) {
                    this.itsConfigFile.appendTLV(new TLV_NetworkAccessControl(true));
                    ArrayList<ISubTLV> subtlvs = new ArrayList<ISubTLV>();
                    TLV_UpstreamServiceFlow ussf = new TLV_UpstreamServiceFlow(subtlvs, this.itsConfigFile);
                    ussf.addSubTLV(new SF_Reference(ussf, this.itsConfigFile.getFirstFreeRef()));
                    ussf.addSubTLV(new SF_QoSSet(ussf, true, true, true));
                    this.itsConfigFile.appendTLV(ussf);
                    subtlvs = new ArrayList();
                    TLV_DownstreamServiceFlow dssf = new TLV_DownstreamServiceFlow(subtlvs, this.itsConfigFile);
                    dssf.addSubTLV(new SF_Reference(dssf, this.itsConfigFile.getFirstFreeRef()));
                    dssf.addSubTLV(new SF_QoSSet(dssf, true, true, true));
                    this.itsConfigFile.appendTLV(dssf);
                }
                this.hta.setConfigFile(this.itsConfigFile);
                this.textOpened = false;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex, Messages.getString("ConfigFileGUI.error"), 0);
                if (oldlist != null) {
                    this.itsConfigFile.setUsedCosIds(oldlist);
                }
                if (doldlist != null) {
                    this.itsConfigFile.setUsedRefs(doldlist);
                }
                if (doldhashtable != null) {
                    this.itsConfigFile.setUsedRefsTable(doldhashtable);
                }
                if (coldlist == null) break block14;
                this.itsConfigFile.setUsedClassifierRefs(coldlist);
            }
        }
        if (this.model != null) {
            this.model.setConfigFile(this.itsConfigFile);
            this.refresh();
        }
    }

    public void clearStatics() {
        this.itsConfigFile.clearUsedRefs();
        this.itsConfigFile.clearUsedCosIds();
        this.itsConfigFile.clearUsedClassifierRefs();
        this.itsConfigFile.V3COUNT = 0;
    }

    void jMenuFileNew_actionPerformed(ActionEvent e) {
        this.setNewConfigFile();
        this.jMenuFileSave.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jMenuFileSaveAs_actionPerformed(ActionEvent e) {
        FileOutputStream fos = null;
        try {
            int row = this.jTree.getRowForPath(this.jTree.getSelectionPath());
            this.performChecks(false);
            FileSelector jfc = FileSelectorFactory.getInstance().create(this, this.workingDir + '/' + this.itsConfigFile.toString());
            int returnval = jfc.showSaveDialog();
            File f = jfc.getSelectedFile();
            if (f == null || returnval == 1) {
                return;
            }
            this.workingDir = f.isDirectory() ? f.getPath() : f.getParent();
            fos = new FileOutputStream(f);
            this.setConfigFileName(f.getName());
            fos.write(this.itsConfigFile.getEncoded(this.sharedSecret, this.extendedSharedSecret));
            this.clearChanges();
            fos.close();
            this.refresh();
            this.jTree.setSelectionPath(this.jTree.getPathForRow(row));
            this.jTree.scrollRowToVisible(row);
            this.jMenuFileSave.setEnabled(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex, Messages.getString("ConfigFileGUI.error"), 0);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    void jButtonAdd_actionPerformed(ActionEvent e) {
        int row = this.jTree.getRowForPath(this.jTree.getSelectionPath());
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.jTree.getLastSelectedPathComponent();
        this.itsTlvHandler.createAndHandleDropdownSelection(e, dmtn);
        this.jTree.setSelectionPath(this.jTree.getPathForRow(row));
        this.jTree.scrollRowToVisible(row);
    }

    void jButtonDelete_actionPerformed(ActionEvent e) {
        try {
            SubTypedTLV doc;
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.jTree.getLastSelectedPathComponent();
            int row = this.jTree.getRowForPath(this.jTree.getSelectionPath());
            if (dmtn == null) {
                return;
            }
            if (dmtn.isRoot()) {
                return;
            }
            if (!(dmtn.getUserObject() instanceof TLV)) {
                return;
            }
            if (dmtn.getUserObject() instanceof ISubTLV) {
                ISubTLV sub = (ISubTLV)dmtn.getUserObject();
                if (sub instanceof DOCS10_ClassID) {
                    ((TLV_DOCSIS_1_0_COS)((DOCS10_ClassID)sub).getParent()).removeUsedID(((DOCS10_ClassID)sub).getIntValue());
                }
                if (sub instanceof CLAS_ClassifierReference) {
                    this.itsConfigFile.removeUsedClassifierRef(((CLAS_ClassifierReference)sub).getReference());
                }
                ((ISubTypedTLV)((Object)sub.getParent())).removeSubTLV(sub);
                if (sub instanceof SF_Reference) {
                    this.itsConfigFile.removeUsedRef(((SF_Reference)sub).getReference());
                }
                if (sub instanceof SF_QoSSet) {
                    TLV_ServiceFlow doc2 = (TLV_ServiceFlow)sub.getParent();
                    int ref = doc2.getReference();
                    this.itsConfigFile.removeUsedRef(ref);
                }
            } else if (dmtn.getUserObject() instanceof TLV_DOCSIS_1_0_COS) {
                doc = (TLV_DOCSIS_1_0_COS)dmtn.getUserObject();
                if (doc.subTypePresent(1)) {
                    DOCS10_ClassID clid = (DOCS10_ClassID)doc.getSubTypeTLVs(1).iterator().next();
                    ((TLV_DOCSIS_1_0_COS)clid.getParent()).removeUsedID(clid.getIntValue());
                }
                this.itsConfigFile.removeTLV((TLV)dmtn.getUserObject());
            } else if (dmtn.getUserObject() instanceof TLV_ServiceFlow) {
                doc = (TLV_ServiceFlow)dmtn.getUserObject();
                this.itsConfigFile.removeTLV((TLV)dmtn.getUserObject());
                if (doc.subTypePresent(1)) {
                    SF_Reference ref = (SF_Reference)doc.getSubTypeTLVs(1).iterator().next();
                    this.itsConfigFile.removeUsedRef(ref.getReference());
                }
            } else if (dmtn.getUserObject() instanceof TLV_PacketClassifier) {
                doc = (TLV_PacketClassifier)dmtn.getUserObject();
                if (doc.subTypePresent(1)) {
                    CLAS_ClassifierReference ref = (CLAS_ClassifierReference)doc.getSubTypeTLVs(1).iterator().next();
                    this.itsConfigFile.removeUsedClassifierRef(ref.getReference());
                }
                this.itsConfigFile.removeTLV((TLV)dmtn.getUserObject());
            } else if (dmtn.getUserObject() instanceof TLV_SnmpV3KickStart) {
                --TLV_SnmpV3KickStart.COUNT;
                this.itsConfigFile.removeTLV((TLV)dmtn.getUserObject());
            } else if (dmtn.getUserObject() instanceof TLV_DocsisV3NotificationReceiver) {
                --this.itsConfigFile.V3COUNT;
                this.itsConfigFile.removeTLV((TLV)dmtn.getUserObject());
            } else if (dmtn.getUserObject() instanceof TLV_CVC) {
                this.itsConfigFile.deleteCVCs(32);
            } else if (dmtn.getUserObject() instanceof TLV_COCVC) {
                this.itsConfigFile.deleteCVCs(33);
            } else if (dmtn.getUserObject() instanceof TLV_CVCChain) {
                this.itsConfigFile.deleteCVCs(81);
            } else if (dmtn.getUserObject() instanceof TLV_COCVCChain) {
                this.itsConfigFile.deleteCVCs(82);
            } else {
                this.itsConfigFile.removeTLV((TLV)dmtn.getUserObject());
            }
            this.itsConfigFile.getAllTLVs().trimToSize();
            this.refresh();
            int rowcount = this.jTree.getRowCount();
            if (rowcount <= row) {
                row = rowcount - 1;
            }
            this.jTree.setSelectionPath(this.jTree.getPathForRow(row));
            this.jTree.scrollRowToVisible(row);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex, Messages.getString("ConfigFileGUI.error"), 0);
        }
    }

    void jMenuAbout_actionPerformed(ActionEvent e) {
        ImageIcon icon = new ImageIcon(this.getIconImage());
        JEditorPane jep = new JEditorPane("text/html", "<html><p><span style=\"color:#f7941d\">" + Messages.getString("ConfigFileGUI.info.product") + "<br/>" + Messages.getString("ConfigFileGUI.version") + "</p><br/>Questions? Check out the knowledge base on our <a href=https://support.excentis.com>Support Portal</a></span><br/><p>Another question or comment? Contact us:<br/><a href=\"mailto:" + Messages.getString("ConfigFileGUI.contact") + "\">" + Messages.getString("ConfigFileGUI.contact") + "</a></p><p>To subscribe for information about updates, register here:<br/><a href=\"https://www.excentis.com/newsletter\">https://www.excentis.com/newsletter</a></p><br/>Java version: " + System.getProperty("java.version") + "<br/>Java runtime: " + System.getProperty("java.home") + "<br/></html>");
        jep.setEditable(false);
        jep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (Exception ex) {
                        System.out.println("tried to browse to " + e.getURL() + ", but couldn't: " + ex.getMessage());
                    }
                }
            }
        });
        JOptionPane.showMessageDialog(this, jep, "About..", 1, icon);
    }

    void jMenuManual_actionPerformed(ActionEvent e) {
        String desktop = System.getProperty(Messages.getString("ConfigFileGUI.desktop"));
        if (desktop != null && desktop.equals(Messages.getString("ConfigFileGUI.windows"))) {
            File f = new File(programDir, Messages.getString("ConfigFileGUI.manual_filename"));
            try {
                Runtime.getRuntime().exec(Messages.getString("ConfigFileGUI.filehandlers") + " " + f);
            }
            catch (Exception ioe) {
                JOptionPane.showMessageDialog(this, ioe, Messages.getString("ConfigFileGUI.error"), 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, Messages.getString("ConfigFileGUI.ManualMessage"));
        }
    }

    void jMenuLicense_actionPerformed(ActionEvent e) {
        FileViewer licenseViewer = new FileViewer(programDir, Messages.getString("ConfigFileGUI.licenseFile"));
        licenseViewer.setTitle(Messages.getString("ConfigFileGUI.license_title"));
        licenseViewer.setIconImage(this.getIconImage());
        licenseViewer.setVisible(true);
    }

    public void jButtonRefresh_actionPerformed(ActionEvent e) {
        String filename = this.itsConfigFile.toString();
        try {
            boolean hexmode = this.itsConfigFile.isHexMode();
            this.openBinaryFile(this.itsConfigFile.getEncoded(), true);
            this.itsConfigFile.setHexMode(hexmode);
            this.setConfigFileName(filename);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex, Messages.getString("ConfigFileGUI.error"), 0);
        }
        int row = this.jTree.getRowForPath(this.jTree.getSelectionPath());
        this.refresh();
        this.jTree.setSelectionPath(this.jTree.getPathForRow(row));
        this.jTree.scrollRowToVisible(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jMenuFileSave_actionPerformed(ActionEvent e) {
        int selection;
        if (this.textOpened && (selection = JOptionPane.showOptionDialog(this, Messages.getString("ConfigFileGUI.lastopenedtxt"), Messages.getString("ConfigFileGUI.overwritetxt"), 0, 2, null, null, null)) == 1) {
            return;
        }
        FileOutputStream fos = null;
        try {
            int row = this.jTree.getRowForPath(this.jTree.getSelectionPath());
            this.performChecks(false);
            File f = new File(this.workingDir + '/' + this.itsConfigFile.toString());
            fos = new FileOutputStream(f);
            fos.write(this.itsConfigFile.getEncoded(this.sharedSecret, this.extendedSharedSecret));
            this.clearChanges();
            fos.close();
            this.refresh();
            this.jTree.setSelectionPath(this.jTree.getPathForRow(row));
            this.jTree.scrollRowToVisible(row);
            this.saveSuccess = true;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex, Messages.getString("ConfigFileGUI.error"), 0);
            this.saveSuccess = false;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jMenuToolsText_actionPerformed(ActionEvent e) {
        BufferedWriter report = null;
        try {
            String filename = this.itsConfigFile.toString();
            filename = filename.contains(".cfg") ? filename.replace(".cfg", ".txt") : filename.concat(".txt");
            FileSelector jfc = FileSelectorFactory.getInstance().create(this, this.workingDir + '/' + filename);
            int returnval = jfc.showSaveDialog();
            File f = jfc.getSelectedFile();
            if (f == null || returnval == 1) {
                return;
            }
            report = new BufferedWriter(new FileWriter(f));
            report.write(this.itsConfigFile.writeToString(false, this.verbose.isSelected()));
            report.close();
            this.refresh();
            this.jMenuFileSave.setEnabled(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex, Messages.getString("ConfigFileGUI.error"), 0);
        }
        finally {
            if (report != null) {
                try {
                    report.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void performChecks(boolean popup_on_ok) {
        int phserror;
        int claserror;
        int sferror;
        int coserror;
        boolean check = true;
        if (!this.itsConfigFile.typePresent(3)) {
            check = false;
            JOptionPane.showMessageDialog(this, Messages.getString("ConfigFileGUI.NACNotPresent"), Messages.getString("ConfigFileGUI.error"), 0);
        }
        if (!(this.itsConfigFile.typePresent(4) || this.itsConfigFile.typePresent(25) && this.itsConfigFile.typePresent(24))) {
            check = false;
            JOptionPane.showMessageDialog(this, Messages.getString("ConfigFileGUI.CoS_SF_NotPresent"), Messages.getString("ConfigFileGUI.error"), 0);
        }
        if (this.itsConfigFile.is10() && this.itsConfigFile.is11()) {
            check = false;
            JOptionPane.showMessageDialog(this, Messages.getString("ConfigFileGUI.Both_CoS_SF_Present"), Messages.getString("ConfigFileGUI.error"), 0);
        }
        if ((coserror = this.itsConfigFile.checkCosFlows()) != 0) {
            check = false;
            JOptionPane.showMessageDialog(this, ConfigFile.cosErrorCodes[coserror], Messages.getString("ConfigFileGUI.CoS_Error"), 0);
        }
        if ((sferror = this.itsConfigFile.checkServiceFlows()) != 0) {
            check = false;
            JOptionPane.showMessageDialog(this, ConfigFile.serviceErrorCodes[sferror], Messages.getString("ConfigFileGUI.Sf_Error"), 0);
        }
        if ((claserror = this.itsConfigFile.checkClassifiers()) != 0) {
            check = false;
            JOptionPane.showMessageDialog(this, ConfigFile.classErrorCodes[claserror], Messages.getString("ConfigFileGUI.Class_Error"), 0);
        }
        if ((phserror = this.itsConfigFile.checkPHS()) != 0) {
            check = false;
            JOptionPane.showMessageDialog(this, ConfigFile.phsErrorCodes[phserror], Messages.getString("ConfigFileGUI.PHS_Error"), 0);
        }
        try {
            this.itsConfigFile.checkASFs();
        }
        catch (Exception e) {
            e.printStackTrace();
            check = false;
            JOptionPane.showMessageDialog(this, e.getMessage(), Messages.getString("ConfigFileGUI.error"), 0);
        }
        try {
            this.itsConfigFile.checkMESPs();
        }
        catch (Exception e) {
            e.printStackTrace();
            check = false;
            JOptionPane.showMessageDialog(this, e.getMessage(), Messages.getString("ConfigFileGUI.error"), 0);
        }
        if (check && popup_on_ok) {
            JOptionPane.showMessageDialog(this, Messages.getString("ConfigFileGUI.textAllChecksPassed"), Messages.getString("ConfigFileGUI.textChecks"), 1);
        }
    }

    void jButtonCheck_actionPerformed(ActionEvent e) {
        this.performChecks(true);
    }

    public void applyText(String text) {
        if (!text.equals("")) {
            this.openTextFile(text);
        }
    }

    private void applyTextFromCenterPanel() {
        String text = "";
        try {
            Component[] components = this.jPanelRight.getComponents();
            text = ((JTextArea)((JPanel)((JScrollPane)components[0]).getViewport().getComponents()[0]).getComponents()[0]).getText();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, Messages.getString("ConfigFileGUI.cfgparseerrortext") + ": " + e.getMessage(), Messages.getString("ConfigFileGUI.cfgparseerror"), 0);
        }
        this.applyText(text);
    }

    public void applyHex(String hex, boolean toHex) {
        String[] lines = hex.split("\n");
        String retval = "";
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].trim().startsWith("/*")) continue;
            retval = retval.concat(lines[i] + "\n");
        }
        String text = retval;
        text = text.replaceAll("\n", "");
        text = text.replaceAll("\t", "");
        text = text.replaceAll(" ", "");
        if (!(text = text.trim()).equals("")) {
            try {
                String newfilename = this.itsConfigFile.toString();
                this.openBinaryFile(new Plaintext2Binary(text).getBytes(), toHex);
                this.setConfigFileName(newfilename);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Can't parse hex, got exception: " + ex + "\nAre you sure it's a Hex-represented CM configfile? If so, check format!", Messages.getString("ConfigFileGUI.error"), 0);
            }
        }
    }

    private void applyHexFromCenterPanel() {
        String text = "";
        try {
            Component[] components = this.jPanelRight.getComponents();
            text = ((JTextArea)((JPanel)((JScrollPane)components[0]).getViewport().getComponents()[0]).getComponents()[0]).getText();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, Messages.getString("ConfigFileGUI.cfgparseerrortext") + ": " + e.getMessage(), Messages.getString("ConfigFileGUI.cfgparseerror"), 0);
        }
        this.applyHex(text, true);
        this.refresh();
    }

    public void setTopPanel(boolean textmode) {
        this.jPanelRight.remove(this.jPanelTop);
        this.jPanelTop = this.buildTopPanel(textmode, this.itsConfigFile.isHexMode());
        this.jPanelRight.add((Component)this.jPanelTop, "North");
        this.jPanelRight.repaint();
        this.repaint();
    }

    void jMenuEditSharedSecret_actionPerformed(ActionEvent e) {
        String temp = JOptionPane.showInputDialog(this, Messages.getString("ConfigFileGUI.NewSharedSecret") + this.sharedSecret + Messages.getString("ConfigFileGUI.CloseBracket"), Messages.getString("ConfigFileGUI.textSharedSecret"), 3);
        if (temp != null) {
            this.sharedSecret = temp;
        }
    }

    void jMenuEditExtendedSharedSecret_actionPerformed(ActionEvent e) {
        String temp = JOptionPane.showInputDialog(this, Messages.getString("ConfigFileGUI.NewExtendedSharedSecret") + this.extendedSharedSecret + Messages.getString("ConfigFileGUI.CloseBracket"), Messages.getString("ConfigFileGUI.textExtendedSharedSecret"), 3);
        if (temp != null) {
            this.extendedSharedSecret = temp;
        }
    }

    void jMenuFileOpenTXT_actionPerformed(ActionEvent e) {
        this.openTextFile(null);
        this.textOpened = true;
        this.jMenuFileSave.setEnabled(true);
    }

    void openTextFile(String text) {
        block11: {
            boolean fromFile = text == null || text.isEmpty();
            int[] oldlist = null;
            int[] doldlist = null;
            int[] coldlist = null;
            Hashtable<Integer, boolean[]> doldhashtable = null;
            if (this.itsConfigFile.typePresent(4)) {
                oldlist = this.itsConfigFile.getUsedCosIds();
            }
            if (this.itsConfigFile.typePresent(25) || this.itsConfigFile.typePresent(24)) {
                doldlist = this.itsConfigFile.getUsedRefs();
                doldhashtable = this.itsConfigFile.getUsedRefsTable();
            }
            if (this.itsConfigFile.typePresent(22) || this.itsConfigFile.typePresent(23)) {
                coldlist = this.itsConfigFile.getUsedClassifierRefs();
            }
            try {
                String newfilename = this.itsConfigFile.toString();
                if (text == null || text.equals("")) {
                    FileSelector jfc = FileSelectorFactory.getInstance().create(this, this.workingDir);
                    int returnval = jfc.showOpenDialog();
                    File f = jfc.getSelectedFile();
                    if (f == null || returnval == 1) {
                        return;
                    }
                    this.workingDir = f.isDirectory() ? f.getPath() : f.getParent();
                    text = new String(CertUtils.readFile(f));
                    newfilename = f.getName();
                }
                this.clearStatics();
                this.itsConfigFile.readFromString(text, programDir);
                this.setConfigFileName(newfilename);
                this.model.setConfigFile(this.itsConfigFile);
                this.refresh();
                this.jTree.setSelectionPath(this.jTree.getPathForRow(0));
                if (fromFile) {
                    this.clearChanges();
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Can't parse file, got exception: " + ex + "\nAre you sure it's a Textual CM configfile? If so, check format!", Messages.getString("ConfigFileGUI.error"), 0);
                if (oldlist != null) {
                    this.itsConfigFile.setUsedCosIds(oldlist);
                }
                if (doldlist != null) {
                    this.itsConfigFile.setUsedRefs(doldlist);
                }
                if (doldhashtable != null) {
                    this.itsConfigFile.setUsedRefsTable(doldhashtable);
                }
                if (coldlist == null) break block11;
                this.itsConfigFile.setUsedClassifierRefs(coldlist);
            }
        }
    }

    void jCheckBoxMenuItemCheat_actionPerformed(ActionEvent e) {
        if (this.jCheckBoxMenuItemCheat.isSelected()) {
            this.itsConfigFile.cheat();
        } else {
            this.itsConfigFile.dontCheat();
        }
    }

    static {
        helpDialog = null;
    }
}

