/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile;

import java.math.BigInteger;
import java.net.InetAddress;

public class IPAddress {
    public static final int TYPE = 64;
    private InetAddress itsInetAddress = null;

    public IPAddress(InetAddress ina) {
        this.itsInetAddress = ina;
    }

    public IPAddress(byte[] encoded) throws Exception {
        if (encoded.length != 4) {
            throw new Exception("Length of encoded ip address is " + encoded.length + " instead of 4");
        }
        int first = this.getIntFromBytes(new byte[]{encoded[0]});
        int second = this.getIntFromBytes(new byte[]{encoded[1]});
        int third = this.getIntFromBytes(new byte[]{encoded[2]});
        int fourth = this.getIntFromBytes(new byte[]{encoded[3]});
        this.itsInetAddress = InetAddress.getByName("" + first + "." + second + "." + third + "." + fourth);
    }

    private int getIntFromBytes(byte[] value) {
        byte[] val = new byte[value.length + 1];
        val[0] = 0;
        for (int i = 0; i < value.length; ++i) {
            val[i + 1] = value[i];
        }
        BigInteger big = new BigInteger(val);
        return big.intValue();
    }

    public byte[] getEncoded() {
        byte[] value = this.itsInetAddress.getAddress();
        byte[] retval = new byte[value.length + 2];
        retval[0] = 64;
        retval[1] = (byte)value.length;
        for (int i = 0; i < value.length; ++i) {
            retval[i + 2] = value[i];
        }
        return retval;
    }

    public String toString() {
        return this.itsInetAddress.getHostAddress();
    }
}

