/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.Gauge;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.TLV_Mib;
import com.excentis.security.tools.Plaintext2Binary;
import com.excentis.security.utils.CertUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;

public class MibConfigCreator {
    private ConfigFile itsStartingConfig = null;
    private static String[] itsFilenames = new String[]{"os20-types.cfg", "os20-100.cfg", "os20-wait.cfg", "os20-ignore.cfg", "os20-dup-err.cfg", "os20-dual-err.cfg", "os20-wait-go-err.cfg", "os20-set-err.cfg"};

    public MibConfigCreator(ConfigFile start) {
        this.itsStartingConfig = start;
    }

    public ConfigFile getConfigFile() throws Exception {
        return new ConfigFile(this.itsStartingConfig.getEncoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("usage: java MibConfigCreator <init config file> <text file with mibs>");
            }
            File f1 = new File(args[0]);
            File f2 = new File(args[1]);
            ConfigFile cfg = new ConfigFile(CertUtils.readFile(f1));
            MibConfigCreator mib = new MibConfigCreator(cfg);
            Vector v = mib.parseMibTestFile(f2);
            Iterator it = v.iterator();
            int i = 0;
            while (it.hasNext()) {
                List l = (List)it.next();
                Iterator it2 = l.iterator();
                ConfigFile newConf = mib.getConfigFile();
                while (it2.hasNext()) {
                    newConf.appendTLV((TLV)it2.next());
                }
                File outf = new File(itsFilenames[i++]);
                FileOutputStream outfos = new FileOutputStream(outf);
                try {
                    outfos.write(newConf.getEncoded());
                }
                finally {
                    outfos.close();
                }
            }
        }
        catch (Exception ioe) {
            System.out.println("ERROR: " + ioe);
        }
    }

    private Vector parseMibTestFile(File f) {
        try {
            InputStreamReader fsr = new InputStreamReader(new FileInputStream(f));
            StreamTokenizer st = new StreamTokenizer(fsr);
            st.wordChars(61, 61);
            st.wordChars(45, 45);
            st.wordChars(32, 32);
            st.wordChars(58, 58);
            st.wordChars(46, 46);
            st.wordChars(39, 39);
            st.wordChars(34, 34);
            st.quoteChar(9);
            boolean firstvalue = true;
            Vector v = new Vector();
            ArrayList<TLV_Mib> currentList = new ArrayList<TLV_Mib>();
            while (st.nextToken() != -1) {
                TLV_Mib tlv;
                if (firstvalue && st.sval.equals("sysContact.0")) {
                    if (!currentList.isEmpty()) {
                        v.add(currentList);
                    }
                    currentList = new ArrayList();
                    firstvalue = false;
                    st.pushBack();
                    continue;
                }
                firstvalue = true;
                System.out.println("processing " + st.sval);
                st.nextToken();
                OBJECT_IDENTIFIER oid = new OBJECT_IDENTIFIER(st.sval);
                st.nextToken();
                if (st.sval.equals("Integer")) {
                    st.nextToken();
                    tlv = new TLV_Mib(oid, new INTEGER(Integer.parseInt(st.sval)));
                    currentList.add(tlv);
                    continue;
                }
                if (st.sval.equals("Octet Str")) {
                    st.nextToken();
                    String s = st.sval;
                    if (s.substring(0, 2).equals("0x")) {
                        Plaintext2Binary p2b = new Plaintext2Binary(s.substring(2, s.length()));
                        TLV_Mib tlv2 = new TLV_Mib(oid, new OCTET_STRING(p2b.getBytes()));
                        currentList.add(tlv2);
                        continue;
                    }
                    TLV_Mib tlv3 = new TLV_Mib(oid, new OCTET_STRING(s.getBytes()));
                    currentList.add(tlv3);
                    continue;
                }
                if (st.sval.equals("IpAddress") || st.sval.equals("IpAddr")) {
                    st.nextToken();
                    tlv = new TLV_Mib(oid, InetAddress.getByName(st.sval));
                    currentList.add(tlv);
                    continue;
                }
                if (!st.sval.equals("Guage") && !st.sval.equals("Gauge")) continue;
                st.nextToken();
                tlv = new TLV_Mib(oid, new Gauge(Integer.parseInt(st.sval)));
                currentList.add(tlv);
            }
            v.add(currentList);
            return v;
        }
        catch (IOException ioe) {
            System.out.println("error: " + ioe);
        }
        catch (InvalidLengthException ioe) {
            System.out.println("error: " + ioe);
        }
        catch (UnsupportedTypeException ioe) {
            System.out.println("error: " + ioe);
        }
        return null;
    }
}

