/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.ISubTypedTLV;
import com.excentis.security.configfile.ITLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.TLVNotPresentException;
import com.excentis.security.utils.CertUtils;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public abstract class SubTyped_SubTLV
extends SubTLV
implements ISubTypedTLV {
    private ArrayList<ISubTLV> itsSubTLVs = new ArrayList();

    public SubTyped_SubTLV(TLV parent) {
        super(parent);
    }

    @Override
    public ArrayList<ISubTLV> getSubTLVs() {
        return this.itsSubTLVs;
    }

    @Override
    public void setSubTLVs(ArrayList<ISubTLV> l) {
        this.itsSubTLVs = l;
    }

    public static boolean isSubTyped() {
        return true;
    }

    @Override
    public boolean tlvIsSubTyped() {
        return true;
    }

    @Override
    public void removeSubTLV(ISubTLV tlv) throws TLVNotPresentException {
        if (!this.itsSubTLVs.contains(tlv)) {
            throw new TLVNotPresentException(tlv.getTypeInfo());
        }
        this.itsSubTLVs.remove(tlv);
    }

    protected String getSpacesForType(String type) {
        int lengthdiff = this.getMaxTypeInfoLength() - type.length();
        int numspaces = this.getMaxTypeInfoLength() == 0 ? 1 : (lengthdiff <= 0 ? 1 : lengthdiff + 1);
        String retval = "";
        for (int i = 0; i < numspaces; ++i) {
            retval = retval.concat(" ");
        }
        return retval;
    }

    private int getMaxTypeInfoLength() {
        Iterator<ISubTLV> it = this.getSubTLVs().iterator();
        int maxlen = 0;
        while (it.hasNext()) {
            ISubTLV tlv = it.next();
            if (tlv.getTypeInfo().length() <= maxlen) continue;
            maxlen = tlv.getTypeInfo().length();
        }
        return maxlen;
    }

    @Override
    public JPanel showGUI() {
        JPanel jp = new JPanel();
        JTextArea jText = new JTextArea();
        jp.add(jText);
        jText.setText(this.getTypeInfo() + "\n\n" + TLV.writeToString(this.getSubTLVsAsTLVs(), false, false));
        jText.setEditable(false);
        return jp;
    }

    @Override
    public void addSubTLV(ISubTLV tlv) throws InvalidLengthException {
        this.itsSubTLVs.add(tlv);
        if (this.getValue().length > 255) {
            this.itsSubTLVs.remove(tlv);
            throw new InvalidLengthException(this.getTypeInfo());
        }
        ITLV parent = this.getParent();
        while (parent != null) {
            if (parent.getValue().length > 255) {
                this.itsSubTLVs.remove(tlv);
                throw new InvalidLengthException(parent.getTypeInfo());
            }
            if (parent instanceof SubTLV) {
                parent = ((SubTLV)parent).getParent();
                continue;
            }
            parent = null;
        }
    }

    @Override
    public ArrayList<ISubTLV> getSubTypeTLVs(int type) {
        ArrayList<ISubTLV> subt = this.getSubTLVs();
        if (subt == null) {
            return null;
        }
        Iterator<ISubTLV> it = subt.iterator();
        ArrayList<ISubTLV> subs = new ArrayList<ISubTLV>();
        while (it.hasNext()) {
            ISubTLV subtlv = it.next();
            if (subtlv.getType() != type) continue;
            subs.add(subtlv);
        }
        return subs;
    }

    @Override
    public boolean subTypePresent(int type) {
        ArrayList<ISubTLV> subt = this.getSubTLVs();
        if (subt == null) {
            return false;
        }
        Iterator<ISubTLV> it = subt.iterator();
        while (it.hasNext()) {
            if (it.next().getType() != type) continue;
            return true;
        }
        return false;
    }

    protected byte[] encode(ArrayList<ISubTLV> tlvs) {
        byte[] result = null;
        Iterator<ISubTLV> it = tlvs.iterator();
        while (it.hasNext()) {
            result = CertUtils.appendAt(result, it.next().getEncoded());
        }
        return result;
    }

    @Override
    public byte[] getValue() {
        return this.encode(this.itsSubTLVs);
    }

    @Override
    public int getLength() {
        if (this.getValue() == null) {
            return 0;
        }
        return this.getValue().length;
    }

    @Override
    public ArrayList<ISubTLV> reArrange(ArrayList<ISubTLV> tlvs) {
        ArrayList<ISubTLV> a = new ArrayList<ISubTLV>();
        int max_subtypes = 54;
        if (ConfigFile.getCheatMode()) {
            max_subtypes = 255;
        }
        for (int i = 1; i <= max_subtypes; ++i) {
            for (ISubTLV tlv : tlvs) {
                if (tlv.getType() != i) continue;
                a.add(tlv);
            }
        }
        return a;
    }

    public ArrayList<ITLV> getSubTLVsAsTLVs() {
        ArrayList<ITLV> tlvs = new ArrayList<ITLV>();
        Iterator<ISubTLV> it = this.getSubTLVs().iterator();
        while (it.hasNext()) {
            tlvs.add(it.next());
        }
        return tlvs;
    }

    @Override
    public String getShowValue() {
        return "check field for details";
    }
}

