/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile;

import com.excentis.security.configfile.ConfigFileGUI;
import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.ISubTypedTLV;
import com.excentis.security.configfile.ITLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.panels.BasicTLVPanel;
import com.excentis.security.configfile.tlvs.docsis30.basic.Inet6WithPrefix;
import com.excentis.security.tools.Binary2Plaintext;
import com.excentis.security.utils.CertUtils;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;

public abstract class TLV
implements ITLV {
    public static final int SEQUENCE = 48;
    public static final int SET = 49;
    public static final int INTEGER = 2;
    public static final int OCTET_STRING = 4;
    public static final int DOWNSTREAM_FREQ_CONF = 1;
    public static final int UPSTREAM_CHANNEL_ID_CONF = 2;
    public static final int NETWORK_ACCESS_CONTROL = 3;
    public static final int CLASS_OF_SERVICE_CONF_1_0 = 4;
    public static final int CM_MIC = 6;
    public static final int CMTS_MIC = 7;
    public static final int MAX_CPE = 18;
    public static final int TFTP_TIMESTAMP = 19;
    public static final int TFTP_PROVISIONED_MODEM_IP = 20;
    public static final int UPSTREAM_PACKET_CLASSIFICATION = 22;
    public static final int DOWNSTREAM_PACKET_CLASSIFICATION = 23;
    public static final int UPSTREAM_SERVICE_FLOWS = 24;
    public static final int DOWNSTREAM_SERVICE_FLOWS = 25;
    public static final int PAYLOAD_HEADER_SUPPRESSION = 26;
    public static final int MAX_NUMBER_OF_CLASSIFIERS = 28;
    public static final int PRIVACY_ENABLE = 29;
    public static final int VENDOR_SPECIFIC = 43;
    public static final int SOFTWARE_UPGRADE_FILENAME = 9;
    public static final int SNMP_WRITE_ACCESS_CONTROL = 10;
    public static final int SNMP_MIB_OBJECT = 11;
    public static final int CPE_ETHERNET_MAC = 14;
    public static final int SOFTWARE_UPGRADE_TFTP_SERVER = 21;
    public static final int SNMPV3_KICKSTART = 34;
    public static final int MANUFACTURER_CVC = 32;
    public static final int COSIGNER_CVC = 33;
    public static final int MODEM_CAPABILITIES = 5;
    public static final int VENDOR_ID = 8;
    public static final int MODEM_IP = 12;
    public static final int SERVICE_NOT_AVAILABLE_RESPONSE = 13;
    public static final int HMAC_DIGEST = 27;
    public static final int AUTHORIZATION_BLOCK = 30;
    public static final int KEY_SEQUENCE_NUMBER = 31;
    public static final int SUBSCRIBER_MANAGEMENT_CONTROL = 35;
    public static final int SUBSCRIBER_MANAGEMENT_CPE_IP_TABLE = 36;
    public static final int SUBSCRIBER_MANAGEMENT_FILTER_GROUPS = 37;
    public static final int TELEPHONE_SETTINGS_OPTION = 15;
    public static final int BASELINE_PRIVACY_CONFIGURATION = 17;
    public static final int DOCSIS_V3_NOTIFICATION_RECEIVER = 38;
    public static final int MODE_20 = 39;
    public static final int MODE_TEST = 40;
    public static final int DOWNSTREAM_CHANNEL_LIST = 41;
    public static final int MULTICAST_MAC_ADDRESS = 42;
    public static final int DUT_FILTERING = 45;
    public static final int SNMP_v1v2c_COEXISTENCE = 53;
    public static final int SNMP_v3_ACCESS_VIEW = 54;
    public static final int SNMP_CPE_ACCESS_CONTROL = 55;
    public static final int CHANNEL_ASSIGNMENT_CONFIGURATION_SETTINGS = 56;
    public static final int SOFTWARE_UPGRADE_IPV6_TFTP_SERVER = 58;
    public static final int TFTP_PROVISIONED_MODEM_IPV6_ADDRESS = 59;
    public static final int UPSTREAM_DROP_CLASSIFIER = 60;
    public static final int SUBSCRIBER_MGMT_CPE_IPV6_PREFIX_LIST = 61;
    public static final int UPSTREAM_DROP_CLASSIFIER_GROUP_ID = 62;
    public static final int SUBSCRIBER_MGMT_CONTROL_MAX_CPE_IPV6_ADDRESSES = 63;
    public static final int CMTS_STATIC_MULTICAST_SESSION_ENCODING = 64;
    public static final int L2VPN_MAC_AGING = 65;
    public static final int MANAGEMENT_EVENT_CONTROL_ENCODING = 66;
    public static final int SUBSCRIBER_MANAGEMENT_CPE_IPV6_LIST = 67;
    public static final int DEFAULT_UPSTREAM_TARGET_BUFFER_CONFIGURATION = 68;
    public static final int MAC_ADDRESS_LEARNING_CONTROL_ENCODING = 69;
    public static final int UPSTREAM_AGGREGATE_SERVICE_FLOW = 70;
    public static final int DOWNSTREAM_AGGREGATE_SERVICE_FLOW = 71;
    public static final int METRO_ETHERNET_SERVICE_PROFILE = 72;
    public static final int NETWORK_TIMING_PROFILE = 73;
    public static final int ENERGY_MANAGEMENT_PARAMETER_ENCODING = 74;
    public static final int CM_UPSTREAM_AQM_DISABLE = 76;
    public static final int UNI_CONTROL_ENCODING = 79;
    public static final int MANUFACTURER_CVC_CHAIN = 81;
    public static final int COSIGNER_CVC_CHAIN = 82;
    public static final int DTP_MODE_CONFIGURATION = 83;
    public static final int DIPLEXER_BAND_EDGE = 84;
    public static final int LOW_LATENCY_DISABLE = 91;
    public static final int DISTRIBUTED_HQOS_ENABLE = 92;
    public static final int UPSTREAM_EHQOS_ASF = 93;
    public static final int DOWNSTREAM_EHQOS_ASF = 94;
    public static final int DHQOS_ASF_SID_BUNDLE_ASSIGNMENT = 95;
    public static final int ADVANCED_DIPLEXER_BAND_EDGE = 96;
    public static final int ADVANCED_BAND_PLAN_SUPPORT = 97;
    public static final int DOCSIS_SYNC_CONFIGURATIONS = 101;
    public static final int PTP_ADDRESS_CONFIGURATIONS = 102;
    public static final int CM_SSH_SERVER_CONFIGURATION_SETTINGS = 103;
    public static final int SECURITY_CONFIGURATION_SETTINGS = 104;
    public static final int EROUTER_CONFIGURATION_ENCODINGS = 202;
    public static final int ESTB_CONFIGURATION_ENCODINGS = 217;
    public static final int[] ESAFES = new int[]{201, 216, 219, 220, 221};
    public static final int MAX_SUBTYPE_IDENTIFIER = 54;
    public static final int[] baseTypes = new int[]{1, 2, 3, 4, 6, 7, 9, 10, 11, 14, 15, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 29, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 53, 54, 55, 56, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 76, 79, 81, 82, 83, 84, 91, 92, 93, 94, 95, 96, 97, 101, 102, 103, 104, 202, 217};
    public static final int[] supportedTypes = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 48, 49, 53, 54, 55, 56, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 76, 79, 81, 82, 83, 84, 91, 92, 93, 94, 95, 96, 97, 101, 102, 103, 104, 202, 217, 201, 216, 219, 220, 221};
    public static final int[] supportedSubTypes = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 53, 54};
    public static final String[] twoByteLengh = new String[]{"103", "103.3", "103.3.1", "104", "104.1", "104.1.1", "104.1.2"};
    public static final byte END_OF_DATA = -1;
    public static final byte PADDING_BYTE = 0;
    private int itsType = 0;
    private byte[] itsValue = null;
    public static boolean cheatMode = false;
    private boolean genericTwoByteLen = false;

    public TLV() {
    }

    public TLV(byte[] tlv) throws UnsupportedTypeException, InvalidLengthException {
        int offset;
        this.itsType = this.getTypeFromByte(tlv[0]);
        if (!cheatMode && !this.isSupportedType(this.itsType)) {
            throw new UnsupportedTypeException("base TLV", this.itsType);
        }
        boolean twolength = TLV.isTwoByteLength(this.getFullType());
        int length = twolength ? TLV.getLengthFromBytes(new byte[]{tlv[1], tlv[2]}) : this.getLengthFromByte(tlv[1]);
        int n = offset = twolength ? 2 : 2;
        if (length != tlv.length - offset) {
            throw new InvalidLengthException(this.getTypeInfo());
        }
        this.itsValue = new byte[length];
        System.arraycopy(tlv, offset, this.itsValue, 0, this.itsValue.length);
    }

    public TLV(int type, byte[] value) throws UnsupportedTypeException, InvalidLengthException {
        this.itsType = type;
        if (this.itsType < 0) {
            this.itsType += 256;
        }
        if (!(cheatMode || this.isSupportedType(this.itsType) || this.isSupportedSubType(this.itsType))) {
            throw new UnsupportedTypeException("base TLV", this.itsType);
        }
        this.setData(value);
    }

    public void setType(int type) throws UnsupportedTypeException {
        if (this instanceof ISubTLV) {
            if (!this.isSupportedSubType(type) && !cheatMode) {
                ITLV parent = ((ISubTLV)((Object)this)).getParent();
                throw new UnsupportedTypeException("subTLV for base TLV type " + (parent == null ? "undef" : Integer.valueOf(parent.getType())), type);
            }
        } else if (!this.isSupportedType(type) && !cheatMode) {
            throw new UnsupportedTypeException("base TLV", type);
        }
        this.itsType = type;
    }

    public void setData(byte[] data) throws InvalidLengthException {
        if (data == null) {
            this.itsValue = new byte[0];
        } else {
            if (data.length > 65533) {
                throw new InvalidLengthException(this.getTypeInfo());
            }
            this.itsValue = (byte[])data.clone();
        }
    }

    public static boolean isSubTyped() {
        return false;
    }

    @Override
    public boolean tlvIsSubTyped() {
        return false;
    }

    public boolean isBaseType(int type) {
        boolean sup = false;
        for (int i = 0; i < baseTypes.length; ++i) {
            if (type != baseTypes[i]) continue;
            sup = true;
            break;
        }
        return sup;
    }

    public static boolean isESafeType(int type) {
        boolean sup = false;
        for (int i = 0; i < ESAFES.length; ++i) {
            if (type != ESAFES[i]) continue;
            sup = true;
            break;
        }
        return sup;
    }

    public boolean isSupportedType(int type) {
        boolean sup = false;
        for (int i = 0; i < supportedTypes.length; ++i) {
            if (type != supportedTypes[i]) continue;
            sup = true;
            break;
        }
        return sup;
    }

    private boolean isSupportedSubType(int type) {
        if (cheatMode) {
            return true;
        }
        boolean sup = false;
        for (int i = 0; i < supportedSubTypes.length; ++i) {
            if (type != supportedSubTypes[i]) continue;
            sup = true;
            break;
        }
        return sup;
    }

    public static boolean isTwoByteLength(String fulltype) {
        boolean two = false;
        for (int i = 0; i < twoByteLengh.length; ++i) {
            if (!fulltype.equals(twoByteLengh[i])) continue;
            two = true;
            break;
        }
        return two;
    }

    public void setGenericTwoByteLen(boolean twobyte) {
        this.genericTwoByteLen = twobyte;
    }

    @Override
    public byte[] getEncoded() {
        boolean twobytes = false;
        try {
            twobytes = this.genericTwoByteLen || TLV.isTwoByteLength(this.getFullType());
        }
        catch (Exception e) {
            twobytes = this.genericTwoByteLen;
        }
        int lengthbytes = twobytes ? 2 : 1;
        byte[] total = new byte[this.getLength() + lengthbytes + 1];
        total[0] = (byte)this.getType();
        if (twobytes) {
            byte[] lengthcode = this.encodeInt2(this.getLength());
            total[1] = lengthcode[0];
            total[2] = lengthcode[1];
        } else {
            total[1] = (byte)this.getLength();
        }
        byte[] value = this.getValue();
        if (value != null && value.length > 0) {
            System.arraycopy(value, 0, total, lengthbytes + 1, value.length);
        }
        return total;
    }

    @Override
    public int getType() {
        return this.itsType;
    }

    public int getTypeFromByte(byte typebyte) {
        return typebyte & 0xFF;
    }

    public byte[] getValueFromBytes(int length, int totalLength, int pointer, int type, byte[] encodedSubTypes) throws InvalidLengthException {
        byte[] value = new byte[length];
        if (totalLength < pointer + length) {
            throw new InvalidLengthException("" + this.getTypeInfo() + " subtype " + type);
        }
        for (int i = 0; i < length; ++i) {
            value[i] = encodedSubTypes[pointer++];
        }
        return value;
    }

    public int getLengthFromByte(byte lengthbyte) {
        return lengthbyte & 0xFF;
    }

    public static int getLengthFromBytes(byte[] lengthbytes) {
        return new BigInteger(lengthbytes).intValue();
    }

    public int getLength() {
        if (this.getValue() == null) {
            return 0;
        }
        return this.getValue().length;
    }

    public int getTotalLength() {
        int offset = TLV.isTwoByteLength(this.getFullType()) ? 3 : 2;
        return this.getLength() + offset;
    }

    @Override
    public byte[] getValue() {
        return this.itsValue;
    }

    @Override
    public abstract String getShowValue();

    public String toString() {
        return "Unknown/Unsupported TLV type " + this.itsType;
    }

    public JPanel showGUI() {
        return new BasicTLVPanel(this);
    }

    public JPanel showGUI(ConfigFileGUI cfg) {
        return this.showGUI();
    }

    @Override
    public abstract String getTypeInfo();

    @Override
    public String getFullType() {
        return "" + this.getType();
    }

    protected int getIntFromBytes(byte[] value) {
        byte[] val = new byte[value.length + 1];
        val[0] = 0;
        for (int i = 0; i < value.length; ++i) {
            val[i + 1] = value[i];
        }
        BigInteger big = new BigInteger(val);
        return big.intValue();
    }

    protected long getLongFromBytes(byte[] value) {
        byte[] val = new byte[value.length + 1];
        val[0] = 0;
        for (int i = 0; i < value.length; ++i) {
            val[i + 1] = value[i];
        }
        BigInteger big = new BigInteger(val);
        return big.longValue();
    }

    protected boolean[] getQoSBooleansFromByte(byte[] b) throws Exception {
        if (b.length != 1) {
            throw new Exception("QoS set must be one byte long.");
        }
        byte by = b[0];
        if (by == 7) {
            return new boolean[]{true, true, true};
        }
        if (by == 6) {
            return new boolean[]{false, true, true};
        }
        if (by == 5) {
            return new boolean[]{true, false, true};
        }
        if (by == 4) {
            return new boolean[]{false, false, true};
        }
        if (by == 3) {
            return new boolean[]{true, true, false};
        }
        if (by == 2) {
            return new boolean[]{false, true, false};
        }
        if (by == 1) {
            return new boolean[]{true, false, false};
        }
        if (by == 0) {
            return new boolean[]{false, false, false};
        }
        throw new Exception("Invalid Qos parameter encoding.");
    }

    protected boolean getBooleanFromBytes(byte[] value) {
        return value[0] == 1;
    }

    protected ArrayList<Byte> getBytesArrayFromBytes(byte[] bytes) {
        ArrayList<Byte> byteArray = new ArrayList<Byte>();
        for (int i = 0; i < bytes.length; ++i) {
            Byte id = new Byte(bytes[i]);
            byteArray.add(id);
        }
        return byteArray;
    }

    protected byte[] getBytesArrayFromBytes(ArrayList<Byte> byteArray) {
        Iterator<Byte> it = byteArray.iterator();
        byte[] result = null;
        while (it.hasNext()) {
            Byte byt = it.next();
            result = CertUtils.appendAt(result, byt);
        }
        return result;
    }

    protected Inet6Address getIPv6FromBytes(byte[] value) throws UnknownHostException {
        return (Inet6Address)InetAddress.getByAddress(value);
    }

    protected ArrayList<Inet6Address> getIpv6AddressesFromBytes(byte[] bytes) throws InvalidLengthException, UnknownHostException {
        ArrayList<Inet6Address> addresses = new ArrayList<Inet6Address>();
        if (bytes.length % 16 != 0) {
            throw new InvalidLengthException(this.getTypeInfo());
        }
        byte[] address = new byte[16];
        for (int i = 0; i < bytes.length; i += 16) {
            for (int j = 0; j < 16; ++j) {
                address[j] = bytes[i + j];
            }
            Inet6Address ipv6 = (Inet6Address)InetAddress.getByAddress(address);
            addresses.add(ipv6);
        }
        return addresses;
    }

    protected ArrayList<Inet6WithPrefix> getIpv6AddressPrefixesFromBytes(byte[] bytes) throws InvalidLengthException, UnknownHostException {
        ArrayList<Inet6WithPrefix> addresses = new ArrayList<Inet6WithPrefix>();
        if (bytes.length % 17 != 0) {
            throw new InvalidLengthException(this.getTypeInfo());
        }
        byte[] address = new byte[16];
        for (int i = 0; i < bytes.length; i += 17) {
            for (int j = 0; j < 16; ++j) {
                address[j] = bytes[i + j];
            }
            Inet6Address ipv6 = (Inet6Address)InetAddress.getByAddress(address);
            addresses.add(new Inet6WithPrefix(bytes[i + 16], ipv6));
        }
        return addresses;
    }

    protected byte[] getBytesFromIpv6Addresses(ArrayList<Inet6Address> addresses) {
        Iterator<Inet6Address> it = addresses.iterator();
        byte[] result = null;
        while (it.hasNext()) {
            InetAddress adres = it.next();
            result = CertUtils.appendAt(result, adres.getAddress());
        }
        return result;
    }

    protected byte[] getBytesFromIpv6AddressPrefixes(ArrayList<Inet6WithPrefix> addresses) {
        Iterator<Inet6WithPrefix> it = addresses.iterator();
        byte[] result = null;
        while (it.hasNext()) {
            Inet6WithPrefix inp = it.next();
            result = CertUtils.appendAt(result, inp.getAddress().getAddress());
            result = CertUtils.appendAt(result, (byte)inp.getPrefix());
        }
        return result;
    }

    protected InetAddress getInetAddressFromBytes(byte[] value) throws UnknownHostException {
        int[] result = new int[]{this.getIntFromBytes(new byte[]{value[0]}), this.getIntFromBytes(new byte[]{value[1]}), this.getIntFromBytes(new byte[]{value[2]}), this.getIntFromBytes(new byte[]{value[3]})};
        return InetAddress.getByName("" + result[0] + "." + result[1] + "." + result[2] + "." + result[3]);
    }

    protected byte[] encodeLong(long i) {
        byte[] result = new byte[4];
        long temp = i;
        result[3] = (byte)(temp % 256L);
        result[2] = (byte)((temp /= 256L) % 256L);
        result[1] = (byte)((temp /= 256L) % 256L);
        result[0] = (byte)((temp /= 256L) % 256L);
        return result;
    }

    protected byte[] encodeInt1(int i) {
        return new byte[]{(byte)i};
    }

    protected byte[] encodeInt2(int i) {
        byte[] result = new byte[]{(byte)(i / 256), (byte)(i % 256)};
        return result;
    }

    protected byte[] encodeInt3(int i) {
        byte[] result = new byte[3];
        int temp = i;
        result[2] = (byte)(temp % 256);
        result[1] = (byte)((temp /= 256) % 256);
        result[0] = (byte)((temp /= 256) % 256);
        return result;
    }

    protected byte[] encodeInt4(int i) {
        byte[] result = new byte[4];
        int temp = i;
        result[3] = (byte)(temp % 256);
        result[2] = (byte)((temp /= 256) % 256);
        result[1] = (byte)((temp /= 256) % 256);
        result[0] = (byte)((temp /= 256) % 256);
        return result;
    }

    protected byte[] encodeIntLowHigh(int i, int j) {
        return new byte[]{(byte)i, (byte)j};
    }

    protected byte[] encodeNullTerminatedString(String s) {
        byte[] b = s.getBytes();
        byte[] result = new byte[b.length + 1];
        System.arraycopy(b, 0, result, 0, b.length);
        result[b.length] = 0;
        return result;
    }

    @Override
    public byte[] getTypeAndLength() {
        if (TLV.isTwoByteLength(this.getFullType())) {
            byte[] length = this.encodeInt2(this.getLength());
            return new byte[]{(byte)this.getType(), length[0], length[1]};
        }
        return new byte[]{(byte)this.getType(), (byte)this.getLength()};
    }

    public String decodeStringMinusLast(byte[] value) throws Exception {
        if (value[value.length - 1] != 0) {
            throw new Exception("String must be zero terminated.");
        }
        byte[] real = new byte[value.length - 1];
        for (int i = 0; i < real.length; ++i) {
            real[i] = value[i];
        }
        return new String(real);
    }

    private static String writeTLV(String res, ITLV tlv, boolean inhex, boolean verbose, int offset_spaces) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < offset_spaces; ++i) {
            sb.append(' ');
        }
        res = res.concat(TLV.displayTLV(tlv, inhex, verbose, sb.toString()));
        if (tlv.tlvIsSubTyped()) {
            for (TLV tLV : ((ISubTypedTLV)((Object)tlv)).getSubTLVs()) {
                res = TLV.writeTLV(res, tLV, inhex, verbose, offset_spaces + 2);
            }
        }
        return res;
    }

    public static String writeToString(ArrayList<ITLV> tlvlist, boolean inhex, boolean verbose) {
        String res = "";
        for (ITLV tlv : tlvlist) {
            res = TLV.writeTLV(res, tlv, inhex, verbose, 0);
        }
        return res;
    }

    private static String displayTLV(ITLV tlv, boolean inhex, boolean verbose, String offset) {
        String res = "";
        if (tlv.tlvIsSubTyped()) {
            if (verbose) {
                res = offset + "/* TLV " + tlv.getFullType() + " */\n";
            }
            res = inhex ? res.concat(offset + new Binary2Plaintext(tlv.getTypeAndLength()).getHexRepresentation() + "\n") : res.concat(offset + tlv.getTypeInfo() + "\n");
        } else {
            if (verbose) {
                res = offset + "/* TLV " + tlv.getFullType() + " : 0x" + new Binary2Plaintext(tlv.getValue()).getHexRepresentation() + " */\n";
            }
            res = inhex ? res.concat(offset + new Binary2Plaintext(tlv.getEncoded()).getHexRepresentation() + "\n") : res.concat(offset + tlv.getTypeInfo() + (tlv.getTypeInfo().equals("") ? "" : ":") + tlv.getShowValue() + "\n");
        }
        return res;
    }

    protected boolean has2ByteLength() {
        return false;
    }
}

