/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.gui;

import com.excentis.security.configfile.ConfigFileGUI;
import com.excentis.security.configfile.ITLV;
import com.excentis.security.configfile.Messages;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.TlvInfo;
import com.excentis.security.configfile.gui.ConfigTreeModel;
import com.excentis.security.configfile.gui.HexTextArea;
import java.awt.FlowLayout;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class ConfigSelectionListener
implements TreeSelectionListener {
    private JTree itsTree;
    private ConfigFileGUI itsGUI;

    public ConfigSelectionListener(JTree tree, ConfigFileGUI gui) {
        this.itsTree = tree;
        this.itsGUI = gui;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.itsTree.getLastSelectedPathComponent();
        if (dmtn == null) {
            return;
        }
        if (dmtn.isRoot()) {
            if (this.itsGUI.handlingFocus) {
                return;
            }
            this.itsGUI.setTopPanel(true);
            FlowLayout fl = new FlowLayout(0);
            JPanel p = new JPanel(fl);
            HexTextArea jt = this.itsGUI.getHta();
            try {
                jt.setText(this.itsGUI.getConfigFile().writeToString(jt.isHex(), this.itsGUI.verboseDisplay()));
            }
            catch (Exception ex) {
                System.out.println("error writing to string!\n" + ex);
                jt.setText("error writing to string!\n" + ex);
            }
            p.add(jt);
            this.itsGUI.setCenterPanel(p);
            return;
        }
        this.itsGUI.setTopPanel(false);
        if (!(dmtn.getUserObject() instanceof TLV)) {
            String directoryName = dmtn.getUserObject().toString();
            int[] types = directoryName.equals(Messages.getString("ConfigFileGUI.textRequiredEncodings")) ? ConfigSelectionListener.addAllIntArrays(new int[][]{ConfigTreeModel.getTreeSubTypes().get(Messages.getString("ConfigFileGUI.textRequiredEncodings")), ConfigTreeModel.getTreeSubTypes().get(Messages.getString("ConfigFileGUI.textED10RequiredEncodings")), ConfigTreeModel.getTreeSubTypes().get(Messages.getString("ConfigFileGUI.textED11RequiredEncodings"))}) : (directoryName.equals(Messages.getString("ConfigFileGUI.textOptionalEncodings")) || directoryName.equals(Messages.getString("ConfigFileGUI.textUnknownEncodings")) ? ConfigSelectionListener.addAllIntArrays(new int[][]{ConfigTreeModel.getTreeSubTypes().get(Messages.getString("ConfigFileGUI.textED10Encodings")), ConfigTreeModel.getTreeSubTypes().get(Messages.getString("ConfigFileGUI.textED11Encodings")), ConfigTreeModel.getTreeSubTypes().get(Messages.getString("ConfigFileGUI.textED20Encodings")), ConfigTreeModel.getTreeSubTypes().get(Messages.getString("ConfigFileGUI.textED30Encodings")), ConfigTreeModel.getTreeSubTypes().get(Messages.getString("ConfigFileGUI.textED40Encodings"))}) : ConfigTreeModel.getTreeSubTypes().get(directoryName));
            ArrayList<ITLV> tlvs = this.itsGUI.getConfigFile().getTLVs(types);
            if (directoryName.equals(Messages.getString("ConfigFileGUI.textOtherEncodings"))) {
                tlvs.addAll(this.itsGUI.getConfigFile().getUnknownTLVs());
            }
            JPanel p = new JPanel();
            if (tlvs == null) {
                p.add(new JLabel("this is just a directory..."));
            } else {
                JTextArea jText = new JTextArea();
                p.add(jText);
                jText.setText(TLV.writeToString(tlvs, false, false));
                jText.setEditable(false);
            }
            this.itsGUI.setCenterPanel(p);
            return;
        }
        TLV tlv = (TLV)dmtn.getUserObject();
        this.itsGUI.setCenterPanel(tlv.showGUI(this.itsGUI));
        this.itsGUI.setHelpText(tlv.getTypeInfo() + " (" + tlv.getFullType() + "):\n" + TlvInfo.getString(tlv.getTypeInfo()));
        this.itsGUI.validate();
        this.itsGUI.setVisible(true);
        this.itsGUI.repaint();
    }

    public static int[] addAllIntArrays(int[][] intarray) {
        int totallength = 0;
        for (int i = 0; i < intarray.length; ++i) {
            totallength += intarray[i].length;
        }
        int[] totalarray = new int[totallength];
        int currentlength = 0;
        for (int i = 0; i < intarray.length; ++i) {
            System.arraycopy(intarray[i], 0, totalarray, currentlength, intarray[i].length);
            currentlength += intarray[i].length;
        }
        return totalarray;
    }
}

