/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.gui;

import com.excentis.security.configfile.ISubTypedTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.TlvInfo;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ConfigTreeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    ImageIcon dirIcon;
    ImageIcon subtypedTLVIcon;
    ImageIcon TLVIcon;
    ImageIcon rootIcon;

    public ConfigTreeRenderer() {
        try {
            this.dirIcon = new ImageIcon(this.getClass().getClassLoader().getResource("images/imageDir.gif"));
            this.subtypedTLVIcon = new ImageIcon(this.getClass().getClassLoader().getResource("images/imageSub.gif"));
            this.TLVIcon = new ImageIcon(this.getClass().getClassLoader().getResource("images/imageTlv.gif"));
            this.rootIcon = new ImageIcon(this.getClass().getClassLoader().getResource("images/imageRoot.gif"));
        }
        catch (Exception e) {
            this.dirIcon = new ImageIcon("images/imageDir.gif");
            this.subtypedTLVIcon = new ImageIcon("images/imageSub.gif");
            this.TLVIcon = new ImageIcon("images/imageTlv.gif");
            this.rootIcon = new ImageIcon("images/imageRoot.gif");
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (node.getUserObject() instanceof ISubTypedTLV) {
            this.setIcon(this.subtypedTLVIcon);
            this.setToolTipText(TlvInfo.formatValueHtml(((TLV)node.getUserObject()).getShowValue()));
        } else if (node.getUserObject() instanceof TLV) {
            this.setIcon(this.TLVIcon);
            this.setToolTipText(TlvInfo.formatValueHtml(((TLV)node.getUserObject()).getShowValue()));
        } else if (node.isRoot()) {
            this.setIcon(this.rootIcon);
            this.setToolTipText("");
        } else {
            this.setIcon(this.dirIcon);
            this.setToolTipText("");
        }
        return this;
    }
}

