/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.panels;

import com.excentis.security.configfile.TLV;
import com.excentis.security.tools.Binary2Plaintext;
import com.excentis.security.tools.Plaintext2Binary;
import com.excentis.security.utils.CertUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class BasicTLVPanel
extends JPanel {
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JTextArea jTextArea1 = new JTextArea();
    JLabel jLabel1 = new JLabel();
    JButton jButtonSelect = new JButton();
    JButton jButtonApply = new JButton();
    private TLV itsTLV = null;

    public BasicTLVPanel(TLV tlv) {
        this.itsTLV = tlv;
        byte[] data = tlv.getValue();
        Binary2Plaintext b2p = new Binary2Plaintext(data);
        this.jTextArea1.setText("" + b2p.getHexRepresentation());
        Dimension d = new Dimension();
        d.setSize(this.jTextArea1.getPreferredSize().width + 7, this.jTextArea1.getPreferredSize().height);
        this.jTextArea1.setPreferredSize(d);
        this.jTextArea1.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                JTextArea jt = (JTextArea)e.getSource();
                if (jt.getText().equals("")) {
                    jt.setPreferredSize(null);
                    Dimension d = new Dimension();
                    d.setSize(jt.getPreferredSize().width + 7, jt.getPreferredSize().height);
                    jt.setPreferredSize(d);
                } else {
                    jt.setPreferredSize(null);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.jTextArea1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("Select binary data file:");
        this.jLabel1.setBackground(Color.white);
        this.jButtonSelect.setText("Select");
        this.jButtonSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicTLVPanel.this.jButtonSelect_actionPerformed(e);
            }
        });
        this.jButtonApply.setText("Apply");
        this.jButtonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicTLVPanel.this.jButtonApply_actionPerformed(e);
            }
        });
        this.add((Component)this.jPanel1, "Center");
        this.jPanel1.setBackground(Color.white);
        this.jPanel1.add((Component)this.jTextArea1, null);
        this.jPanel1.add((Component)this.jButtonApply, null);
        this.add((Component)this.jPanel2, "South");
        this.jPanel2.setBackground(Color.white);
        this.jPanel2.add((Component)this.jLabel1, null);
        this.jPanel2.add((Component)this.jButtonSelect, null);
    }

    void jButtonSelect_actionPerformed(ActionEvent e) {
        try {
            int maxlen;
            JFileChooser jfc = new JFileChooser(".\\");
            jfc.showOpenDialog(this);
            File f = jfc.getSelectedFile();
            if (f == null) {
                return;
            }
            byte[] data = CertUtils.readFile(f);
            boolean twobytelength = TLV.isTwoByteLength(this.itsTLV.getFullType());
            int n = maxlen = twobytelength ? 65533 : 254;
            if (data.length > maxlen) {
                JOptionPane.showMessageDialog(this, "Maximum length is " + maxlen + " bytes!\n Your data is " + data.length + " long", "ERROR", 0);
                return;
            }
            this.itsTLV.setData(data);
            Binary2Plaintext b2p = new Binary2Plaintext(data);
            this.jTextArea1.setText("" + b2p.getHexRepresentation());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.toString(), "ERROR", 0);
        }
    }

    void jButtonApply_actionPerformed(ActionEvent e) {
        try {
            int maxlen;
            Plaintext2Binary p2b = new Plaintext2Binary(this.jTextArea1.getText());
            boolean twobytelength = TLV.isTwoByteLength(this.itsTLV.getFullType());
            int n = maxlen = twobytelength ? 65533 : 254;
            if (p2b.getBytes().length > maxlen) {
                JOptionPane.showMessageDialog(this, "Maximum length is " + maxlen + " bytes!\n Your data is " + p2b.getBytes().length + " long", "ERROR", 0);
                return;
            }
            this.itsTLV.setData(p2b.getBytes());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.toString(), "ERROR", 0);
        }
    }
}

