/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.panels;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.Messages;
import com.excentis.security.configfile.TLV;
import com.excentis.security.tools.Binary2Plaintext;
import com.excentis.security.utils.CertUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class CVCChainPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JTextArea jTextArea1 = new JTextArea();
    JLabel jLabel1 = new JLabel();
    JButton jButtonNew = new JButton();
    JButton jButtonAdd = new JButton();
    private int itsTLVtype;
    private ConfigFile itsConfigFile;

    public CVCChainPanel(TLV tlv, ConfigFile cfg) {
        this.itsTLVtype = tlv.getType();
        this.itsConfigFile = cfg;
        byte[] data = tlv.getValue();
        Binary2Plaintext b2p = new Binary2Plaintext(data);
        this.jTextArea1.setText(b2p.getHexRepresentation().substring(0, Math.min(b2p.getHexRepresentation().length(), 20)) + "...");
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("Select CVC file:");
        this.jLabel1.setBackground(Color.white);
        this.jButtonNew.setText("Replace");
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CVCChainPanel.this.jButtonNew_actionPerformed(e);
            }
        });
        this.jButtonAdd.setText("Append");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CVCChainPanel.this.jButtonAdd_actionPerformed(e);
            }
        });
        this.add((Component)this.jPanel2, null);
        this.jPanel2.setBackground(Color.white);
        this.jPanel2.add((Component)this.jLabel1, null);
        this.jPanel2.add((Component)this.jButtonNew, null);
        this.jPanel2.add((Component)this.jButtonAdd, null);
        this.add((Component)this.jPanel1, null);
        this.jPanel1.setBackground(Color.white);
        this.jPanel1.add((Component)this.jTextArea1, null);
    }

    void jButtonNew_actionPerformed(ActionEvent e) {
        this.addCVC(true);
    }

    void jButtonAdd_actionPerformed(ActionEvent e) {
        this.addCVC(false);
    }

    private void addCVC(boolean deleteold) {
        try {
            int selection;
            JFileChooser jfc = new JFileChooser(".\\");
            jfc.showOpenDialog(this);
            File f = jfc.getSelectedFile();
            if (f == null) {
                return;
            }
            byte[] data = CertUtils.readFile(f);
            if (data.length > 10000 && (selection = JOptionPane.showOptionDialog(this, Messages.getString("ConfigFileGUI.cvctoobig"), Messages.getString("ConfigFileGUI.cvctoobigtitle"), 0, 2, null, null, null)) == 1) {
                return;
            }
            if (deleteold) {
                this.itsConfigFile.deleteCVCs(this.itsTLVtype);
            }
            this.itsConfigFile.appendTLV(this.itsConfigFile.cutCVCIntoTLVPieces(data, this.itsTLVtype));
            Binary2Plaintext b2p = new Binary2Plaintext(data);
            this.jTextArea1.setText(b2p.getHexRepresentation().substring(0, Math.min(b2p.getHexRepresentation().length(), 20)) + "...");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.toString(), "ERROR", 0);
        }
    }
}

