/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.panels;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.ConfigFileGUI;
import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.ITLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.tlvs.TLV_DownstreamPacketClassifier;
import com.excentis.security.configfile.tlvs.TLV_DownstreamServiceFlow;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_ClassifierReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_ServiceFlowReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_Reference;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class DownstreamServiceFlowPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private TLV_DownstreamServiceFlow itsTLV = null;
    private ConfigFileGUI itsGUI = null;
    private JTextArea jText = new JTextArea();
    private JButton jButtonAdd = new JButton();
    private JPanel jPanelCenter = new JPanel();

    public DownstreamServiceFlowPanel(TLV_DownstreamServiceFlow tlv, ConfigFileGUI gui) {
        this.itsTLV = tlv;
        this.itsGUI = gui;
        this.setBackground(Color.white);
        this.jPanelCenter.setBackground(Color.white);
        this.jPanelCenter.setLayout(new BoxLayout(this.jPanelCenter, 1));
        this.add(this.jPanelCenter);
        this.jPanelCenter.add(this.jText);
        this.jButtonAdd.setText("Add Classifier");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownstreamServiceFlowPanel.this.jButtonAdd_actionPerformed(e);
            }
        });
        this.jPanelCenter.add(this.jButtonAdd);
        this.jPanelCenter.setAlignmentX(0.0f);
        this.jText.setText(this.itsTLV.getTypeInfo() + "\n\n" + TLV.writeToString(this.itsTLV.getSubTLVsAsTLVs(), false, false));
        this.jText.setEditable(false);
        JTextArea classifiers = new JTextArea();
        if (this.itsTLV.subTypePresent(1)) {
            SF_Reference sfdsr = (SF_Reference)this.itsTLV.getSubTypeTLVs(1).iterator().next();
            ArrayList<ITLV> ll = this.itsTLV.getConfigFile().getClassifiers(sfdsr.getReference());
            classifiers.setText("\n" + ll.size() + " classifier(s) present:\n\n");
            classifiers.setText(classifiers.getText() + TLV.writeToString(ll, false, false) + "\n");
        }
        this.jPanelCenter.add(classifiers);
    }

    void jButtonAdd_actionPerformed(ActionEvent e) {
        try {
            if (!this.itsTLV.subTypePresent(1)) {
                JOptionPane.showMessageDialog(this, "Service Flow Reference not present.  Cannot create classifier.");
                return;
            }
            ConfigFile cfg = this.itsTLV.getConfigFile();
            TLV_DownstreamPacketClassifier clas = new TLV_DownstreamPacketClassifier(new ArrayList<ISubTLV>(), cfg);
            CLAS_ClassifierReference clasref = new CLAS_ClassifierReference(clas, cfg.getFirstFreeClassifierRef());
            clas.addSubTLV(clasref);
            int ref = ((SF_Reference)this.itsTLV.getSubTypeTLVs(1).iterator().next()).getReference();
            CLAS_ServiceFlowReference classer = new CLAS_ServiceFlowReference(clas, ref);
            clas.addSubTLV(classer);
            cfg.appendTLV(clas);
            this.itsGUI.jButtonRefresh_actionPerformed(new ActionEvent(this, 0, "refresh"));
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.toString(), "ERROR", 0);
        }
    }
}

