/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.panels;

import com.excentis.security.configfile.ConfigFileGUI;
import com.excentis.security.configfile.Counter;
import com.excentis.security.configfile.Gauge;
import com.excentis.security.configfile.TimeTicks;
import com.excentis.security.configfile.tlvs.TLV_Mib;
import com.excentis.security.tools.Binary2Plaintext;
import com.excentis.security.tools.Plaintext2Binary;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.net.InetAddress;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.mozilla.jss.asn1.ASN1NULL;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;

public class MibPanel
extends JPanel {
    private TLV_Mib itsMib = null;
    private boolean string = true;
    private JLabel jLabelOID = new JLabel();
    private JLabel jLabelPredefinedOID = new JLabel();
    private JLabel jLabelInstance = new JLabel();
    private JLabel jLabelType = new JLabel();
    private JLabel jLabelValue = new JLabel();
    private JComboBox jComboBoxOID = new JComboBox();
    private JComboBox jComboBoxType = new JComboBox();
    private JTextField jTextFieldOID = new JTextField();
    private JTextField jTextFieldOIDText = new JTextField();
    private JTextField jTextFieldInstance = new JTextField();
    private JTextPane jTextFieldValue = new JTextPane();
    private JTextField jTextFieldType = new JTextField();
    private JButton jButtonApply = new JButton();
    private JCheckBox jCheckBoxHex = new JCheckBox();
    private JCheckBox jCheckBoxString = new JCheckBox();
    private ButtonGroup buttonGroupOctet = new ButtonGroup();

    public MibPanel(TLV_Mib mib) {
        try {
            this.itsMib = mib;
            this.jLabelOID.setText("OID:");
            this.jLabelOID.setBounds(new Rectangle(14, 7, 100, 17));
            this.jLabelPredefinedOID.setText("Known OIDs:");
            this.jLabelPredefinedOID.setBounds(new Rectangle(14, 56, 100, 17));
            this.jLabelInstance.setText("Instance:");
            this.jLabelInstance.setBounds(new Rectangle(14, 81, 100, 17));
            this.jLabelType.setText("Type:");
            this.jLabelType.setBounds(new Rectangle(14, 106, 100, 17));
            this.jLabelValue.setText("Value:");
            this.jLabelValue.setBounds(new Rectangle(14, 131, 100, 17));
            OBJECT_IDENTIFIER largestMatch = this.itsMib.getLargestMatch(this.itsMib.getOID());
            if (largestMatch == null) {
                this.jTextFieldOID.setText(this.itsMib.getOID().toStringWithoutLast());
                this.jTextFieldInstance.setText("" + this.itsMib.getOID().getNumbers()[this.itsMib.getOID().getNumbers().length - 1]);
            } else {
                this.jTextFieldOID.setText(largestMatch.toString());
                this.jTextFieldInstance.setText(OBJECT_IDENTIFIER.getDifference(largestMatch, this.itsMib.getOID()));
            }
            this.jTextFieldOID.setBounds(new Rectangle(90, 5, 250, 21));
            this.jTextFieldInstance.setBounds(new Rectangle(90, 80, 250, 21));
            this.jTextFieldValue.setText(this.itsMib.getValShowValue());
            this.jTextFieldValue.setBounds(new Rectangle(90, 130, 156, 21));
            this.jTextFieldValue.setBorder(BorderFactory.createEtchedBorder());
            this.jTextFieldType.setText(this.itsMib.getValTypeString());
            this.jTextFieldType.setEnabled(false);
            this.jTextFieldType.setBounds(new Rectangle(90, 105, 91, 21));
            this.jButtonApply.setText("Apply");
            this.jButtonApply.setBounds(new Rectangle(90, 162, 90, 27));
            this.jButtonApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MibPanel.this.jButtonApply_actionPerformed(e);
                }
            });
            this.jCheckBoxHex.setBackground(Color.white);
            this.jCheckBoxHex.setText("Hex");
            this.jCheckBoxHex.setBounds(new Rectangle(247, 129, 80, 25));
            this.jCheckBoxHex.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MibPanel.this.jCheckBoxHex_actionPerformed(e);
                }
            });
            this.jCheckBoxString.setBackground(Color.white);
            this.jCheckBoxString.setSelected(true);
            this.jCheckBoxString.setText("String");
            this.jCheckBoxString.setBounds(new Rectangle(310, 129, 80, 25));
            this.jCheckBoxString.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MibPanel.this.jCheckBoxString_actionPerformed(e);
                }
            });
            this.setBackground(Color.white);
            this.setLayout(null);
            this.jTextFieldOIDText.setBounds(new Rectangle(90, 30, 250, 21));
            this.jComboBoxOID.setBounds(new Rectangle(90, 56, 250, 21));
            Iterator<String> it = TLV_Mib.knownOIDStrings.iterator();
            while (it.hasNext()) {
                this.jComboBoxOID.addItem(it.next());
            }
            this.jComboBoxOID.setSelectedIndex(-1);
            this.jComboBoxOID.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MibPanel.this.jComboBoxOID_actionPerformed(e);
                }
            });
            this.jComboBoxType.setBounds(new Rectangle(194, 105, 119, 21));
            it = TLV_Mib.knownTypes.iterator();
            while (it.hasNext()) {
                this.jComboBoxType.addItem(it.next());
            }
            this.jComboBoxType.setSelectedIndex(-1);
            this.jComboBoxType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MibPanel.this.jComboBoxType_actionPerformed(e);
                }
            });
            this.add((Component)this.jLabelOID, null);
            this.buttonGroupOctet.add(this.jCheckBoxHex);
            this.buttonGroupOctet.add(this.jCheckBoxString);
            if (TLV_Mib.knownOIDs.contains(new OBJECT_IDENTIFIER(this.jTextFieldOID.getText()))) {
                int index = TLV_Mib.knownOIDs.indexOf(new OBJECT_IDENTIFIER(this.jTextFieldOID.getText()));
                this.jTextFieldOIDText.setText(TLV_Mib.knownOIDStrings.get(index));
            } else {
                this.jTextFieldOIDText.setText("OIDInTextForm");
            }
            this.add((Component)this.jTextFieldOID, null);
            this.add(this.jLabelPredefinedOID);
            this.add((Component)this.jComboBoxOID, null);
            this.add((Component)this.jLabelInstance, null);
            this.add((Component)this.jLabelType, null);
            this.add((Component)this.jComboBoxType, null);
            this.add((Component)this.jLabelValue, null);
            this.add((Component)this.jTextFieldValue, null);
            this.add((Component)this.jCheckBoxString, null);
            this.add((Component)this.jCheckBoxHex, null);
            this.add((Component)this.jTextFieldOIDText, null);
            this.add((Component)this.jTextFieldInstance, null);
            this.add((Component)this.jTextFieldType, null);
            this.add((Component)this.jButtonApply, null);
            this.setEnables();
            this.validate();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e, "ERROR", 0);
        }
    }

    private void setEnables() {
        if (!this.jTextFieldType.getText().equals("Octet String")) {
            this.jCheckBoxHex.setEnabled(false);
            this.jCheckBoxString.setEnabled(false);
        } else {
            String text = this.jTextFieldValue.getText();
            if (text.length() < 2 || !text.substring(0, 2).equals("0x")) {
                this.jCheckBoxHex.setSelected(false);
                this.jCheckBoxString.setSelected(true);
            } else {
                this.jCheckBoxHex.setSelected(true);
                this.jCheckBoxString.setSelected(false);
                this.string = false;
            }
            this.jCheckBoxHex.setEnabled(true);
            this.jCheckBoxString.setEnabled(true);
        }
        OBJECT_IDENTIFIER oid = new OBJECT_IDENTIFIER(this.jTextFieldOID.getText());
        if (TLV_Mib.knownOIDs.contains(oid)) {
            this.jComboBoxType.setEnabled(true);
            this.jTextFieldOIDText.setBackground(Color.white);
        } else {
            this.jTextFieldOIDText.setBackground(Color.CYAN);
            this.jComboBoxType.setEnabled(true);
        }
    }

    void jCheckBoxHex_actionPerformed(ActionEvent e) {
        if (!this.string) {
            return;
        }
        this.string = false;
        byte[] val = this.jTextFieldValue.getText().getBytes();
        Binary2Plaintext b2p = new Binary2Plaintext(val);
        this.jTextFieldValue.setText("0x" + b2p.getHexRepresentation());
    }

    void jCheckBoxString_actionPerformed(ActionEvent e) {
        if (this.string) {
            return;
        }
        String text = this.jTextFieldValue.getText();
        if (!text.substring(0, 2).equals("0x")) {
            System.out.println("substring: " + text.substring(0, 2));
            JOptionPane.showMessageDialog(this, "hex field must start with 0x", "ERROR", 0);
            this.jCheckBoxHex.setSelected(true);
            return;
        }
        this.string = true;
        String sub = text.substring(2, text.length());
        System.out.println("sub: " + sub);
        Plaintext2Binary p2b = new Plaintext2Binary(sub);
        this.jTextFieldValue.setText(new String(p2b.getBytes()));
    }

    void jComboBoxOID_actionPerformed(ActionEvent e) {
        try {
            String s = (String)this.jComboBoxOID.getSelectedItem();
            int i = TLV_Mib.knownOIDStrings.indexOf(s);
            System.out.println("index: " + i);
            this.jTextFieldOIDText.setText(s);
            this.jTextFieldOID.setText(TLV_Mib.knownOIDs.get(i).toString());
            this.jTextFieldType.setText(TLV_Mib.knownOIDTypes.get(i));
            this.setEnables();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex, "ERROR", 0);
        }
    }

    void jComboBoxType_actionPerformed(ActionEvent e) {
        try {
            String s = (String)this.jComboBoxType.getSelectedItem();
            this.jTextFieldType.setText(s);
            this.setEnables();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex, "ERROR", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jButtonApply_actionPerformed(ActionEvent e) {
        try {
            OBJECT_IDENTIFIER oid = new OBJECT_IDENTIFIER(this.jTextFieldOID.getText());
            OBJECT_IDENTIFIER fulloid = new OBJECT_IDENTIFIER(this.jTextFieldOID.getText() + "." + this.jTextFieldInstance.getText());
            if (!TLV_Mib.knownOIDs.contains(oid)) {
                String oidd = this.jTextFieldOID.getText();
                String oidtext = this.jTextFieldOIDText.getText();
                String type = this.jTextFieldType.getText();
                int yes = JOptionPane.showConfirmDialog(this, "OID not known yet.  Add\n{ " + oidtext + ", " + oidd + ", " + type + " }\n to database? ", "Database Update", 0, 1);
                if (yes == 0) {
                    String newLine = System.getProperty("line.separator");
                    String s = oidtext + "\t" + oidd + "\t" + type + newLine;
                    BufferedWriter buf = new BufferedWriter(new FileWriter(ConfigFileGUI.programDir + "/MIBS.INI", true));
                    try {
                        buf.write(s);
                    }
                    finally {
                        buf.close();
                    }
                    TLV_Mib.initializeKnownOIDs(ConfigFileGUI.programDir);
                    this.jComboBoxOID.addItem(oidtext);
                    this.setEnables();
                    this.validate();
                }
            }
            TLV_Mib newmib = null;
            String type = this.jTextFieldType.getText();
            if (type.equals("Integer")) {
                newmib = new TLV_Mib(fulloid, new INTEGER(Integer.parseInt(this.jTextFieldValue.getText())));
            } else if (type.equals("Octet String")) {
                String s = this.jTextFieldValue.getText();
                if (s.length() >= 2 && s.substring(0, 2).equals("0x")) {
                    Plaintext2Binary p2b = new Plaintext2Binary(s.substring(2, s.length()));
                    newmib = new TLV_Mib(fulloid, new OCTET_STRING(p2b.getBytes()));
                } else {
                    newmib = new TLV_Mib(fulloid, new OCTET_STRING(s.getBytes()));
                }
            } else if (type.equals("Null")) {
                newmib = new TLV_Mib(fulloid, new ASN1NULL());
            } else if (type.equals("Object Identifier")) {
                newmib = new TLV_Mib(fulloid, new OBJECT_IDENTIFIER(this.jTextFieldValue.getText()));
            } else if (type.equals("IP Address")) {
                newmib = new TLV_Mib(fulloid, InetAddress.getByName(this.jTextFieldValue.getText()));
            } else if (type.equals("Counter")) {
                newmib = new TLV_Mib(fulloid, new Counter(Long.parseLong(this.jTextFieldValue.getText())));
            } else if (type.equals("Gauge")) {
                newmib = new TLV_Mib(fulloid, new Gauge(Long.parseLong(this.jTextFieldValue.getText())));
            } else if (type.equals("Timeticks")) {
                newmib = new TLV_Mib(fulloid, new TimeTicks(Long.parseLong(this.jTextFieldValue.getText())));
            }
            if (newmib == null) {
                JOptionPane.showMessageDialog(this, "newmib is null", "ERROR", 0);
            } else {
                this.itsMib.updateFields(newmib.getValue());
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex, "ERROR", 0);
        }
    }
}

