/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.panels.basic;

import com.excentis.security.configfile.interfaces.IByteListTlv;
import com.excentis.security.utils.CertUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class ByteListPanel
extends JPanel {
    private IByteListTlv itsTLV = null;
    private JLabel jLabel = new JLabel();
    private JTextArea jTextArea = new JTextArea();
    private JButton jButtonApply = new JButton();

    public ByteListPanel(IByteListTlv tlv, String label) {
        this.itsTLV = tlv;
        this.jTextArea.setBorder(BorderFactory.createEtchedBorder());
        ArrayList<Byte> l = this.itsTLV.getBytes();
        Iterator<Byte> it = l.iterator();
        String text = "";
        while (it.hasNext()) {
            text = text + CertUtils.byteToString(it.next()) + "\n";
        }
        this.jTextArea.setText(text);
        Dimension d = new Dimension();
        d.setSize(this.jTextArea.getPreferredSize().width + 7, this.jTextArea.getPreferredSize().height);
        this.jTextArea.setPreferredSize(d);
        this.jTextArea.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                JTextArea jt = (JTextArea)e.getSource();
                if (jt.getText().equals("")) {
                    jt.setPreferredSize(null);
                    Dimension d = new Dimension();
                    d.setSize(jt.getPreferredSize().width + 7, jt.getPreferredSize().height);
                    jt.setPreferredSize(d);
                } else {
                    jt.setPreferredSize(null);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.add((Component)this.jLabel, null);
        this.add((Component)this.jTextArea, null);
        this.setBackground(Color.white);
        this.jLabel.setText(label);
        this.jButtonApply.setText("Apply");
        this.jButtonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ByteListPanel.this.jButtonApply_actionPerformed(e);
            }
        });
        this.add((Component)this.jButtonApply, null);
    }

    void jButtonApply_actionPerformed(ActionEvent e) {
        try {
            String[] strings = CertUtils.convertStringToStrings(this.jTextArea.getText());
            ArrayList<Byte> l = new ArrayList<Byte>();
            for (int i = 0; i < strings.length; ++i) {
                l.add(CertUtils.stringToByte(strings[i]));
            }
            this.itsTLV.setBytes(l);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.toString(), "ERROR", 0);
        }
    }
}

