/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.panels.basic;

import com.excentis.security.configfile.interfaces.IIpv6ListTlv;
import com.excentis.security.utils.CertUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class Ipv6AddressListPanel
extends JPanel {
    private IIpv6ListTlv itsTLV = null;
    private JLabel jLabelCPEIP = new JLabel();
    private JTextArea jTextArea1 = new JTextArea();
    private JButton jButtonApply = new JButton();

    public Ipv6AddressListPanel(IIpv6ListTlv tlv) {
        this.itsTLV = tlv;
        this.jTextArea1.setBorder(BorderFactory.createEtchedBorder());
        this.jTextArea1.setText("");
        ArrayList<Inet6Address> l = this.itsTLV.getAddresses();
        Iterator<Inet6Address> it = l.iterator();
        while (it.hasNext()) {
            this.jTextArea1.setText(this.jTextArea1.getText() + ((InetAddress)it.next()).getHostAddress() + "\n");
        }
        this.add((Component)this.jLabelCPEIP, null);
        this.add((Component)this.jTextArea1, null);
        this.jLabelCPEIP.setText("IPv6 addresses:");
        this.jButtonApply.setText("Apply");
        this.jButtonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Ipv6AddressListPanel.this.jButtonApply_actionPerformed(e);
            }
        });
        this.add((Component)this.jButtonApply, null);
    }

    void jButtonApply_actionPerformed(ActionEvent e) {
        try {
            String[] strings = CertUtils.convertStringToStrings(this.jTextArea1.getText());
            ArrayList<Inet6Address> l = new ArrayList<Inet6Address>();
            for (int i = 0; i < strings.length; ++i) {
                String address = strings[i];
                if (address.length() == 0) {
                    address = "::";
                }
                l.add((Inet6Address)InetAddress.getByName(address));
            }
            this.itsTLV.setAddresses(l);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.toString(), "ERROR", 0);
        }
    }
}

