/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.panels.basic;

import com.excentis.security.configfile.interfaces.IIPv6PrefixListTlv;
import com.excentis.security.configfile.tlvs.docsis30.basic.Inet6WithPrefix;
import com.excentis.security.utils.CertUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class Ipv6AddressPrefixListPanel
extends JPanel {
    private IIPv6PrefixListTlv itsTLV = null;
    private JLabel jLabelCPEIP = new JLabel();
    private JTextArea jTextArea1 = new JTextArea();
    private JButton jButtonApply = new JButton();

    public Ipv6AddressPrefixListPanel(IIPv6PrefixListTlv tlv) {
        this.itsTLV = tlv;
        this.jTextArea1.setBorder(BorderFactory.createEtchedBorder());
        this.jTextArea1.setText("");
        ArrayList<Inet6WithPrefix> l = this.itsTLV.getAddressPrefixes();
        Iterator<Inet6WithPrefix> it = l.iterator();
        while (it.hasNext()) {
            this.jTextArea1.setText(this.jTextArea1.getText() + it.next() + "\n");
        }
        this.add((Component)this.jLabelCPEIP, null);
        this.add((Component)this.jTextArea1, null);
        this.jLabelCPEIP.setText("IPv6 address/prefixes:");
        this.jButtonApply.setText("Apply");
        this.jButtonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Ipv6AddressPrefixListPanel.this.jButtonApply_actionPerformed(e);
            }
        });
        this.add((Component)this.jButtonApply, null);
    }

    void jButtonApply_actionPerformed(ActionEvent e) {
        try {
            String[] strings = CertUtils.convertStringToStrings(this.jTextArea1.getText());
            ArrayList<Inet6WithPrefix> l = new ArrayList<Inet6WithPrefix>();
            for (int i = 0; i < strings.length; ++i) {
                String[] addp = strings[i].split("/");
                if (addp.length != 2) continue;
                Inet6WithPrefix iwp = new Inet6WithPrefix(Integer.decode(addp[1]), (Inet6Address)InetAddress.getByName(addp[0]));
                l.add(iwp);
            }
            this.itsTLV.setAddressPrefixes(l);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.toString(), "ERROR", 0);
        }
    }
}

