/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.panels.sub2panels.docsis30;

import com.excentis.security.configfile.tlvs.tlvsub2types.docsis30.TransportAddress_Address;
import com.excentis.security.tools.Plaintext2Binary;
import com.excentis.security.utils.CertUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class TransportAddress_AddressPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextArea jTextArea1 = new JTextArea();
    private JButton jButtonApply = new JButton();
    private JLabel jLabel1 = new JLabel();
    private TransportAddress_Address itsTLV = null;

    public TransportAddress_AddressPanel(TransportAddress_Address tlv) {
        this.itsTLV = tlv;
        this.jTextArea1.setMinimumSize(new Dimension(30, 21));
        this.jTextArea1.setBorder(BorderFactory.createEtchedBorder());
        this.jTextArea1.setText(this.itsTLV.getAddress());
        this.jButtonApply.setText("Apply");
        this.jButtonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransportAddress_AddressPanel.this.jButtonApply_actionPerformed(e);
            }
        });
        this.jLabel1.setText("address/port:");
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.jTextArea1, null);
        this.add((Component)this.jButtonApply, null);
    }

    void jButtonApply_actionPerformed(ActionEvent e) {
        try {
            Pattern p = Pattern.compile("/");
            String[] parts = p.split(this.jTextArea1.getText(), 2);
            try {
                byte[] addr = Inet4Address.getByName(parts[0]).getAddress();
                int intport = new Integer(parts[1]);
                byte[] port = new byte[]{(byte)(intport / 256), (byte)(intport % 256)};
                this.itsTLV.setAddress(CertUtils.appendAt(addr, port));
            }
            catch (UnknownHostException e1) {
                try {
                    byte[] addr = Inet6Address.getByName(parts[0]).getAddress();
                    int intport = new Integer(parts[1]);
                    byte[] port = new byte[]{(byte)(intport / 256), (byte)(intport % 256)};
                    this.itsTLV.setAddress(CertUtils.appendAt(addr, port));
                }
                catch (UnknownHostException e2) {
                    Plaintext2Binary p2b = new Plaintext2Binary(this.jTextArea1.getText());
                    this.itsTLV.setAddress(p2b.getBytes());
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.toString(), "ERROR, usage: ipv4/port or ipv6/port or asciibytes", 0);
        }
    }
}

