/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.parser;

import com.excentis.security.configfile.Counter;
import com.excentis.security.configfile.Gauge;
import com.excentis.security.configfile.IPAddress;
import com.excentis.security.configfile.TimeTicks;
import com.excentis.security.configfile.tlvs.tlvsub1types.DIPLEXER_DownstreamLowerBandEdge;
import com.excentis.security.configfile.tlvs.tlvsub1types.DIPLEXER_DownstreamUpperBandEdge;
import com.excentis.security.configfile.tlvs.tlvsub1types.DIPLEXER_UpstreamUpperBandEdge;
import com.excentis.security.configfile.tlvs.tlvsub1types.DOCSIS_SYNC_CONFIG_PTPProfileConfiguration;
import com.excentis.security.configfile.tlvs.tlvsub1types.EROUTER_InitializationMode;
import com.excentis.security.configfile.tlvs.tlvsub1types.ESTB_IPModeControl;
import com.excentis.security.configfile.tlvs.tlvsub1types.Energy_FeatureControl;
import com.excentis.security.configfile.tlvs.tlvsub2types.AQM_Algorithm;
import com.excentis.security.tools.Plaintext2Binary;
import com.excentis.security.utils.CertUtils;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.regex.Pattern;
import org.mozilla.jss.asn1.ASN1NULL;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;

public final class ValueParser {
    public static final String type_boolean = "boolean";
    public static final String type_notboolean = "notboolean";
    public static final String type_int1 = "int1";
    public static final String type_int2 = "int2";
    public static final String type_int3 = "int3";
    public static final String type_int4 = "int4";
    public static final String type_long4 = "long4";
    public static final String type_traptype = "traptype";
    public static final String type_qosset = "qosset";
    public static final String type_string = "string";
    public static final String type_nonnulltermstring = "nonnulltermstring";
    public static final String type_shedtypes = "shedtypes";
    public static final String type_datarates = "datarates";
    public static final String type_plainbin = "plainbin";
    public static final String type_oid = "oid";
    public static final String type_andormask = "andormask";
    public static final String type_tos = "tos";
    public static final String type_tc = "tc";
    public static final String type_snmpwac = "snmpwac";
    public static final String type_subcontrol = "subcontrol";
    public static final String type_subtable = "subtable";
    public static final String type_subgroups = "subgroups";
    public static final String type_ethertype = "ethertype";
    public static final String type_ieeelowhigh = "ieeelowhigh";
    public static final String type_mac = "mac";
    public static final String type_timestamp = "timestamp";
    public static final String type_Timeticks = "Timeticks";
    public static final String type_macmask = "macmask";
    public static final String type_mib = "mib";
    public static final String type_Null = "Null";
    public static final String type_Object_Identifier = "Object Identifier";
    public static final String type_IP_Address = "IP Address";
    public static final String type_Counter = "Counter";
    public static final String type_Gauge = "Gauge";
    public static final String type_inetaddress = "inetaddress";
    public static final String type_inetaddress_with_typefield = "type_inetaddress_with_typefield";
    public static final String type_inet6address = "inet6address";
    public static final String type_inet6address_list = "inet6address_list";
    public static final String type_inet6addressprefix_list = "inet6addressprefix_list";
    public static final String type_byte_list = "byte_list";
    public static final String type_vendor_data = "vendor_data";
    public static final String type_ipport_or_hex = "ipport_or_hex";
    public static final String type_ipprefix = "ipprefix";
    public static final String type_readwrite = "readwrite";
    public static final String type_included_excluded = "included_excluded";
    public static final String type_nothing = "nothing";
    public static final String type_erouterinitmode = "erouterinitmode";
    public static final String type_estbipmode = "estbipmode";
    public static final String type_diplexer = "diplexer";
    public static final String type_energyfeature = "energyfeature";
    public static final String type_aqmalgorithm = "aqm_algorithm";
    public static final String type_ptp_profile = "ptp_profile";
    public static final String type_ptp_enable = "ptp_enable";
    public static final String type_synce_enable = "synce_enable";
    public static final String type_ptp_max_nr_clock_slaves = "ptp_max_number_of_clock_slaves";

    public static byte[] getValueFromString(String type, String textValue) throws Exception {
        if (type == null || type.equals("")) {
            throw new Exception("Unable to parse text (" + textValue + "), type of text is not defined.");
        }
        Hashtable<String, Integer> sht = new Hashtable<String, Integer>();
        sht.put("Undefined", new Integer(1));
        sht.put("Best Effort", new Integer(2));
        sht.put("Non-Real-Time Polling Service", new Integer(3));
        sht.put("Real-Time Polling Service", new Integer(4));
        sht.put("Unsolicited Grant Service with Activity Detection", new Integer(5));
        sht.put("Unsolicited Grant Service", new Integer(6));
        sht.put("Proactive Grant Service", new Integer(7));
        Hashtable<String, Integer> dts = new Hashtable<String, Integer>();
        dts.put("bps", new Integer(0));
        dts.put("kbps", new Integer(1));
        dts.put("Mbps", new Integer(2));
        dts.put("Gbps", new Integer(3));
        if (type.equals(type_boolean)) {
            byte[] byArray;
            if (textValue.equalsIgnoreCase("on") || textValue.equalsIgnoreCase("True") || textValue.equalsIgnoreCase("HQoS enabled") || textValue.equalsIgnoreCase("Enabled") || textValue.equalsIgnoreCase("Enable") || textValue.equalsIgnoreCase("Two-way") || textValue.equalsIgnoreCase("SC-QAM") || textValue.equalsIgnoreCase("Remove") || textValue.equals("1")) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 1;
            } else {
                byte[] byArray3 = new byte[1];
                byArray = byArray3;
                byArray3[0] = 0;
            }
            return byArray;
        }
        if (type.equals(type_notboolean)) {
            byte[] byArray;
            if (textValue.equalsIgnoreCase("on") || textValue.equalsIgnoreCase("True") || textValue.equalsIgnoreCase("LLD Enabled") || textValue.equalsIgnoreCase("PGS AD Enabled") || textValue.equalsIgnoreCase("Enabled") || textValue.equalsIgnoreCase("Enable") || textValue.equalsIgnoreCase("Remove") || textValue.equals("1")) {
                byte[] byArray4 = new byte[1];
                byArray = byArray4;
                byArray4[0] = 0;
            } else {
                byte[] byArray5 = new byte[1];
                byArray = byArray5;
                byArray5[0] = 1;
            }
            return byArray;
        }
        if (type.equals(type_nothing)) {
            return new byte[0];
        }
        if (type.equals(type_int3)) {
            Integer inte = new Integer(textValue);
            byte[] result = new byte[3];
            long temp = inte.longValue();
            result[2] = (byte)(temp % 256L);
            result[1] = (byte)((temp /= 256L) % 256L);
            result[0] = (byte)((temp /= 256L) % 256L);
            return result;
        }
        if (type.equals(type_int4)) {
            Integer inte = new Integer(textValue);
            byte[] result = new byte[4];
            long temp = inte.longValue();
            result[3] = (byte)(temp % 256L);
            result[2] = (byte)((temp /= 256L) % 256L);
            result[1] = (byte)((temp /= 256L) % 256L);
            result[0] = (byte)((temp /= 256L) % 256L);
            return result;
        }
        if (type.equals(type_long4)) {
            Long l = new Long(textValue);
            if (l > 0xFFFFFFFFL) {
                throw new Exception("value " + l + " is larger than maximum allowed value in 4 bytes (\u202d4294967295\u202c)");
            }
            byte[] result = new byte[4];
            long temp = l;
            result[3] = (byte)(temp % 256L);
            result[2] = (byte)((temp /= 256L) % 256L);
            result[1] = (byte)((temp /= 256L) % 256L);
            result[0] = (byte)((temp /= 256L) % 256L);
            return result;
        }
        if (type.equals(type_traptype)) {
            int val = 0;
            if (textValue.equals("SNMP v1 trap in an SNMP v1 packet")) {
                val = 1;
            }
            if (textValue.equals("SNMP v2c trap in an SNMP v2c packet")) {
                val = 2;
            }
            if (textValue.equals("SNMP inform in an SNMP v2c packet")) {
                val = 3;
            }
            if (textValue.equals("SNMP v2c trap in an SNMP v3 packet")) {
                val = 4;
            }
            if (textValue.equals("SNMP inform in an SNMP v3 packet")) {
                val = 5;
            }
            byte[] bval = new byte[]{(byte)(val / 256), (byte)(val % 256)};
            return bval;
        }
        if (type.equals(type_int2)) {
            byte[] val = new byte[2];
            Integer inte = new Integer(textValue);
            val[0] = (byte)(inte / 256);
            val[1] = (byte)(inte % 256);
            return val;
        }
        if (type.equals(type_qosset)) {
            boolean pro;
            boolean adm = textValue.indexOf("admitted") != -1;
            boolean act = textValue.indexOf("active") != -1;
            boolean bl = pro = textValue.indexOf("provisioned") != -1;
            if (pro) {
                if (adm) {
                    if (act) {
                        return new byte[]{7};
                    }
                    return new byte[]{3};
                }
                if (act) {
                    return new byte[]{5};
                }
                return new byte[]{1};
            }
            if (adm) {
                if (act) {
                    return new byte[]{6};
                }
                return new byte[]{2};
            }
            if (act) {
                return new byte[]{4};
            }
            return new byte[]{0};
        }
        if (type.equals(type_string)) {
            return CertUtils.appendAt(textValue.getBytes(), new byte[]{0});
        }
        if (type.equals(type_readwrite)) {
            if (textValue.equalsIgnoreCase("read-write") || textValue.equals("2") || textValue.equals("0x02")) {
                return new byte[]{2};
            }
            return new byte[]{1};
        }
        if (type.equals(type_included_excluded)) {
            if (textValue.equalsIgnoreCase("included") || textValue.equalsIgnoreCase("DTP Slave Mode") || textValue.equalsIgnoreCase("1")) {
                return new byte[]{1};
            }
            return new byte[]{2};
        }
        if (type.equals(type_nonnulltermstring)) {
            return textValue.getBytes();
        }
        if (type.equals(type_int1)) {
            return new byte[]{new Integer(textValue).byteValue()};
        }
        if (type.equals(type_shedtypes)) {
            return new byte[]{((Integer)sht.get(textValue)).byteValue()};
        }
        if (type.equals(type_datarates)) {
            return new byte[]{((Integer)dts.get(textValue)).byteValue()};
        }
        if (type.equals(type_plainbin)) {
            return new Plaintext2Binary(textValue).getBytes();
        }
        if (type.equals(type_oid)) {
            return new OBJECT_IDENTIFIER(textValue).getEncoded();
        }
        if (type.equals(type_andormask)) {
            byte[] andor = new byte[]{new Plaintext2Binary(textValue.substring(11, 13)).getBytes()[0], new Plaintext2Binary(textValue.substring(24, 26)).getBytes()[0]};
            return andor;
        }
        if (type.equals(type_tos)) {
            byte[] tos = new byte[]{new Plaintext2Binary(textValue.substring(10, 12)).getBytes()[0], new Plaintext2Binary(textValue.substring(24, 26)).getBytes()[0], new Plaintext2Binary(textValue.substring(38, 40)).getBytes()[0]};
            return tos;
        }
        if (type.equals(type_tc)) {
            byte[] tc = new byte[]{new Plaintext2Binary(textValue.substring(9, 11)).getBytes()[0], new Plaintext2Binary(textValue.substring(22, 24)).getBytes()[0], new Plaintext2Binary(textValue.substring(35, 37)).getBytes()[0]};
            return tc;
        }
        if (type.equals(type_inetaddress)) {
            return InetAddress.getByName(textValue).getAddress();
        }
        if (type.equals(type_inetaddress_with_typefield)) {
            try {
                byte[] addr = Inet4Address.getByName(textValue).getAddress();
                byte[] atype = new byte[]{1};
                return CertUtils.appendAt(atype, addr);
            }
            catch (UnknownHostException e1) {
                try {
                    byte[] addr = Inet6Address.getByName(textValue).getAddress();
                    byte[] atype = new byte[]{2};
                    return CertUtils.appendAt(atype, addr);
                }
                catch (UnknownHostException e2) {
                    Plaintext2Binary p2b = new Plaintext2Binary(textValue);
                    return p2b.getBytes();
                }
            }
        }
        if (type.equals(type_inet6address)) {
            return Inet6Address.getByName(textValue).getAddress();
        }
        if (type.equals(type_ipport_or_hex)) {
            Pattern p = Pattern.compile("/|-");
            String[] parts = p.split(textValue, 2);
            try {
                byte[] addr = Inet4Address.getByName(parts[0]).getAddress();
                int intport = 0;
                if (parts.length == 2) {
                    intport = new Integer(parts[1]);
                }
                byte[] port = new byte[]{(byte)(intport / 256), (byte)(intport % 256)};
                return CertUtils.appendAt(addr, port);
            }
            catch (UnknownHostException e1) {
                try {
                    byte[] addr = Inet6Address.getByName(parts[0]).getAddress();
                    int intport = new Integer(parts[1]);
                    byte[] port = new byte[]{(byte)(intport / 256), (byte)(intport % 256)};
                    return CertUtils.appendAt(addr, port);
                }
                catch (UnknownHostException e2) {
                    Plaintext2Binary p2b = new Plaintext2Binary(textValue);
                    return p2b.getBytes();
                }
            }
            catch (Exception e) {
                System.out.println("error trying to decode IPv4 or IPv6 address/port : " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            int max_slaves;
            if (type.equals(type_ipprefix)) {
                int intpref;
                byte[] addr;
                Pattern p = Pattern.compile("/|-");
                String[] parts = p.split(textValue, 2);
                try {
                    addr = Inet4Address.getByName(parts[0]).getAddress();
                    intpref = new Integer(parts[1]);
                }
                catch (UnknownHostException e1) {
                    try {
                        addr = Inet6Address.getByName(parts[0]).getAddress();
                        intpref = new Integer(parts[1]);
                    }
                    catch (UnknownHostException e2) {
                        Plaintext2Binary p2b = new Plaintext2Binary(textValue);
                        return p2b.getBytes();
                    }
                }
                byte[] addrbytes = new byte[addr.length + 2];
                addrbytes[0] = 1;
                addrbytes[1] = (byte)addr.length;
                for (int i = 0; i < addr.length; ++i) {
                    addrbytes[i + 2] = addr[i];
                }
                byte[] prefbytes = new byte[]{2, 1, (byte)intpref};
                return CertUtils.appendAt(addrbytes, prefbytes);
            }
            if (type.equals(type_byte_list)) {
                String[] byt = textValue.split(" ");
                byte[] bytes = null;
                for (int i = 0; i < byt.length; ++i) {
                    int b = Integer.valueOf(byt[i]);
                    bytes = CertUtils.appendAt(bytes, (byte)b);
                }
                return bytes;
            }
            if (type.equals(type_inet6address_list)) {
                String[] ipv6 = textValue.split(" ");
                byte[] ipv6Addresses = null;
                for (int i = 0; i < ipv6.length; ++i) {
                    ipv6Addresses = CertUtils.appendAt(ipv6Addresses, Inet6Address.getByName(ipv6[i]).getAddress());
                }
                return ipv6Addresses;
            }
            if (type.equals(type_inet6addressprefix_list)) {
                String[] ipv6prefix = textValue.split(" ");
                byte[] ipv6Addressprefixes = null;
                for (int i = 0; i < ipv6prefix.length; ++i) {
                    String[] addp = ipv6prefix[i].split("/");
                    if (addp.length != 2) continue;
                    ipv6Addressprefixes = CertUtils.appendAt(ipv6Addressprefixes, ((Inet6Address)InetAddress.getByName(addp[0])).getAddress());
                    ipv6Addressprefixes = CertUtils.appendAt(ipv6Addressprefixes, Integer.decode(addp[1]).byteValue());
                }
                return ipv6Addressprefixes;
            }
            if (type.equals(type_snmpwac)) {
                byte[] byArray;
                String oid = textValue.substring(0, textValue.indexOf(32));
                if (textValue.charAt(textValue.indexOf(32) + 8) == 'd') {
                    byte[] byArray6 = new byte[1];
                    byArray = byArray6;
                    byArray6[0] = 1;
                } else {
                    byte[] byArray7 = new byte[1];
                    byArray = byArray7;
                    byArray7[0] = 0;
                }
                byte[] allowed = byArray;
                return CertUtils.appendAt(new OBJECT_IDENTIFIER(oid).getEncoded(), allowed);
            }
            if (type.equals(type_subcontrol)) {
                int spa = textValue.indexOf(32);
                Integer inte = new Integer(textValue.substring(0, spa));
                String actlearn = textValue.substring(textValue.indexOf(44) + 2, textValue.length());
                boolean act = actlearn.charAt(0) != 'i';
                String learns = actlearn.substring(actlearn.indexOf(32) + 1, actlearn.length());
                boolean learn = learns.charAt(0) != 'n';
                byte[] val = new byte[3];
                val[0] = (byte)(inte / 256);
                val[1] = (byte)(inte % 256);
                val[2] = learn ? (act ? 3 : 2) : (act ? 1 : 0);
                return val;
            }
            if (type.equals(type_subtable)) {
                byte[] result = null;
                String remainingstring = textValue;
                int firstspace = remainingstring.indexOf(32);
                if (firstspace == -1) {
                    String address = remainingstring;
                    result = CertUtils.appendAt(result, InetAddress.getByName(address).getAddress());
                } else {
                    String address = remainingstring.substring(0, firstspace);
                    remainingstring = remainingstring.substring(firstspace + 1, remainingstring.length());
                    boolean moreAddresses = true;
                    if (address.length() < 2) {
                        moreAddresses = false;
                    }
                    while (moreAddresses) {
                        result = CertUtils.appendAt(result, InetAddress.getByName(address).getAddress());
                        firstspace = remainingstring.indexOf(32);
                        address = firstspace == -1 ? "" : remainingstring.substring(0, firstspace);
                        remainingstring = remainingstring.substring(firstspace + 1, remainingstring.length());
                        if (address.length() >= 2) continue;
                        moreAddresses = false;
                    }
                }
                return result;
            }
            if (type.equals(type_subgroups)) {
                String aa = textValue.substring(textValue.indexOf(32) + 1, textValue.indexOf(44));
                int a = new Integer(aa);
                textValue = textValue.substring(textValue.indexOf(44) + 2, textValue.length());
                int b = new Integer(textValue.substring(textValue.indexOf(32) + 1, textValue.indexOf(44)));
                textValue = textValue.substring(textValue.indexOf(44) + 2, textValue.length());
                int c = new Integer(textValue.substring(textValue.indexOf(32) + 1, textValue.indexOf(44)));
                if ((textValue = textValue.substring(textValue.indexOf(44) + 2, textValue.length())).indexOf("PSupstream") == -1) {
                    int d = new Integer(textValue.substring(textValue.indexOf(32) + 1, textValue.length()));
                    byte[] result = new byte[]{(byte)(d / 256), (byte)(d % 256), (byte)(c / 256), (byte)(c % 256), (byte)(b / 256), (byte)(b % 256), (byte)(a / 256), (byte)(a % 256)};
                    return result;
                }
                int d = new Integer(textValue.substring(textValue.indexOf(32) + 1, textValue.indexOf(44)));
                textValue = textValue.substring(textValue.indexOf(44) + 2, textValue.length());
                int e = new Integer(textValue.substring(textValue.indexOf(32) + 1, textValue.indexOf(44)));
                textValue = textValue.substring(textValue.indexOf(44) + 2, textValue.length());
                int f = new Integer(textValue.substring(textValue.indexOf(32) + 1, textValue.indexOf(44)));
                textValue = textValue.substring(textValue.indexOf(44) + 2, textValue.length());
                int g = new Integer(textValue.substring(textValue.indexOf(32) + 1, textValue.indexOf(44)));
                textValue = textValue.substring(textValue.indexOf(44) + 2, textValue.length());
                int h = new Integer(textValue.substring(textValue.indexOf(32) + 1, textValue.indexOf(44)));
                textValue = textValue.substring(textValue.indexOf(44) + 2, textValue.length());
                int i = new Integer(textValue.substring(textValue.indexOf(32) + 1, textValue.indexOf(44)));
                textValue = textValue.substring(textValue.indexOf(44) + 2, textValue.length());
                int j = new Integer(textValue.substring(textValue.indexOf(32) + 1, textValue.length()));
                byte[] result = new byte[]{(byte)(d / 256), (byte)(d % 256), (byte)(c / 256), (byte)(c % 256), (byte)(b / 256), (byte)(b % 256), (byte)(a / 256), (byte)(a % 256), (byte)(f / 256), (byte)(f % 256), (byte)(e / 256), (byte)(e % 256), (byte)(h / 256), (byte)(h % 256), (byte)(g / 256), (byte)(g % 256), (byte)(j / 256), (byte)(j % 256), (byte)(i / 256), (byte)(i % 256)};
                return result;
            }
            if (type.equals(type_ethertype)) {
                byte[] eth = new byte[]{new Plaintext2Binary(textValue.substring(7, 9)).getBytes()[0], new Plaintext2Binary(textValue.substring(19, 21)).getBytes()[0], new Plaintext2Binary(textValue.substring(31, 33)).getBytes()[0]};
                return eth;
            }
            if (type.equals(type_ieeelowhigh)) {
                String sub = textValue.substring(4, textValue.length());
                int space = sub.indexOf(32);
                String subone = sub.substring(0, space);
                String subtwo = sub.substring(space + 6, sub.length());
                return new byte[]{new Integer(subone).byteValue(), new Integer(subtwo).byteValue()};
            }
            if (type.equals(type_mac)) {
                String sub = textValue;
                if (textValue.substring(0, 3).equals("MAC")) {
                    sub = textValue.substring(4, textValue.length());
                }
                sub = ValueParser.filterMACAddress(sub);
                ValueParser.checkMACConstraints(sub);
                return new Plaintext2Binary(sub).getBytes();
            }
            if (type.equals(type_timestamp)) {
                textValue = textValue.substring(textValue.indexOf(32) + 1, textValue.length());
                int year = new Integer(textValue.substring(0, textValue.indexOf(32)));
                textValue = textValue.substring(textValue.indexOf(32) + 1, textValue.length());
                textValue = textValue.substring(textValue.indexOf(32) + 1, textValue.length());
                int month = new Integer(textValue.substring(0, textValue.indexOf(32)));
                textValue = textValue.substring(textValue.indexOf(32) + 1, textValue.length());
                textValue = textValue.substring(textValue.indexOf(32) + 1, textValue.length());
                int day = new Integer(textValue.substring(0, textValue.indexOf(32)));
                textValue = textValue.substring(textValue.indexOf(32) + 1, textValue.length());
                textValue = textValue.substring(textValue.indexOf(32) + 1, textValue.length());
                int hour = new Integer(textValue.substring(0, textValue.indexOf(32)));
                textValue = textValue.substring(textValue.indexOf(32) + 1, textValue.length());
                textValue = textValue.substring(textValue.indexOf(32) + 1, textValue.length());
                int minute = new Integer(textValue.substring(0, textValue.indexOf(32)));
                textValue = textValue.substring(textValue.indexOf(32) + 1, textValue.length());
                textValue = textValue.substring(textValue.indexOf(32) + 1, textValue.length());
                int second = new Integer(textValue);
                GregorianCalendar d = new GregorianCalendar(year, month - 1, day, hour, minute, second);
                int jaar = d.get(1);
                long seconds = 0L;
                if (jaar < 1900) {
                    return new byte[4];
                }
                for (int i = 1900; i < jaar; ++i) {
                    if (d.isLeapYear(i)) {
                        seconds += 31622400L;
                        continue;
                    }
                    seconds += 31536000L;
                }
                seconds += (long)((d.get(6) - 1) * 24 * 3600);
                seconds += (long)(d.get(11) * 3600);
                seconds += (long)(d.get(12) * 60);
                byte[] result = new byte[4];
                long temp = seconds += (long)d.get(13);
                result[3] = (byte)(temp % 256L);
                result[2] = (byte)((temp /= 256L) % 256L);
                result[1] = (byte)((temp /= 256L) % 256L);
                result[0] = (byte)((temp /= 256L) % 256L);
                return result;
            }
            if (type.equals(type_macmask)) {
                String sub1 = textValue.substring(4, 16);
                String sub2 = textValue.substring(22, 34);
                return CertUtils.appendAt(new Plaintext2Binary(sub1).getBytes(), new Plaintext2Binary(sub2).getBytes());
            }
            if (type.equals(type_mib)) {
                if (textValue.charAt(0) == '(') {
                    textValue = textValue.substring(textValue.indexOf(41) + 1, textValue.length());
                }
                OBJECT_IDENTIFIER oid = new OBJECT_IDENTIFIER(textValue.substring(0, textValue.indexOf(44)));
                textValue = textValue.substring(textValue.indexOf(44) + 2, textValue.length());
                String mibtype = textValue.substring(0, textValue.indexOf(44));
                textValue = textValue.length() < textValue.indexOf(44) + 2 ? " " : textValue.substring(textValue.indexOf(44) + 2, textValue.length());
                String val = textValue.substring(textValue.indexOf(32) + 1, textValue.length());
                byte[] byteval = null;
                if (mibtype.equals("Integer")) {
                    byteval = new INTEGER(Integer.parseInt(val)).getEncoded();
                } else if (mibtype.equals("Octet String")) {
                    if (val.length() >= 2 && val.substring(0, 2).equals("0x")) {
                        Plaintext2Binary p2b = new Plaintext2Binary(val.substring(2, val.length()));
                        byteval = new OCTET_STRING(p2b.getBytes()).getEncoded();
                    } else {
                        byteval = new OCTET_STRING(val.getBytes()).getEncoded();
                    }
                } else if (mibtype.equals(type_Null)) {
                    byteval = new ASN1NULL().getEncoded();
                } else if (mibtype.equals(type_Object_Identifier)) {
                    byteval = new OBJECT_IDENTIFIER(val).getEncoded();
                } else if (mibtype.equals(type_IP_Address)) {
                    byteval = new IPAddress(InetAddress.getByName(val)).getEncoded();
                } else if (mibtype.equals(type_Counter)) {
                    byteval = new Counter(Long.parseLong(val)).getEncoded();
                } else if (mibtype.equals(type_Gauge)) {
                    byteval = new Gauge(Long.parseLong(val)).getEncoded();
                } else if (mibtype.equals(type_Timeticks)) {
                    byteval = new TimeTicks(Long.parseLong(val)).getEncoded();
                } else {
                    throw new Exception("unknown MIB type: " + mibtype);
                }
                byte[] totalvalue = CertUtils.appendAt(oid.getEncoded(), byteval);
                return CertUtils.encode(totalvalue, 48);
            }
            if (type.equals(type_vendor_data)) {
                if (!textValue.contains("/")) {
                    throw new Exception("error while parsing vendor specific TLV: expecting vendorid/data, got " + textValue);
                }
                String[] parts = textValue.trim().split("/");
                String vendor = parts[0];
                if (vendor.length() != 6) {
                    throw new Exception("error while parsing vendor specific TLV: vendor id needs to be 3 bytes long (6 hex chars), got " + vendor);
                }
                String data = parts.length > 1 ? parts[1] : "";
                byte[] vendorid = CertUtils.appendAt(new byte[]{8, 3}, new Plaintext2Binary(vendor).getBytes());
                return CertUtils.appendAt(vendorid, new Plaintext2Binary(data).getBytes());
            }
            if (type.equals(type_erouterinitmode)) {
                for (int i = 0; i < EROUTER_InitializationMode.displayMode.length; ++i) {
                    if (!textValue.equals(EROUTER_InitializationMode.displayMode[i])) continue;
                    return new byte[]{(byte)i};
                }
                return new byte[]{new Integer(textValue).byteValue()};
            }
            if (type.equals(type_estbipmode)) {
                for (int i = 0; i < ESTB_IPModeControl.displayMode.length; ++i) {
                    if (!textValue.equals(ESTB_IPModeControl.displayMode[i])) continue;
                    return new byte[]{(byte)i};
                }
                return new byte[]{new Integer(textValue).byteValue()};
            }
            if (type.equals(type_diplexer)) {
                int i;
                for (i = 0; i < DIPLEXER_UpstreamUpperBandEdge.upstreamUpperBandEdges.length; ++i) {
                    if (!textValue.equalsIgnoreCase(DIPLEXER_UpstreamUpperBandEdge.upstreamUpperBandEdges[i])) continue;
                    return new byte[]{(byte)i};
                }
                for (i = 0; i < DIPLEXER_DownstreamLowerBandEdge.downstreamLowerBandEdges.length; ++i) {
                    if (!textValue.equalsIgnoreCase(DIPLEXER_DownstreamLowerBandEdge.downstreamLowerBandEdges[i])) continue;
                    return new byte[]{(byte)i};
                }
                for (i = 0; i < DIPLEXER_DownstreamUpperBandEdge.downstreamUpperBandEdges.length; ++i) {
                    if (!textValue.equalsIgnoreCase(DIPLEXER_DownstreamUpperBandEdge.downstreamUpperBandEdges[i])) continue;
                    return new byte[]{(byte)i};
                }
                return new byte[]{new Integer(textValue).byteValue()};
            }
            if (type.equals(type_aqmalgorithm)) {
                for (int i = 0; i < AQM_Algorithm.aqms.length; ++i) {
                    if (!textValue.equalsIgnoreCase(AQM_Algorithm.aqms[i])) continue;
                    return new byte[]{(byte)i};
                }
                return new byte[]{new Integer(textValue).byteValue()};
            }
            if (type.equals(type_energyfeature)) {
                for (int i = 0; i < Energy_FeatureControl.feature.length; ++i) {
                    if (!textValue.equalsIgnoreCase(Energy_FeatureControl.feature[i])) continue;
                    return new byte[]{(byte)i};
                }
                if (textValue.equalsIgnoreCase("enabled")) {
                    return new byte[]{1};
                }
                return new byte[]{new Integer(textValue).byteValue()};
            }
            if (type.equals(type_ptp_enable)) {
                byte[] byArray;
                if (textValue.equalsIgnoreCase("ptp enabled") || textValue.equalsIgnoreCase("enabled") || textValue.equals("1")) {
                    byte[] byArray8 = new byte[1];
                    byArray = byArray8;
                    byArray8[0] = 1;
                } else {
                    byte[] byArray9 = new byte[1];
                    byArray = byArray9;
                    byArray9[0] = 16;
                }
                return byArray;
            }
            if (type.equals(type_synce_enable)) {
                byte[] byArray;
                if (textValue.equalsIgnoreCase("SyncE enabled") || textValue.equalsIgnoreCase("enabled") || textValue.equals("1")) {
                    byte[] byArray10 = new byte[1];
                    byArray = byArray10;
                    byArray10[0] = 1;
                } else {
                    byte[] byArray11 = new byte[1];
                    byArray = byArray11;
                    byArray11[0] = 16;
                }
                return byArray;
            }
            if (type.equals(type_ptp_profile)) {
                for (int i = 0; i < DOCSIS_SYNC_CONFIG_PTPProfileConfiguration.profileConfigurations.length; ++i) {
                    if (!textValue.equalsIgnoreCase(DOCSIS_SYNC_CONFIG_PTPProfileConfiguration.profileConfigurations[i])) continue;
                    return new byte[]{(byte)i};
                }
            } else if (type.equals(type_ptp_max_nr_clock_slaves) && 0 <= (max_slaves = Integer.parseInt(textValue)) && max_slaves <= 255) {
                return new byte[]{(byte)max_slaves};
            }
        }
        throw new Exception("unknown type: " + type);
    }

    public static void checkMACConstraints(String addr) throws Exception {
        if (addr.length() != 12) {
            throw new Exception("Mac address should contain exactly 12 characters (6 bytes).");
        }
        for (int i = 0; i < addr.length(); ++i) {
            if ('0' <= addr.charAt(i) && addr.charAt(i) <= '9' || 'A' <= addr.charAt(i) && addr.charAt(i) <= 'F' || 'a' <= addr.charAt(i) && addr.charAt(i) <= 'f') continue;
            throw new Exception("Invalid hexadecimal character detected.");
        }
    }

    public static String filterMACAddress(String addr) {
        return addr.replace(" ", "").replace(".", "").replace(":", "");
    }

    public static String filterIPv4OrIPv6Address(String addr) {
        return addr.replace(" ", "").replace(".", "").replace(":", "");
    }

    public static void checkIPv4OrIPv6Constraints(String ip_and_prefix) throws Exception {
        Pattern p = Pattern.compile("/|-");
        String[] parts = p.split(ip_and_prefix, 2);
        int prefix = new Integer(parts[1]);
        if (prefix < 0 || prefix > 128) {
            throw new Exception("prefix must be between 0 and 128, use ipv4/prefix or ipv6/prefix");
        }
    }
}

