/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub1types.BP_AuthGraceTime;
import com.excentis.security.configfile.tlvs.tlvsub1types.BP_AuthRejectWaitTimeout;
import com.excentis.security.configfile.tlvs.tlvsub1types.BP_AuthWaitTimeout;
import com.excentis.security.configfile.tlvs.tlvsub1types.BP_OperationalWaitTimeout;
import com.excentis.security.configfile.tlvs.tlvsub1types.BP_ReAuthWaitTimeout;
import com.excentis.security.configfile.tlvs.tlvsub1types.BP_RekeyWaitTimeout;
import com.excentis.security.configfile.tlvs.tlvsub1types.BP_SAMapMaxRetries;
import com.excentis.security.configfile.tlvs.tlvsub1types.BP_SAMapWaitTimeout;
import com.excentis.security.configfile.tlvs.tlvsub1types.BP_TEKGraceTime;
import java.util.ArrayList;

public class TLV_BaselinePrivacy
extends SubTypedTLV {
    public static final String typeInfo = "Baseline Privacy Configuration Settings";
    public static final String fullTypeInfo = "Baseline Privacy Configuration Settings".concat(" (17)");
    public static final int AUTH_WAIT_TIMEOUT = 1;
    public static final int REAUTH_WAIT_TIMEOUT = 2;
    public static final int AUTH_GRACE_TIME = 3;
    public static final int OPERATIONAL_WAIT_TIMEOUT = 4;
    public static final int REKEY_WAIT_TIMEOUT = 5;
    public static final int TEK_GRACE_TIME = 6;
    public static final int AUTH_REJECT_WAIT_TIMOUT = 7;
    public static final int SA_MAP_WAIT_TIMEOUT = 8;
    public static final int SA_MAP_MAX_RETRIES = 9;

    public TLV_BaselinePrivacy(ArrayList<ISubTLV> subTLVs) throws InvalidLengthException, UnsupportedTypeException {
        this.setType(17);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public TLV_BaselinePrivacy(byte[] encodedSubTypes) throws Exception {
        int length;
        this.setType(17);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new BP_AuthWaitTimeout(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new BP_ReAuthWaitTimeout(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 3) {
                sub = new BP_AuthGraceTime(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 4) {
                sub = new BP_OperationalWaitTimeout(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 5) {
                sub = new BP_RekeyWaitTimeout(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 6) {
                sub = new BP_TEKGraceTime(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 7) {
                sub = new BP_AuthRejectWaitTimeout(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 8) {
                sub = new BP_SAMapWaitTimeout(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 9) {
                sub = new BP_SAMapMaxRetries(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public void addSubTLV(ISubTLV tlv) throws InvalidLengthException {
        super.addSubTLV(tlv);
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

