/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.panels.CPEEthernetPanel;
import com.excentis.security.tools.Binary2Plaintext;
import com.excentis.security.tools.Plaintext2Binary;
import javax.swing.JPanel;

public class TLV_CPEEthernetMac
extends TLV {
    private String itsMac = null;
    public static final String typeInfo = "CPE Ethernet MAC address";
    public static final String fullTypeInfo = "CPE Ethernet MAC address".concat(" (14)");

    public TLV_CPEEthernetMac(String s) throws Exception {
        if (s.length() != 12) {
            throw new Exception("Mac address should contain exactly 12 characters (6 bytes).");
        }
        for (int i = 0; i < s.length(); ++i) {
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9' || 'A' <= s.charAt(i) && s.charAt(i) <= 'F' || 'a' <= s.charAt(i) && s.charAt(i) <= 'f') continue;
            throw new Exception("Invalid hexadecimal character detected.");
        }
        this.itsMac = s;
        this.setType(14);
        this.setData(new Plaintext2Binary(s).getBytes());
    }

    public void setMac(String s) throws Exception {
        if (s.length() != 12) {
            throw new Exception("Mac address should contain exactly 12 characters (6 bytes).");
        }
        for (int i = 0; i < s.length(); ++i) {
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9' || 'A' <= s.charAt(i) && s.charAt(i) <= 'F' || 'a' <= s.charAt(i) && s.charAt(i) <= 'f') continue;
            throw new Exception("Invalid hexadecimal character detected.");
        }
        this.setData(new Plaintext2Binary(s).getBytes());
        this.itsMac = s;
    }

    public String getMac() {
        return this.itsMac;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new CPEEthernetPanel(this);
    }

    @Override
    public String getShowValue() {
        Binary2Plaintext b2p = new Binary2Plaintext(this.getValue());
        return b2p.getHexRepresentation();
    }
}

