/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub1types.DOCSIS_SYNC_CONFIG_PTPMasterClockEnable;
import com.excentis.security.configfile.tlvs.tlvsub1types.DOCSIS_SYNC_CONFIG_PTPMaxNumberOfClockSlavesConfiguration;
import com.excentis.security.configfile.tlvs.tlvsub1types.DOCSIS_SYNC_CONFIG_PTPProfileConfiguration;
import com.excentis.security.configfile.tlvs.tlvsub1types.DOCSIS_SYNC_CONFIG_SyncEClockEnable;
import java.util.ArrayList;

public class TLV_DOCSISSyncConfigurations
extends SubTypedTLV {
    public static final String typeInfo = "DOCSIS Sync Configurations";
    public static final String fullTypeInfo = "DOCSIS Sync Configurations".concat(" (101)");
    public static final int PTP_MASTER_CLOCK_ENABLE = 1;
    public static final int PTP_PROFILE_CONFIGURATION = 2;
    public static final int PTP_MAX_NUMBER_OF_CLOCK_SLAVES_CONFIGURATION = 3;
    public static final int SYNCE_CLOCK_ENABLE = 4;

    public TLV_DOCSISSyncConfigurations(ArrayList<ISubTLV> subTLVs) throws InvalidLengthException, UnsupportedTypeException {
        this.setType(101);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public TLV_DOCSISSyncConfigurations(byte[] encodedSubTypes) throws Exception {
        int length;
        this.setType(101);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new DOCSIS_SYNC_CONFIG_PTPMasterClockEnable(this, this.getBooleanFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new DOCSIS_SYNC_CONFIG_PTPProfileConfiguration(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 3) {
                sub = new DOCSIS_SYNC_CONFIG_PTPMaxNumberOfClockSlavesConfiguration(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 4) {
                sub = new DOCSIS_SYNC_CONFIG_SyncEClockEnable(this, this.getBooleanFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public void addSubTLV(ISubTLV tlv) throws InvalidLengthException {
        super.addSubTLV(tlv);
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

