/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub1types.DOCS10_COSPrivacy;
import com.excentis.security.configfile.tlvs.tlvsub1types.DOCS10_ClassID;
import com.excentis.security.configfile.tlvs.tlvsub1types.DOCS10_GuaranteedMinUSRate;
import com.excentis.security.configfile.tlvs.tlvsub1types.DOCS10_MaxDSRate;
import com.excentis.security.configfile.tlvs.tlvsub1types.DOCS10_MaxUSBurst;
import com.excentis.security.configfile.tlvs.tlvsub1types.DOCS10_MaxUSRate;
import com.excentis.security.configfile.tlvs.tlvsub1types.DOCS10_USChannelPriority;
import java.util.ArrayList;

public class TLV_DOCSIS_1_0_COS
extends SubTypedTLV {
    public static final int CLASSID = 1;
    public static final int MAXDOWNSTREAMRATE = 2;
    public static final int MAXUPSTREAMRATE = 3;
    public static final int UPSTREAMCHANNELPRIORITY = 4;
    public static final int GUARANTEEDMINIMUMUPSTREAMRATE = 5;
    public static final int MAXUPSTREAMBURST = 6;
    public static final int COSPRIVACYENABLE = 7;
    private ConfigFile itsConfigFile = null;
    public static final String typeInfo = "Euro-DOCSIS 1.0 Class of Service Configuration";
    public static final String fullTypeInfo = "Euro-DOCSIS 1.0 Class of Service Configuration".concat(" (4)");

    public TLV_DOCSIS_1_0_COS(ArrayList<ISubTLV> subTLVs, ConfigFile cfg) throws InvalidLengthException, UnsupportedTypeException {
        this.setType(4);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
        this.itsConfigFile = cfg;
    }

    public TLV_DOCSIS_1_0_COS(byte[] encodedSubTypes, ConfigFile cfg) throws Exception {
        int length;
        this.setType(4);
        int totalLength = encodedSubTypes.length;
        this.itsConfigFile = cfg;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new DOCS10_ClassID(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new DOCS10_MaxDSRate(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 3) {
                sub = new DOCS10_MaxUSRate(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 4) {
                sub = new DOCS10_USChannelPriority(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 5) {
                sub = new DOCS10_GuaranteedMinUSRate(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 6) {
                sub = new DOCS10_MaxUSBurst(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 7) {
                sub = new DOCS10_COSPrivacy(this, this.getBooleanFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public void addSubTLV(ISubTLV tlv) throws InvalidLengthException {
        super.addSubTLV(tlv);
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    public ConfigFile getConfigFile() {
        return this.itsConfigFile;
    }

    public int[] getUsedIDs() {
        return this.itsConfigFile.getUsedCosIds();
    }

    public void setUsedIDs(int[] ids) {
        this.itsConfigFile.setUsedCosIds(ids);
    }

    public void clearUsedIDs() {
        this.itsConfigFile.setUsedCosIds(null);
    }

    public void addUsedID(int id) {
        int[] usedIDs = this.itsConfigFile.getUsedCosIds();
        if (usedIDs == null) {
            usedIDs = new int[]{id};
            this.itsConfigFile.setUsedCosIds(usedIDs);
            return;
        }
        int[] dummy = new int[usedIDs.length + 1];
        for (int i = 0; i < usedIDs.length; ++i) {
            dummy[i] = usedIDs[i];
        }
        dummy[usedIDs.length] = id;
        usedIDs = dummy;
        this.itsConfigFile.setUsedCosIds(usedIDs);
    }

    public void removeUsedID(int id) {
        int[] usedIDs = this.itsConfigFile.getUsedCosIds();
        if (usedIDs == null) {
            return;
        }
        if (this.used(id)) {
            int[] dummy = new int[usedIDs.length - 1];
            int current = 0;
            for (int i = 0; i < usedIDs.length; ++i) {
                if (usedIDs[i] == id) continue;
                dummy[current++] = usedIDs[i];
            }
            usedIDs = dummy;
            this.itsConfigFile.setUsedCosIds(usedIDs);
            return;
        }
    }

    public boolean used(int newid) {
        if (this.itsConfigFile.getUsedCosIds() == null) {
            return false;
        }
        for (int i = 0; i < this.itsConfigFile.getUsedCosIds().length; ++i) {
            if (this.itsConfigFile.getUsedCosIds()[i] != newid) continue;
            return true;
        }
        return false;
    }

    public int getFirstFreeID() {
        for (int i = 1; i < 17; ++i) {
            if (this.used(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

