/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.TLV_GenericSub;
import com.excentis.security.configfile.tlvs.tlvsub1types.DUT_CMIM;
import com.excentis.security.configfile.tlvs.tlvsub1types.DUT_Control;
import java.util.ArrayList;

public class TLV_DUTFiltering
extends SubTypedTLV {
    public static final int DUT_CONTROL = 1;
    public static final int DUT_CMIM = 2;
    public static final String typeInfo = "Downstream Unencrypted Traffic Filtering";
    public static final String fullTypeInfo = "Downstream Unencrypted Traffic Filtering".concat(" (45)");

    public TLV_DUTFiltering(ArrayList<ISubTLV> subTLVs) throws InvalidLengthException, UnsupportedTypeException {
        this.setType(45);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public TLV_DUTFiltering(byte[] encodedSubTypes) throws Exception {
        int length;
        this.setType(45);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new DUT_Control(this, this.getBooleanFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new DUT_CMIM(this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (ConfigFile.getCheatMode()) {
                sub = new TLV_GenericSub(this, type, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public void addSubTLV(ISubTLV tlv) throws InvalidLengthException {
        super.addSubTLV(tlv);
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

