/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class TLV_DefaultUpstreamTargetBufferConfiguration
extends TLV
implements INumberTlv {
    private int itsBuffer = 0;
    public static final String typeInfo = "Default Upstream Target Buffer Configuration";
    public static final String fullTypeInfo = "Default Upstream Target Buffer Configuration".concat(" (68)");

    public TLV_DefaultUpstreamTargetBufferConfiguration(int buffer) throws InvalidLengthException, UnsupportedTypeException, InvalidNumberException {
        this.setType(68);
        this.setNumber(buffer);
    }

    public TLV_DefaultUpstreamTargetBufferConfiguration(byte[] value) throws InvalidLengthException, UnsupportedTypeException, InvalidNumberException {
        this.setType(68);
        this.setNumber(this.getIntFromBytes(value));
    }

    private void checkConstraints(int buffer) throws InvalidNumberException {
        if (buffer < 0) {
            throw new InvalidNumberException(this, 0, 65535);
        }
        if (buffer > 65535) {
            throw new InvalidNumberException(this, 0, 65535);
        }
    }

    @Override
    public void setNumber(int buffer) throws InvalidNumberException, InvalidLengthException {
        this.checkConstraints(buffer);
        this.setData(this.encodeInt2(buffer));
        this.itsBuffer = buffer;
    }

    @Override
    public int getNumber() {
        return this.itsBuffer;
    }

    @Override
    public String getShowValue() {
        return "" + this.getNumber();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Buffer Config (ms):");
    }
}

