/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub1types.V3NOT_Filtering;
import com.excentis.security.configfile.tlvs.tlvsub1types.V3NOT_IPAddress;
import com.excentis.security.configfile.tlvs.tlvsub1types.V3NOT_IPv6Address;
import com.excentis.security.configfile.tlvs.tlvsub1types.V3NOT_Retries;
import com.excentis.security.configfile.tlvs.tlvsub1types.V3NOT_SecurityName;
import com.excentis.security.configfile.tlvs.tlvsub1types.V3NOT_Timeout;
import com.excentis.security.configfile.tlvs.tlvsub1types.V3NOT_TypeOfTrap;
import com.excentis.security.configfile.tlvs.tlvsub1types.V3NOT_UDPPort;
import java.io.ByteArrayInputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;

public class TLV_DocsisV3NotificationReceiver
extends SubTypedTLV {
    public static final String typeInfo = "Docsis V3 Notification Receiver";
    public static final String fullTypeInfo = "Docsis V3 Notification Receiver".concat(" (38)");
    public static final int IP_ADDRESS = 1;
    public static final int UDP_PORT = 2;
    public static final int TYPE_OF_TRAP = 3;
    public static final int TIMEOUT = 4;
    public static final int NUM_RETRIES = 5;
    public static final int NOTIFICATION_FILTERING = 6;
    public static final int SECURITY_NAME = 7;
    public static final int IPV6_ADDRESS = 8;
    private ConfigFile itsConfigFile = null;

    public TLV_DocsisV3NotificationReceiver(ArrayList<ISubTLV> subTLVs, ConfigFile cfg) throws InvalidLengthException, UnsupportedTypeException, Exception {
        this.itsConfigFile = cfg;
        if (this.itsConfigFile.V3COUNT == 10) {
            throw new Exception("already 10 SNMP v3 Notification TLVs present");
        }
        this.setType(38);
        ++this.itsConfigFile.V3COUNT;
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    protected TLV_DocsisV3NotificationReceiver(ArrayList<ISubTLV> subTLVs) throws InvalidLengthException, UnsupportedTypeException, Exception {
        this.setType(38);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public void clearCount() {
        this.itsConfigFile.V3COUNT = 0;
    }

    public TLV_DocsisV3NotificationReceiver(byte[] encodedSubTypes, ConfigFile cfg) throws Exception {
        this.itsConfigFile = cfg;
        if (this.itsConfigFile.V3COUNT == 10) {
            throw new Exception("already 10 SNMP v3 Notification TLVs present");
        }
        this.setType(38);
        ++this.itsConfigFile.V3COUNT;
        this.decode(encodedSubTypes);
    }

    protected TLV_DocsisV3NotificationReceiver(byte[] encodedSubTypes) throws Exception {
        this.setType(38);
        this.decode(encodedSubTypes);
    }

    private void decode(byte[] encodedSubTypes) throws Exception {
        int length;
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new V3NOT_IPAddress(this, InetAddress.getByAddress(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new V3NOT_UDPPort(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 3) {
                sub = new V3NOT_TypeOfTrap(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 4) {
                sub = new V3NOT_Timeout(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 5) {
                sub = new V3NOT_Retries(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 6) {
                sub = new V3NOT_Filtering(this, (OBJECT_IDENTIFIER)OBJECT_IDENTIFIER.getTemplate().decode(new ByteArrayInputStream(value)));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 7) {
                sub = new V3NOT_SecurityName(this, new String(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 8) {
                sub = new V3NOT_IPv6Address(this, (Inet6Address)InetAddress.getByAddress(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public void addSubTLV(ISubTLV tlv) throws InvalidLengthException {
        super.addSubTLV(tlv);
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

