/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub1types.DOWNCHANLIST_DefaultScanning;
import com.excentis.security.configfile.tlvs.tlvsub1types.DOWNCHANLIST_FrequencyRange;
import com.excentis.security.configfile.tlvs.tlvsub1types.DOWNCHANLIST_SingleDownstreamChannel;
import java.util.ArrayList;

public class TLV_DownstreamChannelList
extends SubTypedTLV {
    public static final String typeInfo = "Downstream Channel List";
    public static final String fullTypeInfo = "Downstream Channel List".concat(" (41)");
    public static final int SINGLE_DOWNSTREAM_CHANNEL = 1;
    public static final int DOWNSTREAM_FREQUENCY_RANGE = 2;
    public static final int DEFAULT_SCANNING = 3;

    public TLV_DownstreamChannelList(int type, ArrayList<ISubTLV> subTLVs, ConfigFile cfg) throws Exception {
        if (type != 41) {
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setType(type);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public TLV_DownstreamChannelList(int typ, byte[] encodedSubTypes, ConfigFile cfg) throws Exception {
        int length;
        if (typ != 41) {
            throw new UnsupportedTypeException(typeInfo, typ);
        }
        this.setType(typ);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new DOWNCHANLIST_SingleDownstreamChannel((TLV)this, value);
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new DOWNCHANLIST_FrequencyRange((TLV)this, value);
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 3) {
                sub = new DOWNCHANLIST_DefaultScanning(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

