/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.ConfigFileGUI;
import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.panels.DownstreamServiceFlowPanel;
import com.excentis.security.configfile.tlvs.TLV_GenericSub;
import com.excentis.security.configfile.tlvs.TLV_ServiceFlow;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_AQMEncodings;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_AggregateSFReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_ApplicationIdentifier;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_AssumedMinimumReservedRatePacketSize;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_AttributeAggregationRuleMask;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_BufferControl;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_ClassName;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_DSMaxSustainedTrafficRate;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_DataRateUnitSetting;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_DownstreamPeakTrafficRate;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_DownstreamResequencing;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_ExtensionField;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_ForbiddenAttributeMask;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_IPToSOverwrite;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_Identifier;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_MESPReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_MaxTrafficBurst;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_MaximumDownstreamLatency;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_MinimumReservedTrafficRate;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_QoSSet;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_Reference;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_RequiredAttributeMask;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_TimeoutForActiveQoS;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_TimeoutForAdmittedQoS;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_ToIATCProfileNameReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_TrafficPriority;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_VendorSpecific;
import java.util.ArrayList;
import javax.swing.JPanel;

public class TLV_DownstreamServiceFlow
extends TLV_ServiceFlow {
    public static final String typeInfo = "Downstream Service Flow Encodings";
    public static final String fullTypeInfo = "Downstream Service Flow Encodings".concat(" (25)");

    public TLV_DownstreamServiceFlow(ArrayList<ISubTLV> subTLVs, ConfigFile cfg) throws Exception {
        this.setConfigFile(cfg);
        this.setType(25);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public TLV_DownstreamServiceFlow(byte[] encodedSubTypes, ConfigFile cfg) throws Exception {
        int length;
        this.setConfigFile(cfg);
        this.setType(25);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new SF_Reference(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new SF_Identifier(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 4) {
                sub = new SF_ClassName(this, this.decodeStringMinusLast(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 6) {
                boolean[] bool = this.getQoSBooleansFromByte(value);
                SF_QoSSet sub2 = new SF_QoSSet(this, bool[0], bool[1], bool[2]);
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 7) {
                sub = new SF_TrafficPriority(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 8) {
                sub = new SF_DSMaxSustainedTrafficRate(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 9) {
                sub = new SF_MaxTrafficBurst(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 10) {
                sub = new SF_MinimumReservedTrafficRate(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 11) {
                sub = new SF_AssumedMinimumReservedRatePacketSize(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 12) {
                sub = new SF_TimeoutForActiveQoS(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 13) {
                sub = new SF_TimeoutForAdmittedQoS(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 43) {
                byte[] vendor = new byte[3];
                System.arraycopy(value, 2, vendor, 0, 3);
                if (vendor[0] == -1 && vendor[1] == -1 && vendor[2] == -1) {
                    this.getSubTLVs().add(new SF_ExtensionField(this, value));
                    continue;
                }
                this.getSubTLVs().add(new SF_VendorSpecific(this, value));
                continue;
            }
            if (type == 14) {
                sub = new SF_MaximumDownstreamLatency(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 27) {
                sub = new SF_DownstreamPeakTrafficRate(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 17) {
                sub = new SF_DownstreamResequencing(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 23) {
                sub = new SF_IPToSOverwrite(this, value[0], value[1]);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 31) {
                sub = new SF_RequiredAttributeMask(this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 32) {
                sub = new SF_ForbiddenAttributeMask(this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 33) {
                sub = new SF_AttributeAggregationRuleMask(this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 34) {
                sub = new SF_ApplicationIdentifier(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 35) {
                sub = new SF_BufferControl((TLV)this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 36) {
                sub = new SF_AggregateSFReference(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 37) {
                sub = new SF_MESPReference(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 39) {
                sub = new SF_ToIATCProfileNameReference(this, this.decodeStringMinusLast(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 40) {
                sub = new SF_AQMEncodings((TLV)this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 41) {
                sub = new SF_DataRateUnitSetting(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (ConfigFile.getCheatMode()) {
                sub = new TLV_GenericSub(this, type, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI(ConfigFileGUI gui) {
        return new DownstreamServiceFlowPanel(this, gui);
    }
}

