/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.TLV_GenericSub;
import com.excentis.security.configfile.tlvs.TLV_ServiceFlow;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_AssumedMinimumReservedRatePacketSize;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_DSMaxSustainedTrafficRate;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_DataRateUnitSetting;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_EHQoSEncodings;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_MaxTrafficBurst;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_MinimumReservedTrafficRate;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_Reference;
import com.excentis.security.configfile.tlvs.tlvsub1types.SF_TrafficPriority;
import java.util.ArrayList;

public class TLV_Downstream_EHQoS_ASF
extends TLV_ServiceFlow {
    public static final String typeInfo = "Downstream Enhanced HQoS ASF";
    public static final String fullTypeInfo = "Downstream Enhanced HQoS ASF".concat(" (94)");

    public TLV_Downstream_EHQoS_ASF(ArrayList<ISubTLV> subTLVs, ConfigFile cfg) throws Exception {
        this.setConfigFile(cfg);
        this.setType(94);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public TLV_Downstream_EHQoS_ASF(byte[] encodedSubTypes, ConfigFile cfg) throws Exception {
        int length;
        this.setConfigFile(cfg);
        this.setType(94);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new SF_Reference(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 7) {
                sub = new SF_TrafficPriority(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 9) {
                sub = new SF_MaxTrafficBurst(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 8) {
                sub = new SF_DSMaxSustainedTrafficRate(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 10) {
                sub = new SF_MinimumReservedTrafficRate(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 11) {
                sub = new SF_AssumedMinimumReservedRatePacketSize(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 41) {
                sub = new SF_DataRateUnitSetting(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 47) {
                sub = new SF_EHQoSEncodings((TLV)this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (ConfigFile.getCheatMode()) {
                sub = new TLV_GenericSub(this, type, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

