/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.TLV_GenericSub;
import com.excentis.security.configfile.tlvs.tlvsub1types.EROUTER_InitializationMode;
import com.excentis.security.configfile.tlvs.tlvsub1types.EROUTER_InitializationModeOverride;
import com.excentis.security.configfile.tlvs.tlvsub1types.EROUTER_Mib;
import com.excentis.security.configfile.tlvs.tlvsub1types.EROUTER_RATransmissionInterval;
import com.excentis.security.configfile.tlvs.tlvsub1types.EROUTER_Snmpv1v2cCoexistence;
import com.excentis.security.configfile.tlvs.tlvsub1types.EROUTER_Snmpv3AccessView;
import com.excentis.security.configfile.tlvs.tlvsub1types.EROUTER_TR069;
import com.excentis.security.configfile.tlvs.tlvsub1types.EROUTER_TopologyModeEncoding;
import com.excentis.security.configfile.tlvs.tlvsub1types.EROUTER_VendorSpecific;
import java.util.ArrayList;

public class TLV_ERouter
extends SubTypedTLV {
    public static final String typeInfo = "eRouter Configuration Encodings";
    public static final String fullTypeInfo = "eRouter Configuration Encodings".concat(" (202)");
    public static final int INITIALIZATION_MODE = 1;
    public static final int TR069 = 2;
    public static final int INITIALIZATION_MODE_OVERRIDE = 3;
    public static final int RA_TRANSMISSION_INTERVAL = 10;
    public static final int EROUTER_MIB = 11;
    public static final int TOPOLOGY_MODE_ENCODING = 42;
    public static final int SNMP_COEXISTENCE = 53;
    public static final int SNMP_ACCESS_VIEW = 54;
    public static final int VENDOR_SPECIFIC = 43;

    public TLV_ERouter(ArrayList<ISubTLV> subTLVs) throws InvalidLengthException, UnsupportedTypeException {
        this.setType(202);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public TLV_ERouter(byte[] encodedSubTypes) throws Exception {
        int length;
        this.setType(202);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            TLV sub;
            int type = encodedSubTypes[pointer++] & 0xFF;
            length = encodedSubTypes[pointer++] & 0xFF;
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new EROUTER_InitializationMode(this, this.getIntFromBytes(value));
                this.getSubTLVs().add((ISubTLV)((Object)sub));
                continue;
            }
            if (type == 2) {
                sub = new EROUTER_TR069((TLV)this, value);
                this.getSubTLVs().add((ISubTLV)((Object)sub));
                continue;
            }
            if (type == 3) {
                sub = new EROUTER_InitializationModeOverride(this, this.getIntFromBytes(value));
                this.getSubTLVs().add((ISubTLV)((Object)sub));
                continue;
            }
            if (type == 10) {
                sub = new EROUTER_RATransmissionInterval(this, this.getIntFromBytes(value));
                this.getSubTLVs().add((ISubTLV)((Object)sub));
                continue;
            }
            if (type == 11) {
                sub = new EROUTER_Mib(this, value);
                this.getSubTLVs().add((ISubTLV)((Object)sub));
                continue;
            }
            if (type == 42) {
                sub = new EROUTER_TopologyModeEncoding(this, this.getIntFromBytes(value));
                this.getSubTLVs().add((ISubTLV)((Object)sub));
                continue;
            }
            if (type == 53) {
                sub = new EROUTER_Snmpv1v2cCoexistence((TLV)this, value);
                this.getSubTLVs().add((ISubTLV)((Object)sub));
                continue;
            }
            if (type == 54) {
                sub = new EROUTER_Snmpv3AccessView((TLV)this, value);
                this.getSubTLVs().add((ISubTLV)((Object)sub));
                continue;
            }
            if (type == 43) {
                sub = new EROUTER_VendorSpecific(this, value);
                this.getSubTLVs().add((ISubTLV)((Object)sub));
                continue;
            }
            if (ConfigFile.getCheatMode()) {
                sub = new TLV_GenericSub(this, type, value);
                this.getSubTLVs().add((ISubTLV)((Object)sub));
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public void addSubTLV(ISubTLV tlv) throws InvalidLengthException {
        super.addSubTLV(tlv);
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

