/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.TLV_GenericSub;
import com.excentis.security.configfile.tlvs.tlvsub1types.ESTB_DocsisV3NotificationReceiver;
import com.excentis.security.configfile.tlvs.tlvsub1types.ESTB_HomeNetworkPrefixValidation;
import com.excentis.security.configfile.tlvs.tlvsub1types.ESTB_IPModeControl;
import com.excentis.security.configfile.tlvs.tlvsub1types.ESTB_Mib;
import com.excentis.security.configfile.tlvs.tlvsub1types.ESTB_SEB_TLS;
import com.excentis.security.configfile.tlvs.tlvsub1types.ESTB_Snmpv1v2cCoexistence;
import com.excentis.security.configfile.tlvs.tlvsub1types.ESTB_Snmpv3AccessView;
import com.excentis.security.configfile.tlvs.tlvsub1types.ESTB_VendorSpecific;
import java.util.ArrayList;

public class TLV_ESTB
extends SubTypedTLV {
    public static final String typeInfo = "eSTB Configuration";
    public static final String fullTypeInfo = "eSTB Configuration".concat(" (217)");
    public static final int IP_MODE_CONTROL = 1;
    public static final int ESTB_MIB = 11;
    public static final int NOTIFICATION_RECEIVER = 38;
    public static final int HOME_NETWORK_PREFIX_VALIDATION = 39;
    public static final int SEB_SERVER_ENABLE_TLS_CIPHER_SUITES = 40;
    public static final int SNMP_COEXISTENCE = 53;
    public static final int SNMP_ACCESS_VIEW = 54;
    public static final int VENDOR_SPECIFIC = 43;

    public TLV_ESTB(ArrayList<ISubTLV> subTLVs) throws InvalidLengthException, UnsupportedTypeException {
        this.setType(217);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public TLV_ESTB(byte[] encodedSubTypes) throws Exception {
        int length;
        this.setType(217);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            TLV sub;
            int type = encodedSubTypes[pointer++] & 0xFF;
            length = encodedSubTypes[pointer++] & 0xFF;
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new ESTB_IPModeControl(this, this.getIntFromBytes(value));
                this.getSubTLVs().add((ISubTLV)((Object)sub));
                continue;
            }
            if (type == 11) {
                sub = new ESTB_Mib(this, value);
                this.getSubTLVs().add((ISubTLV)((Object)sub));
                continue;
            }
            if (type == 38) {
                sub = new ESTB_DocsisV3NotificationReceiver((TLV)this, value);
                this.getSubTLVs().add((ISubTLV)((Object)sub));
                continue;
            }
            if (type == 39) {
                sub = new ESTB_HomeNetworkPrefixValidation((TLV)this, value);
                this.getSubTLVs().add((ISubTLV)((Object)sub));
                continue;
            }
            if (type == 40) {
                sub = new ESTB_SEB_TLS(this, value);
                this.getSubTLVs().add((ISubTLV)((Object)sub));
                continue;
            }
            if (type == 53) {
                sub = new ESTB_Snmpv1v2cCoexistence((TLV)this, value);
                this.getSubTLVs().add((ISubTLV)((Object)sub));
                continue;
            }
            if (type == 54) {
                sub = new ESTB_Snmpv3AccessView((TLV)this, value);
                this.getSubTLVs().add((ISubTLV)((Object)sub));
                continue;
            }
            if (type == 43) {
                sub = new ESTB_VendorSpecific(this, value);
                this.getSubTLVs().add((ISubTLV)((Object)sub));
                continue;
            }
            if (ConfigFile.getCheatMode()) {
                sub = new TLV_GenericSub(this, type, value);
                this.getSubTLVs().add((ISubTLV)((Object)sub));
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

