/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub1types.Energy_1x1ModeEncodings;
import com.excentis.security.configfile.tlvs.tlvsub1types.Energy_CyclePeriod;
import com.excentis.security.configfile.tlvs.tlvsub1types.Energy_DocsisLightSleep;
import com.excentis.security.configfile.tlvs.tlvsub1types.Energy_FeatureControl;
import java.math.BigInteger;
import java.util.ArrayList;

public class TLV_EnergyManagement
extends SubTypedTLV {
    public static final String typeInfo = "Energy Management Parameter Encoding";
    public static final String fullTypeInfo = "Energy Management Parameter Encoding".concat(" (74)");
    public static final int FEATURE_CONTROL = 1;
    public static final int ONE_ONE_MODE_ENCODINGS = 2;
    public static final int CYCLE_PERIOD = 3;
    public static final int DOCSIS_LIGHT_SLEEP_MODE_ENCODINGS = 4;

    public TLV_EnergyManagement(ArrayList<ISubTLV> subTLVs) throws InvalidLengthException, UnsupportedTypeException {
        this.setType(74);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public TLV_EnergyManagement(byte[] encodedSubTypes) throws Exception {
        int length;
        this.setType(74);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new Energy_FeatureControl(this, new BigInteger(value).intValue());
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new Energy_1x1ModeEncodings((TLV)this, value);
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 3) {
                sub = new Energy_CyclePeriod(this, this.getIntFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 4) {
                sub = new Energy_DocsisLightSleep((TLV)this, value);
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public void addSubTLV(ISubTLV tlv) throws InvalidLengthException {
        super.addSubTLV(tlv);
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

