/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.TLV_GenericSub;
import com.excentis.security.configfile.tlvs.tlvsub1types.ExtensionField_CmAttributeMasks;
import com.excentis.security.configfile.tlvs.tlvsub1types.ExtensionField_CmRangingClassIdExtension;
import com.excentis.security.configfile.tlvs.tlvsub1types.ExtensionField_DACEncoding;
import com.excentis.security.configfile.tlvs.tlvsub1types.ExtensionField_ExtendedCmtsMic;
import com.excentis.security.configfile.tlvs.tlvsub1types.ExtensionField_GroupId;
import com.excentis.security.configfile.tlvs.tlvsub1types.ExtensionField_L2vpnEncoding;
import com.excentis.security.configfile.tlvs.tlvsub1types.ExtensionField_MulticastJoin;
import com.excentis.security.configfile.tlvs.tlvsub1types.ExtensionField_PolicyId;
import com.excentis.security.configfile.tlvs.tlvsub1types.ExtensionField_Priority;
import com.excentis.security.configfile.tlvs.tlvsub1types.ExtensionField_SavAuthorization;
import com.excentis.security.configfile.tlvs.tlvsub1types.ExtensionField_ServiceTypeId;
import com.excentis.security.utils.CertUtils;

public class TLV_ExtensionField
extends SubTypedTLV {
    public static final String typeInfo = "Euro-DOCSIS Extension Field";
    public static final String fullTypeInfo = "Euro-DOCSIS Extension Field".concat(" (43)");
    public static final int LOAD_BALANCE_POLICY_ID = 1;
    public static final int LOAD_BALANCE_PRIORITY = 2;
    public static final int LOAD_BALANCE_GROUP_ID = 3;
    public static final int CM_RANGING_CLASS_ID_EXTENSION = 4;
    public static final int L2VPN_ENCODING = 5;
    public static final int EXTENDED_CMTS_MIC_CONFIG = 6;
    public static final int SAV_AUTHORIZATION_ENCODING = 7;
    public static final int CM_ATTRIBUTE_MASKS = 9;
    public static final int IP_MULTICAST_JOIN_AUTHORIZATION = 10;
    public static final int SERVICE_TYPE_ID = 11;
    public static final int DAC_ENCODING = 12;

    public TLV_ExtensionField(byte[] value) throws Exception {
        this.setType(43);
        if (value[0] != 8) {
            throw new Exception("Illegal Vendor ID, expected type 0x08, got " + value[0]);
        }
        if (value[1] != 3) {
            throw new Exception("Illegal Vendor ID length, expected 0x03, got " + value[1]);
        }
        if (value.length < 5) {
            throw new Exception("Illegal Vendor Specific Field length, must at least be 5 to hold vendor id, got only " + value.length);
        }
        byte[] vendorId = new byte[3];
        System.arraycopy(value, 2, vendorId, 0, 3);
        byte[] extfields = new byte[value.length - 5];
        System.arraycopy(value, 5, extfields, 0, extfields.length);
        int totalLength = extfields.length;
        int pointer = 0;
        while (pointer < totalLength) {
            SubTLV sub;
            int type = this.getTypeFromByte(extfields[pointer++]);
            int length = this.getLengthFromByte(extfields[pointer++]);
            byte[] val = new byte[length];
            if (totalLength < pointer + length) {
                throw new InvalidLengthException("" + this.getTypeInfo() + " subtype " + type);
            }
            for (int i = 0; i < length; ++i) {
                val[i] = extfields[pointer++];
            }
            if (type == 1) {
                sub = new ExtensionField_PolicyId(this, this.getIntFromBytes(val));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new ExtensionField_Priority(this, this.getIntFromBytes(val));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 3) {
                sub = new ExtensionField_GroupId(this, this.getIntFromBytes(val));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 4) {
                sub = new ExtensionField_CmRangingClassIdExtension(this, this.getIntFromBytes(val));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 5) {
                sub = new ExtensionField_L2vpnEncoding((TLV)this, val);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 6) {
                sub = new ExtensionField_ExtendedCmtsMic((TLV)this, val);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 7) {
                sub = new ExtensionField_SavAuthorization((TLV)this, val);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 9) {
                sub = new ExtensionField_CmAttributeMasks((TLV)this, val);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 10) {
                sub = new ExtensionField_MulticastJoin((TLV)this, val);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 11) {
                sub = new ExtensionField_ServiceTypeId(this, new String(val));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 12) {
                sub = new ExtensionField_DACEncoding(this, val);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (ConfigFile.getCheatMode()) {
                sub = new TLV_GenericSub(this, type, val);
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(CertUtils.appendAt(this.encodeVendor(), this.encode(this.getSubTLVs())));
    }

    private byte[] encodeVendor() {
        return new byte[]{8, 3, -1, -1, -1};
    }

    @Override
    public byte[] getValue() {
        return CertUtils.appendAt(this.encodeVendor(), this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public byte[] getTypeAndLength() {
        byte[] retval = new byte[7];
        retval[0] = (byte)this.getType();
        retval[1] = (byte)this.getLength();
        System.arraycopy(this.encodeVendor(), 0, retval, 2, 5);
        return retval;
    }
}

