/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.MESP_BandwidthProfile;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.MESP_Name;
import com.excentis.security.configfile.tlvs.tlvsub1types.docsis30.MESP_Reference;
import java.util.ArrayList;

public class TLV_MESP
extends SubTypedTLV {
    public static final int REFERENCE = 1;
    public static final int BANDWIDTH_PROFILE = 2;
    public static final int NAME = 3;
    public static final String typeInfo = "Metro Ethernet Service Profile (MESP) Encoding";
    public static final String fullTypeInfo = "Metro Ethernet Service Profile (MESP) Encoding".concat(" (72)");
    private ConfigFile itsConfigFile = null;

    public void setConfigFile(ConfigFile cfg) {
        this.itsConfigFile = cfg;
    }

    public ConfigFile getConfigFile() {
        return this.itsConfigFile;
    }

    public TLV_MESP(ArrayList<ISubTLV> subTLVs, ConfigFile cfg) throws Exception {
        this.setConfigFile(cfg);
        this.setType(72);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public TLV_MESP(byte[] encodedSubTypes, ConfigFile cfg) throws Exception {
        int length;
        this.setConfigFile(cfg);
        this.setType(72);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new MESP_Reference(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new MESP_BandwidthProfile((TLV)this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 3) {
                sub = new MESP_Name(this, this.decodeStringMinusLast(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    public int getReference() throws Exception {
        ArrayList<ISubTLV> subs = this.getSubTypeTLVs(1);
        if (subs.size() == 0) {
            return -1;
        }
        if (subs.size() > 1) {
            throw new Exception("Error: multiple SF references found on a single downstream service flow object!");
        }
        MESP_Reference ref = (MESP_Reference)subs.iterator().next();
        return ref.getReference();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

