/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub1types.MACLEARN_Control;
import com.excentis.security.configfile.tlvs.tlvsub1types.MACLEARN_HoldoffTimer;
import java.util.ArrayList;

public class TLV_MacAddressLearningControlEncoding
extends SubTypedTLV {
    public static final String typeInfo = "MAC Address Learning Control Encoding";
    public static final String fullTypeInfo = "MAC Address Learning Control Encoding".concat(" (69)");
    public static final int MAC_ADDRESS_CONTROL = 1;
    public static final int MAC_ADDRESS_HOLDOFF_TIMER = 2;

    public TLV_MacAddressLearningControlEncoding(ArrayList<ISubTLV> subTLVs) throws InvalidLengthException, UnsupportedTypeException {
        this.setType(69);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public TLV_MacAddressLearningControlEncoding(byte[] encodedSubTypes) throws Exception {
        int length;
        this.setType(69);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new MACLEARN_Control(this, this.getBooleanFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new MACLEARN_HoldoffTimer(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public void addSubTLV(ISubTLV tlv) throws InvalidLengthException {
        super.addSubTLV(tlv);
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

