/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidLongNumberException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.interfaces.ILongNumberTlv;
import com.excentis.security.configfile.panels.basic.LongNumberPanel;
import javax.swing.JPanel;

public class TLV_ManagementEventControl
extends TLV
implements ILongNumberTlv {
    private long itsEventId = 0L;
    public static final String typeInfo = "Management Event Control Encoding";
    public static final String fullTypeInfo = "Management Event Control Encoding".concat(" (66)");

    public TLV_ManagementEventControl(long eventId) throws UnsupportedTypeException, InvalidLengthException, InvalidLongNumberException {
        this.setType(66);
        this.setLongNumber(eventId);
    }

    public TLV_ManagementEventControl(byte[] value) throws UnsupportedTypeException, InvalidLengthException, InvalidLongNumberException {
        this.setType(66);
        this.setLongNumber(this.getLongFromBytes(value));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsEventId;
    }

    @Override
    public JPanel showGUI() {
        return new LongNumberPanel(this, "Event ID");
    }

    @Override
    public long getLongNumber() {
        return this.itsEventId;
    }

    @Override
    public void setLongNumber(long number) throws InvalidLongNumberException, InvalidLengthException {
        this.itsEventId = number;
        this.setData(this.encodeLong(number));
    }
}

