/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class TLV_MaxCPE
extends TLV
implements INumberTlv {
    public static final String typeInfo = "Maximum Number of CPEs";
    public static final String fullTypeInfo = "Maximum Number of CPEs".concat(" (18)");
    private int itsMaxCPE = 0;

    public TLV_MaxCPE(int maxCPE) throws InvalidLengthException, UnsupportedTypeException, InvalidNumberException {
        this.setType(18);
        this.setNumber(maxCPE);
    }

    private void checkConstraints(int maxCPE) throws InvalidNumberException {
        if (maxCPE < 0) {
            throw new InvalidNumberException(this, 0, 255);
        }
        if (maxCPE > 255) {
            throw new InvalidNumberException(this, 0, 255);
        }
    }

    @Override
    public void setNumber(int maxCPE) throws InvalidNumberException, InvalidLengthException {
        this.checkConstraints(maxCPE);
        this.setData(this.encodeInt1(maxCPE));
        this.itsMaxCPE = maxCPE;
    }

    @Override
    public int getNumber() {
        return this.itsMaxCPE;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Max CPE:");
    }

    @Override
    public String getShowValue() {
        return "" + this.itsMaxCPE;
    }
}

