/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class TLV_MaxClassifier
extends TLV
implements INumberTlv {
    public static final String typeInfo = "Maximum Number of Classifiers";
    public static final String fullTypeInfo = "Maximum Number of Classifiers".concat(" (28)");
    private int itsMaxClass = 0;

    public TLV_MaxClassifier(int maxClass) throws InvalidLengthException, UnsupportedTypeException, InvalidNumberException {
        this.setType(28);
        this.setNumber(maxClass);
    }

    private void checkConstraints(int maxClass) throws InvalidNumberException {
        if (maxClass < 0) {
            throw new InvalidNumberException(this, 0, 65535);
        }
        if (maxClass > 65535) {
            throw new InvalidNumberException(this, 0, 65535);
        }
    }

    @Override
    public void setNumber(int maxClass) throws InvalidNumberException, InvalidLengthException {
        this.checkConstraints(maxClass);
        this.setData(this.encodeInt2(maxClass));
        this.itsMaxClass = maxClass;
    }

    @Override
    public int getNumber() {
        return this.itsMaxClass;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsMaxClass;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Max number of Classifiers:");
    }
}

