/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.Counter;
import com.excentis.security.configfile.Gauge;
import com.excentis.security.configfile.IPAddress;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.TimeTicks;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.panels.MibPanel;
import com.excentis.security.tools.Binary2Plaintext;
import com.excentis.security.utils.CertUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.mozilla.jss.asn1.ASN1NULL;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;

public class TLV_Mib
extends TLV {
    public static final String typeInfo = "SNMP MIB Object";
    public static final String fullTypeInfo = "SNMP MIB Object".concat(" (11)");
    public static final int MIB_Integer = 2;
    public static final int MIB_Octet_String = 4;
    public static final int MIB_Null = 5;
    public static final int MIB_Object_Identifier = 6;
    public static final int MIB_IpAddress = 64;
    public static final int MIB_Counter = 65;
    public static final int MIB_Gauge = 66;
    public static final int MIB_TimeTicks = 67;
    public static ArrayList<OBJECT_IDENTIFIER> knownOIDs = new ArrayList();
    public static ArrayList<String> knownOIDStrings = new ArrayList();
    public static ArrayList<String> knownOIDTypes = new ArrayList();
    public static ArrayList<String> knownTypes = new ArrayList();
    private OBJECT_IDENTIFIER itsOID = null;
    private byte[] itsVal = null;
    private boolean isReadable = true;

    public TLV_Mib(byte[] value) throws InvalidLengthException, UnsupportedTypeException, Exception {
        super(11, value);
        int i;
        if (value.length == 0) {
            throw new InvalidLengthException(typeInfo);
        }
        if (value[0] != 48) {
            throw new UnsupportedTypeException(typeInfo, value[0]);
        }
        int totallen = 0;
        int startingbyte = 0;
        if (value[1] == -126) {
            totallen = new BigInteger(new byte[]{value[2], value[3]}).intValue();
            startingbyte = 4;
        } else if (value[1] == -127) {
            totallen = value[2];
            startingbyte = 3;
            if (totallen < 0) {
                totallen += 256;
            }
        } else {
            totallen = value[1];
            startingbyte = 2;
        }
        if (value[startingbyte] != 6) {
            throw new UnsupportedTypeException(typeInfo, value[2]);
        }
        int oidlen = TLV_Mib.getLength(value, startingbyte + 1)[0];
        int oidlenlen = TLV_Mib.getLength(value, startingbyte + 1)[1];
        byte[] oidbytes = new byte[1 + oidlen + oidlenlen];
        for (i = 0; i < oidbytes.length; ++i) {
            oidbytes[i] = value[i + startingbyte];
        }
        this.itsOID = (OBJECT_IDENTIFIER)OBJECT_IDENTIFIER.getTemplate().decode(new ByteArrayInputStream(oidbytes));
        this.itsVal = new byte[totallen - (1 + oidlen + oidlenlen)];
        for (i = 0; i < this.itsVal.length; ++i) {
            this.itsVal[i] = value[i + 1 + oidlen + oidlenlen + startingbyte];
        }
    }

    public TLV_Mib(OBJECT_IDENTIFIER oid, byte[] value) throws InvalidLengthException, UnsupportedTypeException, IOException {
        super(11, TLV_Mib.getEnc(oid, value));
        this.itsOID = oid;
        this.itsVal = (byte[])value.clone();
    }

    public TLV_Mib(OBJECT_IDENTIFIER oid, INTEGER val) throws InvalidLengthException, UnsupportedTypeException, IOException {
        this(oid, val.encode());
        this.itsOID = oid;
        this.itsVal = val.encode();
    }

    public TLV_Mib(OBJECT_IDENTIFIER oid, OCTET_STRING val) throws InvalidLengthException, UnsupportedTypeException, IOException {
        this(oid, TLV_Mib.OctetToByte(val));
        this.itsOID = oid;
        this.itsVal = TLV_Mib.OctetToByte(val);
    }

    public TLV_Mib(OBJECT_IDENTIFIER oid, BIT_STRING val) throws InvalidLengthException, UnsupportedTypeException, IOException {
        this(oid, TLV_Mib.BitToByte(val));
        this.itsOID = oid;
        this.itsVal = TLV_Mib.BitToByte(val);
    }

    public TLV_Mib(OBJECT_IDENTIFIER oid, InetAddress val) throws InvalidLengthException, UnsupportedTypeException, IOException {
        this(oid, new IPAddress(val).getEncoded());
        this.itsOID = oid;
        this.itsVal = new IPAddress(val).getEncoded();
    }

    public TLV_Mib(OBJECT_IDENTIFIER oid, Gauge val) throws InvalidLengthException, UnsupportedTypeException, IOException {
        this(oid, val.getEncoded());
        this.itsOID = oid;
        this.itsVal = val.getEncoded();
    }

    public TLV_Mib(OBJECT_IDENTIFIER oid, Counter val) throws InvalidLengthException, UnsupportedTypeException, IOException {
        this(oid, val.getEncoded());
        this.itsOID = oid;
        this.itsVal = val.getEncoded();
    }

    public TLV_Mib(OBJECT_IDENTIFIER oid, TimeTicks val) throws InvalidLengthException, UnsupportedTypeException, IOException {
        this(oid, val.getEncoded());
        this.itsOID = oid;
        this.itsVal = val.getEncoded();
    }

    public TLV_Mib(OBJECT_IDENTIFIER oid, ASN1NULL val) throws InvalidLengthException, UnsupportedTypeException, IOException {
        this(oid, TLV_Mib.NullToByte(val));
        this.itsOID = oid;
        this.itsVal = TLV_Mib.NullToByte(val);
    }

    public TLV_Mib(OBJECT_IDENTIFIER oid, OBJECT_IDENTIFIER val) throws InvalidLengthException, UnsupportedTypeException, IOException {
        this(oid, TLV_Mib.OidToByte(val));
        this.itsOID = oid;
        this.itsVal = TLV_Mib.OidToByte(val);
    }

    private static byte[] getEnc(OBJECT_IDENTIFIER oid, byte[] val) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        oid.encode(baos);
        byte[] oidd = baos.toByteArray();
        byte[] total = CertUtils.appendAt(oidd, val);
        byte[] tlvalue = CertUtils.encode(total, 48);
        return tlvalue;
    }

    private static byte[] OctetToByte(OCTET_STRING oct) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        oct.encode(baos);
        return baos.toByteArray();
    }

    private static byte[] NullToByte(ASN1NULL nul) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        nul.encode(baos);
        return baos.toByteArray();
    }

    private static byte[] OidToByte(OBJECT_IDENTIFIER oid) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        oid.encode(baos);
        return baos.toByteArray();
    }

    private static byte[] BitToByte(BIT_STRING oct) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        oct.encode(baos);
        return baos.toByteArray();
    }

    public boolean readable(byte[] val) {
        boolean read = true;
        for (int i = 0; i < val.length; ++i) {
            if (val[i] >= 32 && val[i] <= 126) continue;
            read = false;
        }
        return read;
    }

    public void setReadable(boolean readable) {
        this.isReadable = readable;
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    public int getValType() {
        return this.itsVal[0];
    }

    public String getValTypeString() {
        if (this.itsVal[0] == 2) {
            return "Integer";
        }
        if (this.itsVal[0] == 4) {
            return "Octet String";
        }
        if (this.itsVal[0] == 5) {
            return "Null";
        }
        if (this.itsVal[0] == 6) {
            return "Object Identifier";
        }
        if (this.itsVal[0] == 64) {
            return "IP Address";
        }
        if (this.itsVal[0] == 65) {
            return "Counter";
        }
        if (this.itsVal[0] == 66) {
            return "Gauge";
        }
        if (this.itsVal[0] == 67) {
            return "Timeticks";
        }
        return "Unknown";
    }

    public OBJECT_IDENTIFIER getOID() {
        return this.itsOID;
    }

    public static final int[] getLength(byte[] data, int offset) {
        int length;
        if ((length = data[offset++]) < 0) {
            length += 256;
        }
        int numbytes = 1;
        if (length == 129) {
            if ((length = data[offset++]) < 0) {
                length += 256;
            }
            numbytes = 2;
        } else if (length == 130) {
            if ((length = new BigInteger(new byte[]{data[offset++], data[offset++]}).intValue()) < 0) {
                length += 256;
            }
            numbytes = 3;
        }
        return new int[]{length, numbytes};
    }

    public void updateFields(byte[] value) throws Exception {
        int i;
        this.setData(value);
        if (value.length == 0) {
            throw new InvalidLengthException(typeInfo);
        }
        if (value[0] != 48) {
            throw new UnsupportedTypeException(typeInfo, value[0]);
        }
        int totallen = TLV_Mib.getLength(value, 1)[0];
        int lenbytes = TLV_Mib.getLength(value, 1)[1];
        int oidlen = TLV_Mib.getLength(value, 2 + lenbytes)[0];
        int oidlenbytes = TLV_Mib.getLength(value, 2 + lenbytes)[1];
        byte[] oidbytes = new byte[oidlen + 1 + oidlenbytes];
        for (i = 0; i < oidbytes.length; ++i) {
            oidbytes[i] = value[i + 1 + lenbytes];
        }
        this.itsOID = (OBJECT_IDENTIFIER)OBJECT_IDENTIFIER.getTemplate().decode(new ByteArrayInputStream(oidbytes));
        this.itsVal = new byte[totallen - (1 + oidlenbytes + oidlen)];
        for (i = 0; i < this.itsVal.length; ++i) {
            this.itsVal[i] = value[i + oidlen + 1 + oidlenbytes + 1 + lenbytes];
        }
    }

    @Override
    public String getShowValue() {
        try {
            return this.itsOID.toString() + ", " + this.getValTypeString() + ", " + this.getValShowValue();
        }
        catch (Exception exception) {
            return "an error has occurred.";
        }
    }

    public String getValShowValue() throws Exception {
        byte[] val = new byte[this.itsVal.length - (1 + TLV_Mib.getLength(this.itsVal, 1)[1])];
        for (int i = 0; i < val.length; ++i) {
            val[i] = this.itsVal[i + 1 + TLV_Mib.getLength(this.itsVal, 1)[1]];
        }
        if (this.getValType() == 2) {
            return "" + new BigInteger(val).intValue();
        }
        if (this.getValType() == 4) {
            this.setReadable(this.readable(val));
            Binary2Plaintext b2p = new Binary2Plaintext(val);
            if (this.isReadable) {
                return new String(val);
            }
            return "0x" + b2p.getHexRepresentation();
        }
        if (this.getValType() == 5) {
            return "";
        }
        if (this.getValType() == 6) {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.itsVal);
            OBJECT_IDENTIFIER oid = (OBJECT_IDENTIFIER)OBJECT_IDENTIFIER.getTemplate().decode(bais);
            return oid.toString();
        }
        if (this.getValType() == 64) {
            return new IPAddress(val).toString();
        }
        if (this.getValType() == 65) {
            return "" + this.getLongFromBytes(val);
        }
        if (this.getValType() == 66) {
            return "" + this.getLongFromBytes(val);
        }
        if (this.getValType() == 67) {
            return "" + this.getLongFromBytes(val);
        }
        return "";
    }

    public static void initializeKnownOIDs() throws Exception {
        TLV_Mib.initializeKnownOIDs(null);
    }

    public static void initializeKnownOIDs(String path) throws Exception {
        knownOIDs = new ArrayList();
        knownOIDStrings = new ArrayList();
        knownOIDTypes = new ArrayList();
        String filename = path == null ? "MIBS.INI" : path + "/MIBS.INI";
        List<String> l = CertUtils.readMibs(new File(filename));
        if (l.size() % 3 != 0) {
            throw new Exception("invalid MIBS.INI list");
        }
        Iterator<String> it = l.iterator();
        while (it.hasNext()) {
            String s = it.next();
            knownOIDStrings.add(s);
            String oids = it.next();
            OBJECT_IDENTIFIER oid = new OBJECT_IDENTIFIER(oids);
            knownOIDs.add(oid);
            knownOIDTypes.add(it.next());
        }
        knownTypes = new ArrayList();
        knownTypes.add("Integer");
        knownTypes.add("Octet String");
        knownTypes.add("Null");
        knownTypes.add("Object Identifier");
        knownTypes.add("IP Address");
        knownTypes.add("Counter");
        knownTypes.add("Gauge");
        knownTypes.add("Timeticks");
    }

    @Override
    public JPanel showGUI() {
        return new MibPanel(this);
    }

    @Override
    public String getTypeInfo() {
        OBJECT_IDENTIFIER largestMatch = this.getLargestMatch(this.getOID());
        String oidstring = "";
        if (largestMatch == null) {
            oidstring = "unknown OID " + this.getOID();
        } else {
            int index = knownOIDs.indexOf(largestMatch);
            oidstring = knownOIDStrings.get(index) + "." + OBJECT_IDENTIFIER.getDifference(largestMatch, this.getOID());
        }
        return "SNMP MIB Object(" + oidstring + ")";
    }

    public static boolean isKnown(OBJECT_IDENTIFIER oid) {
        for (OBJECT_IDENTIFIER known_oid : knownOIDs) {
            if (!oid.isSubTypeOf(known_oid)) continue;
            return true;
        }
        return false;
    }

    public OBJECT_IDENTIFIER getLargestMatch(OBJECT_IDENTIFIER oid) {
        if (!TLV_Mib.isKnown(oid)) {
            return null;
        }
        OBJECT_IDENTIFIER largestMatch = null;
        for (OBJECT_IDENTIFIER known_oid : knownOIDs) {
            if (!oid.isSubTypeOf(known_oid) || largestMatch != null && known_oid.getNumbers().length <= largestMatch.getNumbers().length) continue;
            largestMatch = known_oid;
        }
        return largestMatch;
    }
}

