/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.panels.MulticastMacAddressPanel;
import com.excentis.security.tools.Plaintext2Binary;
import javax.swing.JPanel;

public class TLV_MulticastMacAddress
extends TLV {
    public static final String typeInfo = "Multicast MAC Address";
    public static final String fullTypeInfo = "Multicast MAC Address".concat(" (42)");
    private String itsMac = null;

    public TLV_MulticastMacAddress(String s) throws InvalidLengthException, UnsupportedTypeException {
        this.itsMac = s;
        this.setType(42);
        this.setData(new Plaintext2Binary(s).getBytes());
    }

    public void setMac(String s) throws Exception {
        if (s.length() != 12) {
            throw new Exception("Multicast Mac must be 6 bytes long (12 chars), got " + s.length());
        }
        this.setData(new Plaintext2Binary(s).getBytes());
        this.itsMac = s;
    }

    public String getMac() {
        return this.itsMac;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public String getShowValue() {
        return this.itsMac;
    }

    @Override
    public JPanel showGUI() {
        return new MulticastMacAddressPanel(this);
    }
}

