/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub1types.TIMING_ProfileName;
import com.excentis.security.configfile.tlvs.tlvsub1types.TIMING_ProfileReference;
import java.util.ArrayList;

public class TLV_NetworkTimingProfile
extends SubTypedTLV {
    public static final String typeInfo = "Network Timing Profile";
    public static final String fullTypeInfo = "Network Timing Profile".concat(" (73)");
    public static final int PROFILE_REFERENCE = 1;
    public static final int PROFILE_NAME = 2;

    public TLV_NetworkTimingProfile(ArrayList<ISubTLV> subTLVs) throws InvalidLengthException, UnsupportedTypeException {
        this.setType(73);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public TLV_NetworkTimingProfile(byte[] encodedSubTypes) throws Exception {
        int length;
        this.setType(73);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new TIMING_ProfileReference(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new TIMING_ProfileName(this, this.decodeStringMinusLast(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public void addSubTLV(ISubTLV tlv) throws InvalidLengthException {
        super.addSubTLV(tlv);
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

