/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub1types.PHS_ClassifierIdentifier;
import com.excentis.security.configfile.tlvs.tlvsub1types.PHS_ClassifierReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.PHS_DSChangeAction;
import com.excentis.security.configfile.tlvs.tlvsub1types.PHS_ExtensionField;
import com.excentis.security.configfile.tlvs.tlvsub1types.PHS_Field;
import com.excentis.security.configfile.tlvs.tlvsub1types.PHS_Mask;
import com.excentis.security.configfile.tlvs.tlvsub1types.PHS_ServiceFlowIdentifier;
import com.excentis.security.configfile.tlvs.tlvsub1types.PHS_ServiceFlowReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.PHS_Size;
import com.excentis.security.configfile.tlvs.tlvsub1types.PHS_VendorSpecific;
import com.excentis.security.configfile.tlvs.tlvsub1types.PHS_Verification;
import java.util.ArrayList;

public class TLV_PHS
extends SubTypedTLV {
    public static final String typeInfo = "Payload Header Suppression";
    public static final String fullTypeInfo = "Payload Header Suppression".concat(" (26)");
    public static final int CLASSIFIER_REFERENCE = 1;
    public static final int CLASSIFIER_IDENTIFIER = 2;
    public static final int SERVICE_FLOW_REFERENCE = 3;
    public static final int SERVICE_FLOW_IDENTIFIER = 4;
    public static final int DS_CHANGE_ACTION = 5;
    public static final int PHS_FIELD = 7;
    public static final int PHS_MASK = 9;
    public static final int PHS_SIZE = 10;
    public static final int PHS_VERIFICATION = 11;
    public static final int VENDOR_SPECIFIC = 43;
    private ConfigFile itsConfigFile = null;

    public TLV_PHS(ArrayList<ISubTLV> subTLVs, ConfigFile cfg) throws InvalidLengthException, UnsupportedTypeException {
        this.setType(26);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
        this.itsConfigFile = cfg;
    }

    public TLV_PHS(byte[] encodedSubTypes, ConfigFile cfg) throws Exception {
        int length;
        this.setType(26);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new PHS_ClassifierReference(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new PHS_ClassifierIdentifier(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 3) {
                sub = new PHS_ServiceFlowReference(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 4) {
                sub = new PHS_ServiceFlowIdentifier(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 5) {
                sub = new PHS_DSChangeAction(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 7) {
                sub = new PHS_Field(this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 9) {
                sub = new PHS_Mask(this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 10) {
                sub = new PHS_Size(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 11) {
                sub = new PHS_Verification(this, value[0] == 0);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 43) {
                byte[] vendor = new byte[3];
                System.arraycopy(value, 2, vendor, 0, 3);
                if (vendor[0] == -1 && vendor[1] == -1 && vendor[2] == -1) {
                    this.getSubTLVs().add(new PHS_ExtensionField(this, value));
                    continue;
                }
                this.getSubTLVs().add(new PHS_VendorSpecific(this, value));
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
        this.itsConfigFile = cfg;
    }

    public ConfigFile getConfigFile() {
        return this.itsConfigFile;
    }

    @Override
    public void addSubTLV(ISubTLV tlv) throws InvalidLengthException {
        super.addSubTLV(tlv);
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

