/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub1types.PTPAC_CMTSPTPIPAddressConfiguration;
import com.excentis.security.configfile.tlvs.tlvsub1types.PTPAC_PTPDestinationMulticastMACAddressConfiguration;
import com.excentis.security.configfile.tlvs.tlvsub1types.PTPAC_PTPSourceIPAddressConfiguration;
import com.excentis.security.tools.Binary2Plaintext;
import java.util.ArrayList;

public class TLV_PTPAddressConfigurations
extends SubTypedTLV {
    public static final String typeInfo = "PTP Address Configurations";
    public static final String fullTypeInfo = "PTP Address Configurations".concat(" (102)");
    public static final int PTP_SOURCE_IP_ADDRESS_CONFIGURATION = 1;
    public static final int CMTS_PTP_IP_ADDRESS_CONFIGURATION = 2;
    public static final int PTP_DESTINATION_MULTICAST_MAC_ADDRESS_CONFIGURATION = 3;

    public TLV_PTPAddressConfigurations(ArrayList<ISubTLV> subTLVs) throws InvalidLengthException, UnsupportedTypeException {
        this.setType(102);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public TLV_PTPAddressConfigurations(byte[] encodedSubTypes) throws Exception {
        int length;
        this.setType(102);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new PTPAC_PTPSourceIPAddressConfiguration(this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new PTPAC_CMTSPTPIPAddressConfiguration(this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 3) {
                Binary2Plaintext b2p = new Binary2Plaintext(value);
                PTPAC_PTPDestinationMulticastMACAddressConfiguration sub2 = new PTPAC_PTPDestinationMulticastMACAddressConfiguration(this, b2p.getHexRepresentation());
                this.getSubTLVs().add(sub2);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public void addSubTLV(ISubTLV tlv) throws InvalidLengthException {
        super.addSubTLV(tlv);
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

