/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTypedTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.TLV_GenericSub;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_CMInterfaceMask;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_ClassifierActivationState;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_ClassifierIdentifier;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_ClassifierReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_DSChangeAction;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_EthernetLLCPacketClassification;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_ExtensionField;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_IEEE;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_IEEE_AH;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_IEEE_STag_CTag;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_IPPacketClassification;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_IPv6PacketClassification;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_IcmpPacketClassification;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_MPLS;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_RulePriority;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_ServiceFlowIdentifier;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_ServiceFlowReference;
import com.excentis.security.configfile.tlvs.tlvsub1types.CLAS_VendorSpecific;
import java.util.ArrayList;

public abstract class TLV_PacketClassifier
extends SubTypedTLV {
    public static final int CLASSIFIER_REFERENCE = 1;
    public static final int CLASSIFIER_IDENTIFIER = 2;
    public static final int SERVICE_FLOW_REFERENCE = 3;
    public static final int SERVICE_FLOW_IDENTIFIER = 4;
    public static final int RULE_PRIORITY = 5;
    public static final int CLASSIFIER_ACTIVATION_STATE = 6;
    public static final int DS_CHANGE_ACTION = 7;
    public static final int IP_PACKET_CLASSIFICATION_ENCODINGS = 9;
    public static final int ETHERNET_LLC_PACKET_CLASSIFICATION_ENCODINGS = 10;
    public static final int IEEE_802_PACKET_CLASSIFICATION_ENCODINGS = 11;
    public static final int IPv6_PACKET_CLASSIFICATION_ENCODINGS = 12;
    public static final int CM_INTERFACE_MASK = 13;
    public static final int IEEE802_STAG_CTAG = 14;
    public static final int IEEE802_AH = 15;
    public static final int ICMP_PACKET_CLASSIFICATION_ENCODINGS = 16;
    public static final int MPLS_CLASSIFICATION_ENCODINGS = 17;
    public static final int VENDOR_SPECIFIC = 43;
    private ConfigFile itsConfigFile = null;

    public TLV_PacketClassifier(ArrayList<ISubTLV> subTLVs, ConfigFile cfg) throws Exception {
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
        this.itsConfigFile = cfg;
    }

    public TLV_PacketClassifier(byte[] encodedSubTypes, ConfigFile cfg) throws Exception {
        int length;
        int totalLength = encodedSubTypes.length;
        this.itsConfigFile = cfg;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new CLAS_ClassifierReference(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new CLAS_ClassifierIdentifier(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 3) {
                sub = new CLAS_ServiceFlowReference(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 4) {
                sub = new CLAS_ServiceFlowIdentifier(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 5) {
                sub = new CLAS_RulePriority(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 6) {
                sub = new CLAS_ClassifierActivationState(this, this.getBooleanFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 7) {
                sub = new CLAS_DSChangeAction(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 9) {
                sub = new CLAS_IPPacketClassification((TLV)this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 10) {
                sub = new CLAS_EthernetLLCPacketClassification((TLV)this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 11) {
                sub = new CLAS_IEEE((TLV)this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 12) {
                sub = new CLAS_IPv6PacketClassification((TLV)this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 13) {
                sub = new CLAS_CMInterfaceMask(this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 16) {
                sub = new CLAS_IcmpPacketClassification((TLV)this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 14) {
                sub = new CLAS_IEEE_STag_CTag((TLV)this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 15) {
                sub = new CLAS_IEEE_AH((TLV)this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 17) {
                sub = new CLAS_MPLS((TLV)this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 43) {
                byte[] vendor = new byte[3];
                System.arraycopy(value, 2, vendor, 0, 3);
                if (vendor[0] == -1 && vendor[1] == -1 && vendor[2] == -1) {
                    this.getSubTLVs().add(new CLAS_ExtensionField(this, value));
                    continue;
                }
                this.getSubTLVs().add(new CLAS_VendorSpecific(this, value));
                continue;
            }
            if (ConfigFile.getCheatMode()) {
                sub = new TLV_GenericSub(this, type, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(this.getTypeInfo(), type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    public ConfigFile getConfigFile() {
        return this.itsConfigFile;
    }

    public int[] getUsedRefs() {
        return this.itsConfigFile.getUsedClassifierRefs();
    }

    public void setUsedRefs(int[] refs) {
        this.itsConfigFile.setUsedClassifierRefs(refs);
    }

    public void clearUsedRefs() {
        this.itsConfigFile.setUsedClassifierRefs(null);
    }

    public void addUsedRef(int ref) {
        int[] usedRefs = this.itsConfigFile.getUsedClassifierRefs();
        if (usedRefs == null) {
            usedRefs = new int[]{ref};
            this.itsConfigFile.setUsedClassifierRefs(usedRefs);
            return;
        }
        int[] dummy = new int[usedRefs.length + 1];
        for (int i = 0; i < usedRefs.length; ++i) {
            dummy[i] = usedRefs[i];
        }
        dummy[usedRefs.length] = ref;
        usedRefs = dummy;
        this.itsConfigFile.setUsedClassifierRefs(usedRefs);
    }

    public void removeUsedRef(int ref) {
        int[] usedRefs = this.itsConfigFile.getUsedClassifierRefs();
        if (usedRefs == null) {
            return;
        }
        if (this.used(ref)) {
            int[] dummy = new int[usedRefs.length - 1];
            int current = 0;
            for (int i = 0; i < usedRefs.length; ++i) {
                if (usedRefs[i] == ref) continue;
                dummy[current++] = usedRefs[i];
            }
            usedRefs = dummy;
            this.itsConfigFile.setUsedClassifierRefs(usedRefs);
            return;
        }
    }

    public boolean used(int newref) {
        int[] usedRefs = this.itsConfigFile.getUsedClassifierRefs();
        if (usedRefs == null) {
            return false;
        }
        for (int i = 0; i < usedRefs.length; ++i) {
            if (usedRefs[i] != newref) continue;
            return true;
        }
        return false;
    }

    public int getFirstFreeRef() {
        for (int i = 1; i < 255; ++i) {
            if (this.used(i)) continue;
            return i;
        }
        return -1;
    }
}

