/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs;

import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.panels.SNMPWriteAccessPanel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.swing.JPanel;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;

public class TLV_SNMPWriteAccessControl
extends TLV {
    public static final String typeInfo = "SNMP Write-Access Control";
    public static final String fullTypeInfo = "SNMP Write-Access Control".concat(" (10)");
    private OBJECT_IDENTIFIER itsOID = null;
    private boolean disallowAccess = true;

    public TLV_SNMPWriteAccessControl(OBJECT_IDENTIFIER oid, boolean b) throws Exception {
        this.itsOID = oid;
        this.disallowAccess = b;
        this.setType(10);
        this.setData(TLV_SNMPWriteAccessControl.getBytes(oid, b));
    }

    public TLV_SNMPWriteAccessControl(byte[] value) throws Exception {
        byte[] oidbytes = new byte[value.length - 1];
        for (int i = 0; i < oidbytes.length; ++i) {
            oidbytes[i] = value[i];
        }
        this.itsOID = (OBJECT_IDENTIFIER)OBJECT_IDENTIFIER.getTemplate().decode(new ByteArrayInputStream(oidbytes));
        this.disallowAccess = value[value.length - 1] == 1;
        this.setType(10);
        this.setData(TLV_SNMPWriteAccessControl.getBytes(this.itsOID, this.disallowAccess));
    }

    public void setOID(OBJECT_IDENTIFIER oid) throws Exception {
        this.itsOID = oid;
        this.setData(TLV_SNMPWriteAccessControl.getBytes(this.itsOID, this.disallowAccess));
    }

    public void setDisallowed(boolean disallowed) throws Exception {
        this.disallowAccess = disallowed;
        this.setData(TLV_SNMPWriteAccessControl.getBytes(this.itsOID, this.disallowAccess));
    }

    public OBJECT_IDENTIFIER getOID() {
        return this.itsOID;
    }

    public boolean disallowedAccess() {
        return this.disallowAccess;
    }

    private static byte[] getBytes(OBJECT_IDENTIFIER oid, boolean b) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        oid.encode(baos);
        byte[] oidd = baos.toByteArray();
        byte[] result = new byte[oidd.length + 1];
        for (int i = 0; i < oidd.length; ++i) {
            result[i] = oidd[i];
        }
        result[oidd.length] = b ? (byte)1 : 0;
        return result;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public String getShowValue() {
        return this.itsOID.toString() + " access " + (this.disallowedAccess() ? "disallowed" : "allowed");
    }

    @Override
    public JPanel showGUI() {
        return new SNMPWriteAccessPanel(this);
    }
}

